/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bamboocloud.bcidaas.bridge.api.Packet;
import com.bamboocloud.bcidaas.cloudbridge.agent.session.MessageSender;
import com.bamboocloud.bcidaas.cloudbridge.agent.websocket.handler.MessageHandler;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorOperation;
import com.bamboocloud.bcidaas.cloudbridge.icf.component.IcfResourceConnectorComponent;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceOperationOptions;
import com.bamboocloud.bcidaas.cloudbridge.util.AppProvisionErrorUtil;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketSession;

@Component
public class AppProvisionCreateRequestHandler
implements MessageHandler<Packet.AppProvisionCreateRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppProvisionCreateRequestHandler.class);
    @Autowired
    private IcfResourceConnectorComponent icfResourceConnectorComponent;

    public Packet.MessageType getSupportedMessageType() {
        return Packet.MessageType.APP_PROVISION_CREATE_REQUEST;
    }

    public Packet.AppProvisionCreateRequest getMessage(Packet.Message message) {
        return message.getAppProvisionCreateRequest();
    }

    public void ProcessMessage(WebSocketSession session, Packet.AppProvisionCreateRequest message) {
        Packet.Message.Builder messageBuilder = Packet.Message.newBuilder();
        messageBuilder.setType(Packet.MessageType.APP_PROVISION_CREATE_RESPONSE);
        String connectorKey = message.getConnectorKey();
        String appId = message.getAppId();
        log.debug("accept app provision create request message and appId: {}, connectorKey: {}", (Object)appId, (Object)connectorKey);
        try {
            IcfResourceConnectorOperation icfResourceConnectorOperation = this.icfResourceConnectorComponent.getIcfResourceConnectorOperation(connectorKey, appId);
            Map attributeValueMap = (Map)JSON.parseObject((String)message.getAttributesValue(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            ResourceOperationOptions operationOptions = new ResourceOperationOptions();
            operationOptions.getOptions().put("APP_ID", appId);
            operationOptions.getOptions().put("CROP_ID", message.getEntId());
            String remoteId = icfResourceConnectorOperation.create(message.getObjectType(), attributeValueMap, operationOptions);
            messageBuilder.getAppProvisionCreateResponseBuilder().setRequestId(message.getRequestId()).setSuccess(true).setRemoteId(remoteId);
        }
        catch (Exception e) {
            log.error("app provision create failed. appId: {}, connectorKey: {}, message: {}", new Object[]{appId, connectorKey, e});
            Packet.AppProvisionError appProvisionError = AppProvisionErrorUtil.buildAppProvisionError((Exception)e);
            messageBuilder.getAppProvisionCreateResponseBuilder().setRequestId(message.getRequestId()).setSuccess(false).setError(appProvisionError);
        }
        boolean sendSuccess = MessageSender.sendMessageSync((WebSocketSession)session, (Packet.Message)messageBuilder.build());
        log.debug("send app provision create response message. result: {}, appId: {}", (Object)sendSuccess, (Object)appId);
    }
}

