/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.handler;

import com.alibaba.fastjson.JSON;
import com.bamboocloud.bcidaas.bridge.api.Packet;
import com.bamboocloud.bcidaas.cloudbridge.agent.session.MessageSender;
import com.bamboocloud.bcidaas.cloudbridge.agent.websocket.handler.MessageHandler;
import com.bamboocloud.bcidaas.cloudbridge.icf.EnumResourceAttributeMapper;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorOperation;
import com.bamboocloud.bcidaas.cloudbridge.icf.component.IcfResourceConnectorComponent;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceAttribute;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceSchema;
import com.bamboocloud.bcidaas.cloudbridge.util.AppProvisionErrorUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketSession;

@Component
public class AppProvisionSchemaRequestHandler
implements MessageHandler<Packet.AppProvisionSchemaRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppProvisionSchemaRequestHandler.class);
    private static final String APP_USR = "APP_USR";
    private static final String APP_ORG = "APP_ORG";
    private static Map<String, String> usrAttributeNames = new LinkedHashMap();
    private static Map<String, String> orgAttributeNames = new LinkedHashMap();
    @Autowired
    private IcfResourceConnectorComponent icfResourceConnectorComponent;

    public Packet.MessageType getSupportedMessageType() {
        return Packet.MessageType.APP_PROVISION_SCHEMA_REQUEST;
    }

    public Packet.AppProvisionSchemaRequest getMessage(Packet.Message message) {
        return message.getAppProvisionSchemaRequest();
    }

    public void ProcessMessage(WebSocketSession session, Packet.AppProvisionSchemaRequest message) {
        Packet.Message.Builder messageBuilder = Packet.Message.newBuilder();
        messageBuilder.setType(Packet.MessageType.APP_PROVISION_SCHEMA_RESPONSE);
        String connectorKey = message.getConnectorKey();
        String appId = message.getAppId();
        log.debug("accept app provision schema request message and appId: {}, connectorKey: {}", (Object)appId, (Object)connectorKey);
        try {
            IcfResourceConnectorOperation icfResourceConnectorOperation = this.icfResourceConnectorComponent.getIcfResourceConnectorOperation(connectorKey, appId);
            ResourceSchema schema = icfResourceConnectorOperation.schema();
            schema = this.convertSchema(schema);
            String schemaJson = JSON.toJSONString((Object)schema);
            messageBuilder.getAppProvisionSchemaResponseBuilder().setRequestId(message.getRequestId()).setSuccess(true).setSchema(schemaJson);
        }
        catch (Exception e) {
            log.error("app provision get schema failed. appId: {}, connectorKey: {}, message: {}", new Object[]{appId, connectorKey, e});
            Packet.AppProvisionError appProvisionError = AppProvisionErrorUtil.buildAppProvisionError((Exception)e);
            messageBuilder.getAppProvisionSchemaResponseBuilder().setRequestId(message.getRequestId()).setSuccess(false).setError(appProvisionError);
        }
        boolean sendSuccess = MessageSender.sendMessageSync((WebSocketSession)session, (Packet.Message)messageBuilder.build());
        log.debug("send app provision schema response message. result: {}, appId: {}", (Object)sendSuccess, (Object)appId);
    }

    public ResourceSchema convertSchema(ResourceSchema schema) {
        Map tempObjectAttributeMap = schema.getObjectAttributeMap();
        LinkedHashMap objectAttributeMap = new LinkedHashMap();
        for (Map.Entry entry : tempObjectAttributeMap.entrySet()) {
            String resourceAttributeKey = (String)entry.getKey();
            Map tempResourceAttributeMap = (Map)entry.getValue();
            LinkedHashMap<String, ResourceAttribute> attributeMap = new LinkedHashMap<String, ResourceAttribute>();
            for (Map.Entry resourceAttributeEntry : tempResourceAttributeMap.entrySet()) {
                String key = (String)resourceAttributeEntry.getKey();
                ResourceAttribute resourceAttribute = (ResourceAttribute)resourceAttributeEntry.getValue();
                String attributeName = this.convertAttributeName(resourceAttributeKey, key);
                attributeMap.put(attributeName, resourceAttribute);
            }
            objectAttributeMap.put(resourceAttributeKey, attributeMap);
        }
        schema.setObjectAttributeMap(objectAttributeMap);
        return schema;
    }

    public String convertAttributeName(String type, String attributeName) {
        if (APP_USR.equals(type) && usrAttributeNames.containsKey(attributeName)) {
            return (String)usrAttributeNames.get(attributeName);
        }
        if (APP_ORG.equals(type) && orgAttributeNames.containsKey(attributeName)) {
            return (String)orgAttributeNames.get(attributeName);
        }
        return attributeName;
    }

    static {
        EnumResourceAttributeMapper.APP_USR[] usrEnumResourceAttributeMappers = EnumResourceAttributeMapper.APP_USR.values();
        EnumResourceAttributeMapper.APP_ORG[] orgEnumResourceAttributeMappers = EnumResourceAttributeMapper.APP_ORG.values();
        for (EnumResourceAttributeMapper.APP_USR aPP_USR : usrEnumResourceAttributeMappers) {
            usrAttributeNames.put(aPP_USR.getAttrName(), aPP_USR.name());
        }
        for (EnumResourceAttributeMapper.APP_USR aPP_USR : orgEnumResourceAttributeMappers) {
            orgAttributeNames.put(aPP_USR.getAttrName(), aPP_USR.name());
        }
    }
}

