/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.handler;

import com.bamboocloud.bcidaas.bridge.api.Packet;
import com.bamboocloud.bcidaas.cloudbridge.agent.session.MessageSender;
import com.bamboocloud.bcidaas.cloudbridge.agent.websocket.handler.MessageHandler;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorOperation;
import com.bamboocloud.bcidaas.cloudbridge.icf.component.IcfResourceConnectorComponent;
import com.bamboocloud.bcidaas.cloudbridge.util.AppProvisionErrorUtil;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketSession;

@Component
public class AppProvisionTestRequestHandler
implements MessageHandler<Packet.AppProvisionTestRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppProvisionTestRequestHandler.class);
    @Autowired
    private IcfResourceConnectorComponent icfResourceConnectorComponent;

    public Packet.MessageType getSupportedMessageType() {
        return Packet.MessageType.APP_PROVISION_TEST_REQUEST;
    }

    public Packet.AppProvisionTestRequest getMessage(Packet.Message message) {
        return message.getAppProvisionTestRequest();
    }

    public void ProcessMessage(WebSocketSession session, Packet.AppProvisionTestRequest message) {
        Packet.Message.Builder messageBuilder = Packet.Message.newBuilder();
        messageBuilder.setType(Packet.MessageType.APP_PROVISION_TEST_RESPONSE);
        String connectorKey = message.getConnectorKey();
        String appId = message.getAppId();
        log.debug("accept app provision test request message and appId: {}, connectorKey: {}", (Object)appId, (Object)connectorKey);
        try {
            IcfResourceConnectorOperation icfResourceConnectorOperation = this.icfResourceConnectorComponent.getIcfResourceConnectorOperation(connectorKey, appId);
            boolean test = icfResourceConnectorOperation.test();
            messageBuilder.getAppProvisionTestResponseBuilder().setRequestId(message.getRequestId()).setSuccess(test);
        }
        catch (Exception e) {
            log.error("app provision test failed. appId: {}, connectorKey: {}, message: {}", new Object[]{appId, connectorKey, e});
            Packet.AppProvisionError appProvisionError = AppProvisionErrorUtil.buildAppProvisionError((Exception)e);
            messageBuilder.getAppProvisionTestResponseBuilder().setRequestId(message.getRequestId()).setSuccess(false).setError(appProvisionError);
        }
        boolean sendSuccess = MessageSender.sendMessageSync((WebSocketSession)session, (Packet.Message)messageBuilder.build());
        log.debug("send app provision test response message. result: {}, appId: {}", (Object)sendSuccess, (Object)appId);
    }
}

