/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bamboocloud.bcidaas.bridge.api.Packet;
import com.bamboocloud.bcidaas.cloudbridge.agent.session.MessageSender;
import com.bamboocloud.bcidaas.cloudbridge.agent.websocket.handler.MessageHandler;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorOperation;
import com.bamboocloud.bcidaas.cloudbridge.icf.component.IcfResourceConnectorComponent;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceOperationOptions;
import com.bamboocloud.bcidaas.cloudbridge.util.AppProvisionErrorUtil;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketSession;

@Component
public class AppProvisionUpdateRequestHandler
implements MessageHandler<Packet.AppProvisionUpdateRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppProvisionUpdateRequestHandler.class);
    @Autowired
    private IcfResourceConnectorComponent icfResourceConnectorComponent;

    public Packet.MessageType getSupportedMessageType() {
        return Packet.MessageType.APP_PROVISION_UPDATE_REQUEST;
    }

    public Packet.AppProvisionUpdateRequest getMessage(Packet.Message message) {
        return message.getAppProvisionUpdateRequest();
    }

    public void ProcessMessage(WebSocketSession session, Packet.AppProvisionUpdateRequest message) {
        Packet.Message.Builder messageBuilder = Packet.Message.newBuilder();
        messageBuilder.setType(Packet.MessageType.APP_PROVISION_UPDATE_RESPONSE);
        String connectorKey = message.getConnectorKey();
        String appId = message.getAppId();
        String remoteId = message.getRemoteId();
        log.debug("accept app provision update request message and appId: {}, connectorKey: {}, remoteId: {}", new Object[]{appId, connectorKey, remoteId});
        try {
            IcfResourceConnectorOperation icfResourceConnectorOperation = this.icfResourceConnectorComponent.getIcfResourceConnectorOperation(connectorKey, appId);
            Map attributeValueMap = (Map)JSON.parseObject((String)message.getAttributesValue(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            Map oldAttributeValueMap = (Map)JSON.parseObject((String)message.getOldAttributesValue(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            ResourceOperationOptions operationOptions = new ResourceOperationOptions();
            operationOptions.getOptions().put("APP_ID", appId);
            operationOptions.getOptions().put("CROP_ID", message.getEntId());
            operationOptions.getOptions().put("ALL_ATTRIBUTES", oldAttributeValueMap);
            String newRemoteId = icfResourceConnectorOperation.update(message.getObjectType(), remoteId, attributeValueMap, operationOptions);
            messageBuilder.getAppProvisionUpdateResponseBuilder().setRequestId(message.getRequestId()).setSuccess(true).setRemoteId(newRemoteId);
        }
        catch (Exception e) {
            log.error("app provision update failed. appId: {}, connectorKey: {}, remoteId: {}, message: {}", new Object[]{appId, connectorKey, remoteId, e});
            Packet.AppProvisionError appProvisionError = AppProvisionErrorUtil.buildAppProvisionError((Exception)e);
            messageBuilder.getAppProvisionUpdateResponseBuilder().setRequestId(message.getRequestId()).setSuccess(false).setError(appProvisionError);
        }
        boolean sendSuccess = MessageSender.sendMessageSync((WebSocketSession)session, (Packet.Message)messageBuilder.build());
        log.debug("send app provision update response message. result: {}, appId: {}, remoteId: {}", new Object[]{sendSuccess, appId, remoteId});
    }
}

