/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.icf;

import com.bamboocloud.bcidaas.cloudbridge.icf.util.IcfResourceConfigurationUtil;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceConfiguration;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceConfigurationProperty;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceConnector;
import com.bamboocloud.icf.common.l10n.CurrentLocale;
import com.bamboocloud.icf.framework.api.APIConfiguration;
import com.bamboocloud.icf.framework.api.ConnectorFacade;
import com.bamboocloud.icf.framework.api.ConnectorFacadeFactory;
import com.bamboocloud.icf.framework.api.ConnectorInfo;
import com.bamboocloud.icf.framework.api.ConnectorInfoManager;
import com.bamboocloud.icf.framework.api.ConnectorKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public abstract class IcfResourceConnectorServer {
    protected abstract ConnectorInfoManager connectorInfoManager(boolean var1);

    public ConnectorInfo connectorInfo(@NonNull ResourceConnector resourceConnector, boolean cleanCache) {
        if (resourceConnector == null) {
            throw new NullPointerException("resourceConnector is marked non-null but is null");
        }
        ConnectorInfoManager infoManager = this.connectorInfoManager(cleanCache);
        ConnectorKey key = new ConnectorKey(resourceConnector.getBundleName(), resourceConnector.getBundleVersion(), resourceConnector.getConnectorName());
        ConnectorInfo connectorInfo = infoManager.findConnectorInfo(key);
        return connectorInfo;
    }

    public ConnectorFacade connectorFacade(@NonNull ResourceConnector resourceConnector, @NonNull ResourceConfiguration resourceConfiguration) {
        if (resourceConnector == null) {
            throw new NullPointerException("resourceConnector is marked non-null but is null");
        }
        if (resourceConfiguration == null) {
            throw new NullPointerException("resourceConfiguration is marked non-null but is null");
        }
        ConnectorInfo connectorInfo = this.connectorInfo(resourceConnector, false);
        APIConfiguration apiConfiguration = connectorInfo.createDefaultAPIConfiguration();
        IcfResourceConfigurationUtil.applyResourceConfiguration((APIConfiguration)apiConfiguration, (ResourceConfiguration)resourceConfiguration);
        ConnectorFacade connector = ConnectorFacadeFactory.getInstance().newInstance(apiConfiguration);
        return connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceConnector resourceConnector(@NonNull ResourceConnector resourceConnector, Locale locale, boolean cleanCache) {
        if (resourceConnector == null) {
            throw new NullPointerException("resourceConnector is marked non-null but is null");
        }
        try {
            CurrentLocale.set((Locale)(locale != null ? locale : Locale.ENGLISH));
            ConnectorInfo connectorInfo = this.connectorInfo(resourceConnector, cleanCache);
            ConnectorKey connectorKey = connectorInfo.getConnectorKey();
            ResourceConnector _resourceConnector = this.fromConnectorKey(connectorKey);
            _resourceConnector.setConnectorDisplayNameKey(connectorInfo.getConnectorDisplayNameKey());
            _resourceConnector.setConnectorCategoryKey(connectorInfo.getConnectorCategoryKey());
            _resourceConnector.setConnectorDisplayName(connectorInfo.getConnectorDisplayName());
            _resourceConnector.setConnectorCategory(connectorInfo.getConnectorCategory());
            ResourceConnector resourceConnector2 = _resourceConnector;
            return resourceConnector2;
        }
        finally {
            CurrentLocale.clear();
        }
    }

    public List<ResourceConnector> resourceConnectors(Locale locale, boolean cleanCache) {
        ArrayList<ResourceConnector> resourceConnectors = new ArrayList<ResourceConnector>();
        CurrentLocale.set((Locale)(locale != null ? locale : Locale.ENGLISH));
        try {
            ConnectorInfoManager connectorInfoManager = this.connectorInfoManager(cleanCache);
            for (ConnectorInfo connectorInfo : connectorInfoManager.getConnectorInfos()) {
                ConnectorKey connectorKey = connectorInfo.getConnectorKey();
                ResourceConnector resourceConnector = this.fromConnectorKey(connectorKey);
                resourceConnector.setConnectorDisplayNameKey(connectorInfo.getConnectorDisplayNameKey());
                resourceConnector.setConnectorCategoryKey(connectorInfo.getConnectorCategoryKey());
                resourceConnector.setConnectorDisplayName(connectorInfo.getConnectorDisplayName());
                resourceConnector.setConnectorCategory(connectorInfo.getConnectorCategory());
                resourceConnectors.add(resourceConnector);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CurrentLocale.clear();
        }
        return resourceConnectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceConfiguration resourceConfiguration(@NonNull ResourceConnector resourceConnector, Locale locale, boolean cleanCache) {
        ResourceConfiguration resourceConfiguration;
        if (resourceConnector == null) {
            throw new NullPointerException("resourceConnector is marked non-null but is null");
        }
        ConnectorInfo connectorInfo = this.connectorInfo(resourceConnector, cleanCache);
        CurrentLocale.set((Locale)(locale != null ? locale : Locale.ENGLISH));
        try {
            APIConfiguration apiConfiguration = connectorInfo.createDefaultAPIConfiguration();
            resourceConfiguration = this.fromAPIConfiguration(apiConfiguration);
        }
        finally {
            CurrentLocale.clear();
        }
        return resourceConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(@NonNull ResourceConnector resourceConnector, @NonNull Map<String, ResourceConfigurationProperty> propertyMap, Locale locale) {
        if (resourceConnector == null) {
            throw new NullPointerException("resourceConnector is marked non-null but is null");
        }
        if (propertyMap == null) {
            throw new NullPointerException("propertyMap is marked non-null but is null");
        }
        if (locale != null && !locale.equals(Locale.ENGLISH)) {
            ConnectorInfo connectorInfo = this.connectorInfo(resourceConnector, false);
            CurrentLocale.set((Locale)locale);
            try {
                resourceConnector.setConnectorDisplayName(connectorInfo.getConnectorDisplayName());
                resourceConnector.setConnectorCategory(connectorInfo.getConnectorCategory());
                for (Map.Entry<String, ResourceConfigurationProperty> entry : propertyMap.entrySet()) {
                    String displayName = connectorInfo.getMessages().format(entry.getValue().getDisplayNameKey(), entry.getKey(), new Object[0]);
                    String helpMessage = connectorInfo.getMessages().format(entry.getValue().getHelpMessageKey(), "", new Object[0]);
                    String group = connectorInfo.getMessages().format(entry.getValue().getGroupKey(), "", new Object[0]);
                    entry.getValue().setDisplayName(displayName);
                    entry.getValue().setHelpMesssage(helpMessage);
                    entry.getValue().setGroup(group);
                }
            }
            finally {
                CurrentLocale.clear();
            }
        }
    }

    public void test() {
        this.connectorInfoManager(false);
    }

    private ResourceConnector fromConnectorKey(ConnectorKey connectorKey) {
        ResourceConnector resourceConnector = new ResourceConnector(connectorKey.getBundleName(), connectorKey.getBundleVersion(), connectorKey.getConnectorName());
        return resourceConnector;
    }

    private ResourceConfiguration fromAPIConfiguration(APIConfiguration apiConfiguration) {
        ResourceConfiguration resourceConfiguration = IcfResourceConfigurationUtil.fromApiConfiguration((APIConfiguration)apiConfiguration);
        return resourceConfiguration;
    }
}

