/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.icf;

import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorServer;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorServerLocal;
import com.bamboocloud.bcidaas.cloudbridge.icf.exception.ConnectorBundleDirectoryNotExistException;
import com.bamboocloud.icf.framework.api.ConnectorInfoManager;
import com.bamboocloud.icf.framework.api.ConnectorInfoManagerFactory;
import com.bamboocloud.icf.framework.api.ConnectorKey;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class IcfResourceConnectorServerLocal
extends IcfResourceConnectorServer {
    public static final List<String> connectorKey = new ArrayList();
    protected final String bundleDirectory;

    public IcfResourceConnectorServerLocal(String bundleDirectory) {
        this.bundleDirectory = bundleDirectory;
        ConnectorInfoManager infoManager = this.connectorInfoManager(false);
        List connectorInfos = infoManager.getConnectorInfos();
        connectorInfos.forEach(c -> {
            ConnectorKey connectorKey = c.getConnectorKey();
            connectorKey.add(new StringBuffer().append(connectorKey.getBundleName()).append(":").append(connectorKey.getBundleVersion()).append(":").append(connectorKey.getConnectorName()).toString());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectorInfoManager connectorInfoManager(boolean cleanCache) {
        if (cleanCache || BundleUrlCache.INSTANCE.urls == null) {
            BundleUrlCache bundleUrlCache = BundleUrlCache.INSTANCE;
            synchronized (bundleUrlCache) {
                if (cleanCache) {
                    BundleUrlCache.INSTANCE.urls = null;
                }
                if (BundleUrlCache.INSTANCE.urls == null) {
                    BundleUrlCache.INSTANCE.urls = this.getBundleURLs();
                }
            }
        }
        if (cleanCache) {
            ConnectorInfoManagerFactory.getInstance().clearLocalCache();
        }
        return ConnectorInfoManagerFactory.getInstance().getLocalManager(BundleUrlCache.INSTANCE.urls);
    }

    protected URL[] getBundleURLs() {
        File bundleDir = new File(this.bundleDirectory);
        if (!bundleDir.exists() || !bundleDir.isDirectory()) {
            throw new ConnectorBundleDirectoryNotExistException("File does not exist or is not a directory");
        }
        File[] jars = bundleDir.listFiles((dir, name) -> name.endsWith(".jar"));
        ArrayList<URL> result = new ArrayList<URL>();
        for (File jar : jars) {
            try {
                result.add(jar.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return result.toArray(new URL[result.size()]);
    }
}

