/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.icf;

import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorOperation;
import com.bamboocloud.bcidaas.cloudbridge.icf.util.IcfResourceResultUtil;
import com.bamboocloud.bcidaas.cloudbridge.icf.util.IcfResourceSchemaUtil;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceObjectResult;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceObjectResultSearch;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceObjectResultsHandlerSearch;
import com.bamboocloud.icf.framework.common.objects.ConnectorObject;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import com.bamboocloud.icf.framework.common.objects.SearchResult;
import com.bamboocloud.icf.framework.spi.SearchResultsHandler;
import java.util.Map;

public class IcfSearchResultsHandlerImpl
implements SearchResultsHandler {
    private final IcfResourceConnectorOperation operation;
    private final EnumResourceObjectResultsHandlerSearch handler;

    public IcfSearchResultsHandlerImpl(IcfResourceConnectorOperation operation, EnumResourceObjectResultsHandlerSearch handler) {
        this.operation = operation;
        this.handler = handler;
    }

    public void handleResult(SearchResult searchResult) {
        ResourceObjectResultSearch result4Search = IcfResourceResultUtil.fromSearchResult((SearchResult)searchResult);
        this.handler.handleResult(result4Search);
    }

    public boolean handle(ConnectorObject connectorObject) {
        String objectTypeName = IcfResourceSchemaUtil.fromObjectClass((ObjectClass)connectorObject.getObjectClass(), (boolean)false);
        String uidValue = connectorObject.getUid().getSingleValue();
        String nameValue = connectorObject.getName().getSingleValue();
        if (uidValue == null || uidValue.isEmpty()) {
            throw new RuntimeException("'uidValue' must be not empty.");
        }
        if (nameValue == null || nameValue.isEmpty()) {
            throw new RuntimeException("'nameValue' must be not empty.");
        }
        ResourceObjectResult objectResult = new ResourceObjectResult(objectTypeName, uidValue, nameValue);
        Map resourceAttributeValues = this.operation.fromAttributes(objectTypeName, connectorObject.getAttributes());
        objectResult.setAttributeValueMap(resourceAttributeValues);
        boolean result = this.handler.handle(objectResult);
        return result;
    }
}

