/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.icf.component;

import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnector;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorOperation;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorServer;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorServerLocal;
import com.bamboocloud.bcidaas.cloudbridge.icf.component.LoadConnectorConfigComponent;
import com.bamboocloud.bcidaas.cloudbridge.icf.config.IcfResourceConnectorsConfigurationProperties;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceConfiguration;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceConfigurationProperty;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceConnector;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceValueType;
import com.bamboocloud.bcidaas.cloudbridge.resource.util.ResourceAttributeValueMapBuilder;
import com.bamboocloud.bcidaas.cloudbridge.resource.util.ResourceConfigurationPropertyMapBuilder;
import com.bamboocloud.bcidaas.common.encrypt.ValueEncryptorUtil;
import com.bamboocloud.icf.common.l10n.CurrentLocale;
import com.bamboocloud.icf.framework.api.ConnectorInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={IcfResourceConnectorsConfigurationProperties.class})
public class IcfResourceConnectorComponent
implements InitializingBean,
DisposableBean {
    private static final String bundleDirectory = "/connector";
    private static final String CONFIG_FILE_TYPE = ".properties";
    private static volatile IcfResourceConnectorServer icfResourceConnectorServer;
    @Autowired
    @Lazy
    private LoadConnectorConfigComponent loadConnectorConfigComponent;

    public void afterPropertiesSet() {
        String jarPath = new ApplicationHome(this.getClass()).getSource().getParentFile().toString();
        icfResourceConnectorServer = new IcfResourceConnectorServerLocal(jarPath + bundleDirectory);
    }

    public void destroy() {
    }

    public IcfResourceConnectorServer getIcfResourceConnectorServer() {
        return icfResourceConnectorServer;
    }

    public IcfResourceConnector getIcfResourceConnector(@NonNull String connectorKey, boolean cleanCache) {
        if (connectorKey == null) {
            throw new NullPointerException("connectorKey is marked non-null but is null");
        }
        ResourceConnector resourceConnector = new ResourceConnector(connectorKey);
        ConnectorInfo connectorInfo = this.getIcfResourceConnectorServer().connectorInfo(resourceConnector, cleanCache);
        IcfResourceConnector icfResourceConnector = new IcfResourceConnector(connectorInfo);
        return icfResourceConnector;
    }

    public ResourceConnector getConnectorInfo(@NonNull String connectorKey, Locale locale, boolean cleanCache) {
        if (connectorKey == null) {
            throw new NullPointerException("connectorKey is marked non-null but is null");
        }
        ResourceConnector resourceConnector = new ResourceConnector(connectorKey);
        return this.getIcfResourceConnectorServer().resourceConnector(resourceConnector, locale, cleanCache);
    }

    public ResourceConfiguration getConnectorResourceConfiguration(@NonNull String connectorKey, Locale locale, boolean cleanCache) {
        if (connectorKey == null) {
            throw new NullPointerException("connectorKey is marked non-null but is null");
        }
        ResourceConnector resourceConnector = new ResourceConnector(connectorKey);
        return this.getIcfResourceConnectorServer().resourceConfiguration(resourceConnector, locale, cleanCache);
    }

    public List<String> getConnectorKeys() {
        LinkedList<String> connectorKeys = new LinkedList<String>();
        List resourceConnectors = icfResourceConnectorServer.resourceConnectors(null, false);
        for (ResourceConnector resourceConnector : resourceConnectors) {
            String connectorKey = resourceConnector.getBundleName() + ":" + resourceConnector.getBundleVersion() + ":" + resourceConnector.getConnectorName();
            connectorKeys.add(connectorKey);
        }
        return connectorKeys;
    }

    public IcfResourceConnectorOperation getIcfResourceConnectorOperation(String connectorKey, String appId) throws IOException {
        CurrentLocale.set((Locale)LocaleContextHolder.getLocale());
        IcfResourceConnector icfResourceConnector = this.getIcfResourceConnector(connectorKey, false);
        ResourceConfiguration resourceConfiguration = this.getConnectorResourceConfiguration(connectorKey, LocaleContextHolder.getLocale(), false);
        Map connectorConfigurationProperties = resourceConfiguration.getPropertyMap();
        Map connectorConfig = this.loadConnectorConfigComponent.getConnectorConfig(appId);
        ResourceAttributeValueMapBuilder resourceAttributeValueMapBuilder = ResourceAttributeValueMapBuilder.newInstance();
        for (Map.Entry entry : connectorConfigurationProperties.entrySet()) {
            String propertyName = (String)entry.getKey();
            ResourceConfigurationProperty property = (ResourceConfigurationProperty)entry.getValue();
            EnumResourceValueType type = property.getType();
            boolean multiValued = property.isMultiValued();
            Object value = connectorConfig.get(propertyName);
            if (value == null) {
                resourceAttributeValueMapBuilder.add(propertyName, type, multiValued, new String[0]);
                continue;
            }
            ArrayList<String> valueList = new ArrayList<String>();
            if (value instanceof Collection) {
                ArrayList values = (ArrayList)value;
                if (EnumResourceValueType.GUARDED_STRING.equals((Object)type) || EnumResourceValueType.GUARDED_BYTEARRAY.equals((Object)type)) {
                    for (Object obj : values) {
                        value = ValueEncryptorUtil.encrypt((String)obj.toString());
                        valueList.add(value.toString());
                    }
                } else {
                    valueList.addAll((ArrayList)value);
                }
            } else {
                if (EnumResourceValueType.GUARDED_STRING.equals((Object)type) || EnumResourceValueType.GUARDED_BYTEARRAY.equals((Object)type)) {
                    value = ValueEncryptorUtil.encrypt((String)value.toString());
                }
                valueList.add(value.toString());
            }
            resourceAttributeValueMapBuilder.add(propertyName, type, multiValued, valueList.toArray(new String[valueList.size()]));
        }
        Map properties = resourceAttributeValueMapBuilder.build();
        resourceConfiguration.setPropertyMap(ResourceConfigurationPropertyMapBuilder.from((Map)properties).build());
        return icfResourceConnector.createConnectorOperation(resourceConfiguration, null);
    }
}

