/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.icf.component;

import com.bamboocloud.bcidaas.cloudbridge.agent.encrypt.AESDecryptionManager;
import com.bamboocloud.bcidaas.cloudbridge.agent.encrypt.EncryptionKeyManager;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.YamlMapFactoryBean;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class LoadConnectorConfigComponent
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoadConnectorConfigComponent.class);
    private static final String CONFIG_FILE_PATH = "/config/";
    private static final String CONFIG_FILE_TYPE = ".yml";
    private static Map<String, Map<String, Object>> appIdConfigMap = new HashMap();
    private String encryptionKeyCache;

    public void afterPropertiesSet() throws Exception {
        String configParentPath = new ApplicationHome(this.getClass()).getSource().getParentFile().toString() + "/config/";
        log.info("load connector config, file path is: {}", (Object)configParentPath);
        File file = new File(configParentPath);
        String[] fileList = file.list();
        if (fileList != null && fileList.length > 0) {
            for (String fileName : fileList) {
                int index = fileName.lastIndexOf(".yml");
                if (index <= 0) continue;
                Map connectorConfig = LoadConnectorConfigComponent.loadConnectorConfig((String)(configParentPath + fileName));
                connectorConfig.forEach((name, value) -> {
                    String cipherStr;
                    if (value instanceof String && (cipherStr = (String)value).startsWith("{AES_GCM}")) {
                        String encryptionKey = this.getEncryptionKeyCache();
                        String decryptedValue = new String(AESDecryptionManager.decrypt((String)encryptionKey, (byte[])AESDecryptionManager.parseHexStr2Byte((String)cipherStr.substring("{AES_GCM}".length()))), StandardCharsets.UTF_8);
                        connectorConfig.put(name, decryptedValue);
                    }
                });
                String appId = fileName.substring(0, fileName.lastIndexOf(".yml"));
                appIdConfigMap.put(appId, connectorConfig);
            }
        } else {
            log.error("can not find connector config file in {} directory", (Object)configParentPath);
        }
    }

    private String getEncryptionKeyCache() {
        if (StringUtils.isNotEmpty((CharSequence)this.encryptionKeyCache)) {
            return this.encryptionKeyCache;
        }
        String encryptionKey = EncryptionKeyManager.getEncryptionKey();
        if (StringUtils.isNotEmpty((CharSequence)encryptionKey)) {
            this.encryptionKeyCache = encryptionKey;
            return this.encryptionKeyCache;
        }
        throw new IllegalArgumentException("Read encryptionKey failed, check /config/encryptionKey.");
    }

    private static Map<String, Object> loadConnectorConfig(String configFullPath) {
        Map<String, Object> config = new HashMap<String, Object>(16);
        YamlMapFactoryBean yamlMapFactoryBean = new YamlMapFactoryBean();
        try {
            yamlMapFactoryBean.setResources(new Resource[]{new FileSystemResource(configFullPath)});
            config = yamlMapFactoryBean.getObject();
        }
        catch (Exception e) {
            log.error(configFullPath, (Throwable)e);
        }
        return config;
    }

    public Map<String, Object> getConnectorConfig(String appId) {
        return appIdConfigMap.get(appId) != null ? (Map)appIdConfigMap.get(appId) : new HashMap();
    }
}

