/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.icf.util;

import com.bamboocloud.bcidaas.cloudbridge.icf.util.IcfResourceValueFormatFilter;
import com.bamboocloud.bcidaas.cloudbridge.icf.util.IcfResourceValueParseFilter;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceAttribute;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceAttributeValue;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceAttributeFlag;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceValueType;
import com.bamboocloud.bcidaas.cloudbridge.resource.util.ResourceValueFormatFilter;
import com.bamboocloud.bcidaas.cloudbridge.resource.util.ResourceValueParseFilter;
import com.bamboocloud.bcidaas.cloudbridge.resource.util.ResourceValueUtil;
import com.bamboocloud.icf.common.security.GuardedByteArray;
import com.bamboocloud.icf.common.security.GuardedString;
import com.bamboocloud.icf.framework.common.objects.Attribute;
import com.bamboocloud.icf.framework.common.objects.AttributeBuilder;
import com.bamboocloud.icf.framework.common.objects.AttributeInfo;
import com.bamboocloud.icf.framework.common.objects.AttributeInfoBuilder;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class IcfResourceAttributeUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IcfResourceAttributeUtil.class);
    public static final Map<Class<?>, EnumResourceValueType> SUPPORTED_VALUE_TYPE_MAPPING;
    public static final Map<EnumResourceValueType, Class<?>> SUPPORTED_VALUE_TYPE_REVERSE_MAPPING;

    public static EnumResourceValueType fromClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("'clazz' must be not null.");
        }
        if (Map.class.isAssignableFrom(clazz)) {
            clazz = Map.class;
        }
        if (!SUPPORTED_VALUE_TYPE_MAPPING.containsKey(clazz)) {
            throw new IllegalArgumentException("'clazz' cannot be supported, clazz=" + clazz.getName());
        }
        return (EnumResourceValueType)SUPPORTED_VALUE_TYPE_MAPPING.get(clazz);
    }

    public static Class<?> toClass(EnumResourceValueType type) {
        if (type == null) {
            throw new IllegalArgumentException("'type' must be not null.");
        }
        return (Class)SUPPORTED_VALUE_TYPE_REVERSE_MAPPING.get(type);
    }

    public static ResourceAttribute fromAttributeInfo(AttributeInfo attributeInfo) {
        if (attributeInfo == null) {
            throw new IllegalArgumentException("'attributeInfo' must be not null.");
        }
        Class clazz = attributeInfo.getType();
        EnumResourceValueType type = IcfResourceAttributeUtil.fromClass((Class)clazz);
        ResourceAttribute resourceAttribute = new ResourceAttribute(type);
        resourceAttribute.setLabel(attributeInfo.getLabel());
        resourceAttribute.setDescription(attributeInfo.getDescription());
        if (attributeInfo.getFlags() != null) {
            resourceAttribute.setRequired(attributeInfo.getFlags().contains(AttributeInfo.Flags.REQUIRED));
            resourceAttribute.setMultiValued(attributeInfo.getFlags().contains(AttributeInfo.Flags.MULTIVALUED));
            ArrayList<EnumResourceAttributeFlag> flags = new ArrayList<EnumResourceAttributeFlag>();
            if (attributeInfo.getFlags().contains(AttributeInfo.Flags.NOT_CREATABLE)) {
                flags.add(EnumResourceAttributeFlag.NOT_CREATABLE);
            }
            if (attributeInfo.getFlags().contains(AttributeInfo.Flags.NOT_UPDATEABLE)) {
                flags.add(EnumResourceAttributeFlag.NOT_UPDATEABLE);
            }
            if (attributeInfo.getFlags().contains(AttributeInfo.Flags.NOT_READABLE)) {
                flags.add(EnumResourceAttributeFlag.NOT_READABLE);
            }
            if (attributeInfo.getFlags().contains(AttributeInfo.Flags.NOT_RETURNED_BY_DEFAULT)) {
                flags.add(EnumResourceAttributeFlag.NOT_RETURNED_BY_DEFAULT);
            }
            resourceAttribute.setFlags(flags);
        }
        return resourceAttribute;
    }

    public static AttributeInfo toAttributeInfo(String attributeName, ResourceAttribute resourceAttribute) {
        if (attributeName == null || attributeName.isEmpty()) {
            throw new IllegalArgumentException("'attributeName' must be not null.");
        }
        if (resourceAttribute == null) {
            throw new IllegalArgumentException("'resourceAttribute' must be not null.");
        }
        if (resourceAttribute.getType() == null) {
            throw new IllegalArgumentException("'resourceAttribute.type' must be not null.");
        }
        Class clazz = IcfResourceAttributeUtil.toClass((EnumResourceValueType)resourceAttribute.getType());
        AttributeInfoBuilder attributeInfoBuilder = new AttributeInfoBuilder(attributeName, clazz);
        attributeInfoBuilder.setRequired(resourceAttribute.isRequired());
        attributeInfoBuilder.setMultiValued(resourceAttribute.isMultiValued());
        if (resourceAttribute.getFlags() != null) {
            for (EnumResourceAttributeFlag flag : resourceAttribute.getFlags()) {
                if (EnumResourceAttributeFlag.NOT_CREATABLE.equals((Object)flag)) {
                    attributeInfoBuilder.setCreateable(false);
                    continue;
                }
                if (EnumResourceAttributeFlag.NOT_UPDATEABLE.equals((Object)flag)) {
                    attributeInfoBuilder.setUpdateable(false);
                    continue;
                }
                if (EnumResourceAttributeFlag.NOT_READABLE.equals((Object)flag)) {
                    attributeInfoBuilder.setReadable(false);
                    continue;
                }
                if (!EnumResourceAttributeFlag.NOT_RETURNED_BY_DEFAULT.equals((Object)flag)) continue;
                attributeInfoBuilder.setReturnedByDefault(false);
            }
        }
        return attributeInfoBuilder.build();
    }

    public static ResourceAttributeValue fromAttribute(Attribute attribute, EnumResourceValueType type, boolean multiValued) {
        if (attribute == null) {
            throw new IllegalArgumentException("'attribute' must be not null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("'type' must be not null.");
        }
        ArrayList<String> values = new ArrayList<String>();
        List _values = attribute.getValue();
        if (_values != null && !_values.isEmpty()) {
            if (!multiValued) {
                Iterator _value = _values.get(0);
                if (_value != null) {
                    String value = ResourceValueUtil.format(_value, (EnumResourceValueType)type, (ResourceValueFormatFilter)IcfResourceValueFormatFilter.INSTANCE);
                    values.add(value);
                }
            } else {
                for (Object _value : _values) {
                    if (_value == null) continue;
                    String value = ResourceValueUtil.format(_value, (EnumResourceValueType)type, (ResourceValueFormatFilter)IcfResourceValueFormatFilter.INSTANCE);
                    values.add(value);
                }
            }
        }
        ResourceAttributeValue resourceAttributeValue = new ResourceAttributeValue(type, multiValued, values.toArray(new String[0]));
        return resourceAttributeValue;
    }

    public static Attribute toAttribute(String attributeName, ResourceAttributeValue resourceAttributeValue) {
        if (attributeName == null || attributeName.isEmpty()) {
            throw new IllegalArgumentException("'attributeName' must be not blank.");
        }
        if (resourceAttributeValue == null) {
            throw new IllegalArgumentException("'resourceAttributeValue' must be not null.");
        }
        EnumResourceValueType type = resourceAttributeValue.getType();
        ArrayList<Object> values = new ArrayList<Object>();
        List _values = resourceAttributeValue.getValues();
        if (_values != null && !_values.isEmpty()) {
            for (String _value : _values) {
                Object value = ResourceValueUtil.parse((String)_value, (EnumResourceValueType)type, (ResourceValueParseFilter)IcfResourceValueParseFilter.INSTANCE);
                values.add(value);
            }
        } else {
            values.addAll(_values);
        }
        return AttributeBuilder.build((String)attributeName, values);
    }

    public static Map<String, List<String>> toMap(Map<String, ResourceAttributeValue> attributeValueMap) {
        LinkedHashMap<String, List> data = null;
        if (attributeValueMap != null && !attributeValueMap.isEmpty()) {
            data = new LinkedHashMap<String, List>();
            for (Map.Entry<String, ResourceAttributeValue> entry : attributeValueMap.entrySet()) {
                data.put(entry.getKey(), entry.getValue().getValues());
            }
        }
        return data;
    }

    static {
        LinkedHashMap<Class<Object>, EnumResourceValueType> mapping = new LinkedHashMap<Class<Object>, EnumResourceValueType>();
        mapping.put(String.class, EnumResourceValueType.STRING);
        mapping.put(GuardedString.class, EnumResourceValueType.GUARDED_STRING);
        mapping.put(GuardedByteArray.class, EnumResourceValueType.GUARDED_BYTEARRAY);
        mapping.put(Boolean.class, EnumResourceValueType.BOOLEAN);
        mapping.put(Boolean.TYPE, EnumResourceValueType.BOOLEAN);
        mapping.put(Integer.class, EnumResourceValueType.INTEGER);
        mapping.put(Integer.TYPE, EnumResourceValueType.INTEGER);
        mapping.put(Long.class, EnumResourceValueType.LONG);
        mapping.put(Long.TYPE, EnumResourceValueType.LONG);
        mapping.put(Character.class, EnumResourceValueType.CHAR);
        mapping.put(Character.TYPE, EnumResourceValueType.CHAR);
        mapping.put(Double.class, EnumResourceValueType.DOUBLE);
        mapping.put(Double.TYPE, EnumResourceValueType.DOUBLE);
        mapping.put(Float.class, EnumResourceValueType.FLOAT);
        mapping.put(Float.TYPE, EnumResourceValueType.FLOAT);
        mapping.put(Byte.class, EnumResourceValueType.BYTE);
        mapping.put(Byte.TYPE, EnumResourceValueType.BYTE);
        mapping.put(byte[].class, EnumResourceValueType.BYTEARRAY);
        mapping.put(BigInteger.class, EnumResourceValueType.BIG_INTEGER);
        mapping.put(BigDecimal.class, EnumResourceValueType.BIG_DECIMAL);
        mapping.put(Map.class, EnumResourceValueType.MAP);
        mapping.put(ZonedDateTime.class, EnumResourceValueType.ZONED_DATETIME);
        mapping.put(Date.class, EnumResourceValueType.DATE);
        mapping.put(Timestamp.class, EnumResourceValueType.TIMESTAMP);
        mapping.put(java.util.Date.class, EnumResourceValueType.DATETIME);
        mapping.put(URI.class, EnumResourceValueType.URI);
        mapping.put(File.class, EnumResourceValueType.FILE);
        SUPPORTED_VALUE_TYPE_MAPPING = Collections.unmodifiableMap(mapping);
        LinkedHashMap<EnumResourceValueType, Class> reverseMapping = new LinkedHashMap<EnumResourceValueType, Class>();
        for (Map.Entry entry : mapping.entrySet()) {
            if (reverseMapping.containsKey(entry.getValue()) && ((Class)entry.getKey()).isPrimitive()) continue;
            reverseMapping.put((EnumResourceValueType)entry.getValue(), (Class)entry.getKey());
        }
        SUPPORTED_VALUE_TYPE_REVERSE_MAPPING = Collections.unmodifiableMap(reverseMapping);
    }
}

