/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.icf.util;

import com.bamboocloud.bcidaas.cloudbridge.icf.util.IcfResourceAttributeUtil;
import com.bamboocloud.bcidaas.cloudbridge.icf.util.IcfResourceConfigurationUtil;
import com.bamboocloud.bcidaas.cloudbridge.icf.util.IcfResourceSchemaUtil;
import com.bamboocloud.bcidaas.cloudbridge.icf.util.IcfResourceValueFormatFilter;
import com.bamboocloud.bcidaas.cloudbridge.icf.util.IcfResourceValueParseFilter;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceConfiguration;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceConfigurationPool;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceConfigurationProperty;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceConfigurationResultsHandler;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceApi;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceValueType;
import com.bamboocloud.bcidaas.cloudbridge.resource.util.ResourceValueFormatFilter;
import com.bamboocloud.bcidaas.cloudbridge.resource.util.ResourceValueParseFilter;
import com.bamboocloud.bcidaas.cloudbridge.resource.util.ResourceValueUtil;
import com.bamboocloud.icf.common.pooling.ObjectPoolConfiguration;
import com.bamboocloud.icf.framework.api.APIConfiguration;
import com.bamboocloud.icf.framework.api.ConfigurationProperties;
import com.bamboocloud.icf.framework.api.ConfigurationProperty;
import com.bamboocloud.icf.framework.api.ResultsHandlerConfiguration;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
public class IcfResourceConfigurationUtil {
    private IcfResourceConfigurationUtil() {
    }

    public static ResourceConfiguration fromApiConfiguration(APIConfiguration apiConfiguration) {
        if (apiConfiguration == null) {
            throw new IllegalArgumentException("'apiConfiguration' must be not null.");
        }
        ResourceConfiguration resourceConfiguration = new ResourceConfiguration();
        ConfigurationProperties configurationProperties = apiConfiguration.getConfigurationProperties();
        if (configurationProperties != null) {
            for (String propertyName : configurationProperties.getPropertyNames()) {
                ConfigurationProperty configurationProperty = configurationProperties.getProperty(propertyName);
                ResourceConfigurationProperty property = IcfResourceConfigurationUtil.fromConfigurationProperty((ConfigurationProperty)configurationProperty);
                resourceConfiguration.addProperty(propertyName, property);
            }
        }
        ResultsHandlerConfiguration resultsHandlerConfiguration = apiConfiguration.getResultsHandlerConfiguration();
        ResourceConfigurationResultsHandler resourceConfigurationResultsHandler = IcfResourceConfigurationUtil.fromResultsHandlerConfiguration((ResultsHandlerConfiguration)resultsHandlerConfiguration);
        resourceConfiguration.setResultsHandlerConfig(resourceConfigurationResultsHandler);
        Set supportedApiOperations = apiConfiguration.getSupportedOperations();
        for (Class apiOperation : supportedApiOperations) {
            EnumResourceApi api = IcfResourceSchemaUtil.fromApiOperation((Class)apiOperation);
            if (api == null) continue;
            resourceConfiguration.getSupportedApiOperations().add(api);
        }
        resourceConfiguration.setPoolingSupported(apiConfiguration.isConnectorPoolingSupported());
        if (apiConfiguration.isConnectorPoolingSupported()) {
            ObjectPoolConfiguration objectPoolConfiguration = apiConfiguration.getConnectorPoolConfiguration();
            ResourceConfigurationPool resourceConfigurationPool = IcfResourceConfigurationUtil.fromObjectPoolConfiguration((ObjectPoolConfiguration)objectPoolConfiguration);
            resourceConfiguration.setPoolConfig(resourceConfigurationPool);
        }
        return resourceConfiguration;
    }

    public static ResourceConfigurationProperty fromConfigurationProperty(ConfigurationProperty configurationProperty) {
        if (configurationProperty == null) {
            throw new IllegalArgumentException("'configurationProperty' must be not null.");
        }
        ResourceValueTypeDetail resourceValueTypeDetail = IcfResourceConfigurationUtil.parseResourceValueTypeAndMultiValued((ConfigurationProperty)configurationProperty);
        ArrayList<String> values = new ArrayList<String>();
        Object _values = configurationProperty.getValue();
        if (_values != null) {
            if (resourceValueTypeDetail.multiValued) {
                for (int i = 0; i < Array.getLength(_values); ++i) {
                    Object _value = Array.get(_values, i);
                    String value = ResourceValueUtil.format((Object)_value, (EnumResourceValueType)resourceValueTypeDetail.type, (ResourceValueFormatFilter)IcfResourceValueFormatFilter.INSTANCE);
                    values.add(value);
                }
            } else {
                String value = ResourceValueUtil.format((Object)_values, (EnumResourceValueType)resourceValueTypeDetail.type, (ResourceValueFormatFilter)IcfResourceValueFormatFilter.INSTANCE);
                values.add(value);
            }
        }
        String propertyName = configurationProperty.getName();
        ResourceConfigurationProperty resourceConfigurationProperty = new ResourceConfigurationProperty(resourceValueTypeDetail.type);
        resourceConfigurationProperty.setValues(values);
        resourceConfigurationProperty.setRequired(configurationProperty.isRequired());
        resourceConfigurationProperty.setReadOnly(configurationProperty.isReadOnly());
        resourceConfigurationProperty.setRegexp(configurationProperty.getRegexp());
        resourceConfigurationProperty.setSensitiveInfo(configurationProperty.isSensitiveInfo());
        resourceConfigurationProperty.setMultiValued(resourceValueTypeDetail.multiValued);
        resourceConfigurationProperty.setDisplayNameKey(configurationProperty.getDisplayMessageKey());
        resourceConfigurationProperty.setHelpMessageKey(configurationProperty.getHelpMessageKey());
        resourceConfigurationProperty.setGroupKey(configurationProperty.getGroupMessageKey());
        resourceConfigurationProperty.setGroup(configurationProperty.getGroup(propertyName));
        resourceConfigurationProperty.setDisplayName(configurationProperty.getDisplayName(propertyName));
        resourceConfigurationProperty.setHelpMesssage(configurationProperty.getHelpMessage(""));
        Set operations = configurationProperty.getOperations();
        HashSet<EnumResourceApi> apiSet = new HashSet<EnumResourceApi>();
        if (!operations.isEmpty()) {
            for (Class operation : operations) {
                EnumResourceApi api = IcfResourceSchemaUtil.fromApiOperation((Class)operation);
                apiSet.add(api);
            }
        }
        resourceConfigurationProperty.setOperations(apiSet);
        return resourceConfigurationProperty;
    }

    public static ResourceConfigurationResultsHandler fromResultsHandlerConfiguration(ResultsHandlerConfiguration resultsHandlerConfiguration) {
        if (resultsHandlerConfiguration == null) {
            throw new IllegalArgumentException("'resultsHandlerConfiguration' must be not null.");
        }
        ResourceConfigurationResultsHandler resourceConfigurationResultsHandler = new ResourceConfigurationResultsHandler();
        resourceConfigurationResultsHandler.setEnableAttributesToGetSearchResultsHandler(resultsHandlerConfiguration.isEnableAttributesToGetSearchResultsHandler());
        resourceConfigurationResultsHandler.setEnableCaseInsensitiveFilter(resultsHandlerConfiguration.isEnableCaseInsensitiveFilter());
        resourceConfigurationResultsHandler.setEnableFilteredResultsHandler(resultsHandlerConfiguration.isEnableFilteredResultsHandler());
        resourceConfigurationResultsHandler.setFilteredResultsHandlerInValidationMode(resultsHandlerConfiguration.isFilteredResultsHandlerInValidationMode());
        return resourceConfigurationResultsHandler;
    }

    public static ResourceConfigurationPool fromObjectPoolConfiguration(ObjectPoolConfiguration objectPoolConfiguration) {
        if (objectPoolConfiguration == null) {
            throw new IllegalArgumentException("'objectPoolConfiguration' must be not null.");
        }
        ResourceConfigurationPool resourceConfigurationPool = new ResourceConfigurationPool();
        resourceConfigurationPool.setMaxObjects(objectPoolConfiguration.getMaxObjects());
        resourceConfigurationPool.setMaxIdle(objectPoolConfiguration.getMaxIdle());
        resourceConfigurationPool.setMaxWait(objectPoolConfiguration.getMaxWait());
        resourceConfigurationPool.setMinEvictableIdleTimeMillis(objectPoolConfiguration.getMinEvictableIdleTimeMillis());
        resourceConfigurationPool.setMinIdle(objectPoolConfiguration.getMinIdle());
        return resourceConfigurationPool;
    }

    public static void applyResourceConfiguration(APIConfiguration apiConfiguration, ResourceConfiguration resourceConfiguration) {
        if (apiConfiguration == null) {
            throw new IllegalArgumentException("'apiConfiguration' must be not null.");
        }
        if (resourceConfiguration == null) {
            throw new IllegalArgumentException("'resourceConfig' must be not null.");
        }
        ConfigurationProperties configurationProperties = apiConfiguration.getConfigurationProperties();
        for (String propertyName : configurationProperties.getPropertyNames()) {
            ConfigurationProperty configurationProperty = configurationProperties.getProperty(propertyName);
            ResourceConfigurationProperty resourceConfigurationProperty = (ResourceConfigurationProperty)resourceConfiguration.getPropertyMap().get(propertyName);
            List _values = resourceConfigurationProperty == null ? null : resourceConfigurationProperty.getValues();
            if (_values == null || _values.isEmpty()) continue;
            ResourceValueTypeDetail resourceValueTypeDetail = IcfResourceConfigurationUtil.parseResourceValueTypeAndMultiValued((ConfigurationProperty)configurationProperty);
            Object values = Array.newInstance(resourceValueTypeDetail.typeClass, _values.size());
            for (int i = 0; i < _values.size(); ++i) {
                Object value = ResourceValueUtil.parse((String)((String)_values.get(i)), (EnumResourceValueType)resourceValueTypeDetail.type, (ResourceValueParseFilter)IcfResourceValueParseFilter.INSTANCE);
                Array.set(values, i, value);
            }
            if (resourceValueTypeDetail.multiValued) {
                configurationProperty.setValue(values);
                continue;
            }
            values = Array.get(values, 0);
            configurationProperty.setValue(values);
        }
        ResourceConfigurationResultsHandler resultsHandlerConfig = resourceConfiguration.getResultsHandlerConfig();
        if (resultsHandlerConfig != null) {
            apiConfiguration.getResultsHandlerConfiguration().setEnableFilteredResultsHandler(resultsHandlerConfig.isEnableFilteredResultsHandler());
            apiConfiguration.getResultsHandlerConfiguration().setEnableAttributesToGetSearchResultsHandler(resultsHandlerConfig.isEnableAttributesToGetSearchResultsHandler());
            apiConfiguration.getResultsHandlerConfiguration().setEnableCaseInsensitiveFilter(resultsHandlerConfig.isEnableCaseInsensitiveFilter());
            apiConfiguration.getResultsHandlerConfiguration().setFilteredResultsHandlerInValidationMode(resultsHandlerConfig.isFilteredResultsHandlerInValidationMode());
        }
        IcfResourceConfigurationUtil.applyConnectorPoolConfiguration((APIConfiguration)apiConfiguration, (ResourceConfiguration)resourceConfiguration);
    }

    private static void applyConnectorPoolConfiguration(APIConfiguration apiConfiguration, ResourceConfiguration resourceConfiguration) {
        ResourceConfigurationPool resourceConfigurationPool;
        if (apiConfiguration.isConnectorPoolingSupported() && (resourceConfigurationPool = resourceConfiguration.getPoolConfig()) != null) {
            if (resourceConfigurationPool.getMaxObjects() > 0) {
                apiConfiguration.getConnectorPoolConfiguration().setMaxObjects(resourceConfigurationPool.getMaxObjects());
            }
            if (resourceConfigurationPool.getMaxIdle() >= 0) {
                apiConfiguration.getConnectorPoolConfiguration().setMaxIdle(resourceConfigurationPool.getMaxIdle());
            }
            if (resourceConfigurationPool.getMaxWait() > 0L) {
                apiConfiguration.getConnectorPoolConfiguration().setMaxWait(resourceConfigurationPool.getMaxWait());
            }
            if (resourceConfigurationPool.getMinEvictableIdleTimeMillis() > 0L) {
                apiConfiguration.getConnectorPoolConfiguration().setMinEvictableIdleTimeMillis(resourceConfigurationPool.getMinEvictableIdleTimeMillis());
            }
            if (resourceConfigurationPool.getMinIdle() >= 0) {
                apiConfiguration.getConnectorPoolConfiguration().setMinIdle(resourceConfigurationPool.getMinIdle());
            }
        }
    }

    private static ResourceValueTypeDetail parseResourceValueTypeAndMultiValued(ConfigurationProperty configurationProperty) {
        ResourceValueTypeDetail resourceValueTypeDetail = new ResourceValueTypeDetail();
        if (configurationProperty.getType().isArray() && byte[].class != configurationProperty.getType()) {
            resourceValueTypeDetail.typeClass = configurationProperty.getType().getComponentType();
            resourceValueTypeDetail.multiValued = true;
        } else {
            resourceValueTypeDetail.typeClass = configurationProperty.getType();
            resourceValueTypeDetail.multiValued = false;
        }
        resourceValueTypeDetail.type = IcfResourceAttributeUtil.fromClass((Class)resourceValueTypeDetail.typeClass);
        return resourceValueTypeDetail;
    }
}

