/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.icf.util;

import com.bamboocloud.bcidaas.cloudbridge.icf.util.IcfResourceAttributeUtil;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceAttribute;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceOperationOption;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceOperationOptions;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceSchema;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceApi;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceObjectType;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceOperationOptionType;
import com.bamboocloud.icf.common.GroovyFilterBuilder;
import com.bamboocloud.icf.common.StringUtil;
import com.bamboocloud.icf.common.script.Script;
import com.bamboocloud.icf.common.security.GuardedByteArray;
import com.bamboocloud.icf.common.security.GuardedString;
import com.bamboocloud.icf.framework.api.operations.APIOperation;
import com.bamboocloud.icf.framework.api.operations.AuthenticationApiOp;
import com.bamboocloud.icf.framework.api.operations.CreateApiOp;
import com.bamboocloud.icf.framework.api.operations.DeleteApiOp;
import com.bamboocloud.icf.framework.api.operations.GetApiOp;
import com.bamboocloud.icf.framework.api.operations.ResolveUsernameApiOp;
import com.bamboocloud.icf.framework.api.operations.SchemaApiOp;
import com.bamboocloud.icf.framework.api.operations.SearchApiOp;
import com.bamboocloud.icf.framework.api.operations.SyncApiOp;
import com.bamboocloud.icf.framework.api.operations.TestApiOp;
import com.bamboocloud.icf.framework.api.operations.UpdateApiOp;
import com.bamboocloud.icf.framework.api.operations.ValidateApiOp;
import com.bamboocloud.icf.framework.common.objects.AttributeInfo;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import com.bamboocloud.icf.framework.common.objects.ObjectClassInfo;
import com.bamboocloud.icf.framework.common.objects.OperationOptionInfo;
import com.bamboocloud.icf.framework.common.objects.OperationOptions;
import com.bamboocloud.icf.framework.common.objects.OperationOptionsBuilder;
import com.bamboocloud.icf.framework.common.objects.QualifiedUid;
import com.bamboocloud.icf.framework.common.objects.Schema;
import com.bamboocloud.icf.framework.common.objects.SortKey;
import com.bamboocloud.icf.framework.common.objects.attributes.Uid;
import com.bamboocloud.icf.framework.common.objects.filter.Filter;
import groovy.lang.GroovyRuntimeException;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
public class IcfResourceSchemaUtil {
    private static final Map<EnumResourceObjectType, String> OBJECT_TYPE_MAPPING = new LinkedHashMap();
    private static final Map<String, EnumResourceObjectType> OBJECT_TYPE_REVERSE_MAPPING = new LinkedHashMap();
    private static final Map<String, String> OBJECT_TYPE_STRING_MAPPING = new LinkedHashMap();
    private static final Map<String, ObjectClass> OBJECT_TYPE_CLASS_MAPPING = new LinkedHashMap();
    private static final Map<Class<?>, EnumResourceOperationOptionType> OPERATION_OPTION_MAPPING = new LinkedHashMap();
    private static final Map<EnumResourceOperationOptionType, Class<?>> OPERATION_OPTION_REVERSE_MAPPING = new LinkedHashMap();
    private static final Map<Class<? extends APIOperation>, EnumResourceApi> API_MAPPING = new LinkedHashMap();
    private static final Map<EnumResourceApi, Class<? extends APIOperation>> API_REVERSE_MAPPING = new LinkedHashMap();

    private IcfResourceSchemaUtil() {
    }

    public static String fromObjectClass(ObjectClass objectClass, boolean ignoreUnsupported) {
        if (objectClass == null) {
            throw new IllegalArgumentException("'objectClass' must be not empty.");
        }
        return IcfResourceSchemaUtil.fromObjectClass((String)objectClass.getObjectClassValue(), (boolean)ignoreUnsupported);
    }

    public static String fromObjectClass(String objectClassValue, boolean ignoreUnsupported) {
        if (objectClassValue == null || objectClassValue.trim().isEmpty()) {
            throw new IllegalArgumentException("'objectClassValue' must be not empty.");
        }
        if (OBJECT_TYPE_REVERSE_MAPPING.containsKey(objectClassValue)) {
            return ((EnumResourceObjectType)OBJECT_TYPE_REVERSE_MAPPING.get(objectClassValue)).name();
        }
        if (ignoreUnsupported) {
            return null;
        }
        throw new IllegalArgumentException("Unsupported objectClass.");
    }

    public static ObjectClass toObjectClass(String objectTypeName) {
        if (objectTypeName == null || objectTypeName.isEmpty()) {
            throw new IllegalArgumentException("'objectType' must be not empty.");
        }
        if (OBJECT_TYPE_CLASS_MAPPING.containsKey(objectTypeName)) {
            return (ObjectClass)OBJECT_TYPE_CLASS_MAPPING.get(objectTypeName);
        }
        throw new IllegalArgumentException("Unsupported objectTypeName");
    }

    public static String fromUid(Uid uid) {
        if (uid == null || uid.getSingleValue() == null || uid.getSingleValue().isEmpty()) {
            throw new IllegalArgumentException("'uid' must be not empty.");
        }
        return uid.getSingleValue();
    }

    public static Uid toUid(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("'uid' must be not empty.");
        }
        return new Uid(uid);
    }

    public static EnumResourceApi fromApiOperation(Class<? extends APIOperation> apiOperation) {
        if (apiOperation == null) {
            throw new IllegalArgumentException("'apiOperation' must be not null.");
        }
        return (EnumResourceApi)API_MAPPING.get(apiOperation);
    }

    public static Class<? extends APIOperation> toApiOperation(EnumResourceApi api) {
        if (api == null) {
            throw new IllegalArgumentException("'api' must be not null.");
        }
        return (Class)API_REVERSE_MAPPING.get(api);
    }

    public static ResourceSchema fromSchema(Schema schema) {
        ResourceSchema resourceSchema = new ResourceSchema();
        Set objectClassInfos = schema.getObjectClassInfo();
        Map resourceObjectClassMap = IcfResourceSchemaUtil.fromObjectClassInfos((Set)objectClassInfos);
        resourceSchema.setObjectAttributeMap(resourceObjectClassMap);
        Set operationOptionInfos = schema.getOperationOptionInfo();
        Map operationOptionMap = IcfResourceSchemaUtil.fromOperationOptionInfos((Set)operationOptionInfos);
        resourceSchema.setOperationOptionMap(operationOptionMap);
        IcfResourceSchemaUtil.addApiObjectAttributeNames((ResourceSchema)resourceSchema, (Schema)schema);
        IcfResourceSchemaUtil.addApiOperationOption((ResourceSchema)resourceSchema, (Schema)schema);
        return resourceSchema;
    }

    private static void addApiObjectAttributeNames(ResourceSchema resourceSchema, Schema schema) {
        Map supportedObjectClassesByOperations = schema.getSupportedObjectClassesByOperation();
        if (supportedObjectClassesByOperations != null) {
            for (Map.Entry entry : supportedObjectClassesByOperations.entrySet()) {
                Set supportedObjectClassInfos;
                Class apiOperation = (Class)entry.getKey();
                EnumResourceApi api = IcfResourceSchemaUtil.fromApiOperation((Class)apiOperation);
                if (api == null || (supportedObjectClassInfos = (Set)entry.getValue()) == null || supportedObjectClassInfos.isEmpty()) continue;
                for (ObjectClassInfo objectClassInfo : supportedObjectClassInfos) {
                    String objectTypeName = IcfResourceSchemaUtil.fromObjectClass((String)objectClassInfo.getType(), (boolean)true);
                    if (objectTypeName == null) continue;
                    for (AttributeInfo attributeInfo : objectClassInfo.getAttributeInfo()) {
                        resourceSchema.addApiObjectAttributeName(objectTypeName, api, attributeInfo.getName());
                    }
                }
            }
        }
    }

    private static void addApiOperationOption(ResourceSchema resourceSchema, Schema schema) {
        Map supportedOptionsByOperations = schema.getSupportedOptionsByOperation();
        if (supportedOptionsByOperations != null) {
            for (Map.Entry entry : supportedOptionsByOperations.entrySet()) {
                Set supportedOperationOptionInfos;
                Class apiOperation = (Class)entry.getKey();
                EnumResourceApi api = IcfResourceSchemaUtil.fromApiOperation((Class)apiOperation);
                if (api == null || (supportedOperationOptionInfos = (Set)entry.getValue()) == null || supportedOperationOptionInfos.isEmpty()) continue;
                for (OperationOptionInfo supportedOperationOptionInfo : supportedOperationOptionInfos) {
                    resourceSchema.addApiOperationOption(api, supportedOperationOptionInfo.getName());
                }
            }
        }
    }

    private static Map<String, Map<String, ResourceAttribute>> fromObjectClassInfos(Set<ObjectClassInfo> objectClassInfos) {
        LinkedHashMap<String, Map<String, ResourceAttribute>> objectClassMap = new LinkedHashMap<String, Map<String, ResourceAttribute>>();
        if (objectClassInfos != null) {
            for (ObjectClassInfo objectClassInfo : objectClassInfos) {
                Set attributeInfos;
                String objectTypeName = IcfResourceSchemaUtil.fromObjectClass((String)objectClassInfo.getType(), (boolean)true);
                if (objectTypeName == null || (attributeInfos = objectClassInfo.getAttributeInfo()) == null || attributeInfos.isEmpty()) continue;
                LinkedHashMap<String, ResourceAttribute> resourceAttributeMap = new LinkedHashMap<String, ResourceAttribute>();
                for (AttributeInfo attributeInfo : attributeInfos) {
                    String attributeName = attributeInfo.getName();
                    ResourceAttribute resourceAttribute = IcfResourceAttributeUtil.fromAttributeInfo((AttributeInfo)attributeInfo);
                    resourceAttributeMap.put(attributeName, resourceAttribute);
                }
                objectClassMap.put(objectTypeName, resourceAttributeMap);
            }
        }
        return objectClassMap;
    }

    private static Map<String, ResourceOperationOption> fromOperationOptionInfos(Set<OperationOptionInfo> operationOptionInfos) {
        LinkedHashMap<String, ResourceOperationOption> operationOptionMap = new LinkedHashMap<String, ResourceOperationOption>();
        if (operationOptionInfos != null) {
            for (OperationOptionInfo operationOptionInfo : operationOptionInfos) {
                EnumResourceOperationOptionType type;
                String optionName = operationOptionInfo.getName();
                Class<?> clazz = operationOptionInfo.getType();
                boolean multiValued = false;
                if (clazz.isArray() && byte[].class != clazz && Byte[].class != clazz) {
                    clazz = clazz.getComponentType();
                    multiValued = true;
                }
                if ((type = (EnumResourceOperationOptionType)OPERATION_OPTION_MAPPING.get(clazz)) == null) continue;
                ResourceOperationOption resourceOperationOption = new ResourceOperationOption(type);
                resourceOperationOption.setMultiValued(multiValued);
                operationOptionMap.put(optionName, resourceOperationOption);
            }
        }
        return operationOptionMap;
    }

    public static OperationOptions toOperationOptions(ResourceOperationOptions options) {
        OperationOptionsBuilder builder = new OperationOptionsBuilder();
        if (options != null && !options.getOptions().isEmpty()) {
            String runWithPassword;
            String runAsUser;
            Map sortKeyMap;
            Integer pageSize;
            ResourceOperationOptions newOptions = new ResourceOperationOptions();
            newOptions.setOptions(options.getOptions());
            Set getAttributes = newOptions.attributesGet(true);
            if (getAttributes != null && !getAttributes.isEmpty()) {
                builder.setAttributesToGet((Collection)getAttributes);
            }
            if ((pageSize = newOptions.pageSize(true)) != null && pageSize > 0) {
                Integer pageOffset = newOptions.pageOffset(true);
                pageOffset = pageOffset != null && pageOffset >= 0 ? pageOffset : 0;
                builder.setPageSize(pageSize);
                builder.setPagedResultsOffset(pageOffset);
            }
            if ((sortKeyMap = newOptions.sortKeys(true)) != null && !sortKeyMap.isEmpty()) {
                ArrayList<SortKey> sortKeys = new ArrayList<SortKey>();
                for (Map.Entry entry : sortKeyMap.entrySet()) {
                    sortKeys.add(new SortKey((String)entry.getKey(), ResourceOperationOptions.ORDER.DESC.equals(entry.getValue())));
                }
                builder.setSortKeys(sortKeys);
            }
            if ((runAsUser = newOptions.runAsUser(true)) != null && !runAsUser.isEmpty()) {
                builder.setRunAsUser(runAsUser);
            }
            if ((runWithPassword = newOptions.runWithPassword(true)) != null && !runWithPassword.isEmpty()) {
                builder.setRunWithPassword(new GuardedString(runWithPassword.toCharArray()));
            }
            newOptions.getOptions().forEach((arg_0, arg_1) -> ((OperationOptionsBuilder)builder).setOption(arg_0, arg_1));
        }
        return builder.build();
    }

    public static Filter toFilter(String filterExpression) {
        Filter filter = null;
        try {
            if (StringUtil.isNotEmpty((String)filterExpression)) {
                filter = GroovyFilterBuilder.build((String)filterExpression);
            }
        }
        catch (GroovyRuntimeException e) {
            throw new IllegalArgumentException("Invalid Filter [" + e.getMessageWithoutLocationText() + "]");
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Invalid Filter [" + e.getMessage() + "]");
        }
        return filter;
    }

    static {
        OBJECT_TYPE_MAPPING.put(EnumResourceObjectType.APP_ORG, ObjectClass.ORGANIZATION_NAME);
        OBJECT_TYPE_MAPPING.put(EnumResourceObjectType.APP_USR, ObjectClass.ACCOUNT_NAME);
        OBJECT_TYPE_MAPPING.put(EnumResourceObjectType.APP_GRP, ObjectClass.GROUP_NAME);
        OBJECT_TYPE_MAPPING.put(EnumResourceObjectType.APP_ROL, ObjectClass.ROLE_NAME);
        for (Map.Entry entry : OBJECT_TYPE_MAPPING.entrySet()) {
            OBJECT_TYPE_REVERSE_MAPPING.put((String)entry.getValue(), (EnumResourceObjectType)entry.getKey());
            OBJECT_TYPE_STRING_MAPPING.put(((EnumResourceObjectType)entry.getKey()).name(), (String)entry.getValue());
            if (EnumResourceObjectType.APP_ORG.equals(entry.getKey())) {
                OBJECT_TYPE_CLASS_MAPPING.put(((EnumResourceObjectType)entry.getKey()).name(), ObjectClass.ORGANIZATION);
                continue;
            }
            if (EnumResourceObjectType.APP_USR.equals(entry.getKey())) {
                OBJECT_TYPE_CLASS_MAPPING.put(((EnumResourceObjectType)entry.getKey()).name(), ObjectClass.ACCOUNT);
                continue;
            }
            if (EnumResourceObjectType.APP_ROL.equals(entry.getKey())) {
                OBJECT_TYPE_CLASS_MAPPING.put(((EnumResourceObjectType)entry.getKey()).name(), ObjectClass.ROLE);
                continue;
            }
            if (!EnumResourceObjectType.APP_GRP.equals(entry.getKey())) continue;
            OBJECT_TYPE_CLASS_MAPPING.put(((EnumResourceObjectType)entry.getKey()).name(), ObjectClass.GROUP);
        }
        OPERATION_OPTION_MAPPING.put(String.class, EnumResourceOperationOptionType.STRING);
        OPERATION_OPTION_MAPPING.put(GuardedString.class, EnumResourceOperationOptionType.GUARDED_STRING);
        OPERATION_OPTION_MAPPING.put(GuardedByteArray.class, EnumResourceOperationOptionType.GUARDED_BYTEARRAY);
        OPERATION_OPTION_MAPPING.put(Long.TYPE, EnumResourceOperationOptionType.LONG);
        OPERATION_OPTION_MAPPING.put(Long.class, EnumResourceOperationOptionType.LONG);
        OPERATION_OPTION_MAPPING.put(Character.TYPE, EnumResourceOperationOptionType.CHAR);
        OPERATION_OPTION_MAPPING.put(Character.class, EnumResourceOperationOptionType.CHAR);
        OPERATION_OPTION_MAPPING.put(Double.TYPE, EnumResourceOperationOptionType.DOUBLE);
        OPERATION_OPTION_MAPPING.put(Double.class, EnumResourceOperationOptionType.DOUBLE);
        OPERATION_OPTION_MAPPING.put(Float.TYPE, EnumResourceOperationOptionType.FLOAT);
        OPERATION_OPTION_MAPPING.put(Float.class, EnumResourceOperationOptionType.FLOAT);
        OPERATION_OPTION_MAPPING.put(Integer.TYPE, EnumResourceOperationOptionType.INTEGER);
        OPERATION_OPTION_MAPPING.put(Integer.class, EnumResourceOperationOptionType.INTEGER);
        OPERATION_OPTION_MAPPING.put(Boolean.TYPE, EnumResourceOperationOptionType.BOOLEAN);
        OPERATION_OPTION_MAPPING.put(Boolean.class, EnumResourceOperationOptionType.BOOLEAN);
        OPERATION_OPTION_MAPPING.put(URI.class, EnumResourceOperationOptionType.URI);
        OPERATION_OPTION_MAPPING.put(File.class, EnumResourceOperationOptionType.FILE);
        OPERATION_OPTION_MAPPING.put(Script.class, EnumResourceOperationOptionType.SCRIPT);
        OPERATION_OPTION_MAPPING.put(ObjectClass.class, EnumResourceOperationOptionType.OBJECT_CLASS);
        OPERATION_OPTION_MAPPING.put(Uid.class, EnumResourceOperationOptionType.UID);
        OPERATION_OPTION_MAPPING.put(QualifiedUid.class, EnumResourceOperationOptionType.QUALIFIED_UID);
        OPERATION_OPTION_MAPPING.put(SortKey.class, EnumResourceOperationOptionType.SORT_KEY);
        OPERATION_OPTION_MAPPING.put(Map.class, EnumResourceOperationOptionType.MAP);
        for (Map.Entry entry : OPERATION_OPTION_MAPPING.entrySet()) {
            if (OPERATION_OPTION_REVERSE_MAPPING.containsKey(entry.getValue()) && ((Class)entry.getKey()).isPrimitive()) continue;
            OPERATION_OPTION_REVERSE_MAPPING.put((EnumResourceOperationOptionType)entry.getValue(), (Class)entry.getKey());
        }
        API_MAPPING.put(ValidateApiOp.class, EnumResourceApi.VALIDATE);
        API_MAPPING.put(TestApiOp.class, EnumResourceApi.TEST);
        API_MAPPING.put(AuthenticationApiOp.class, EnumResourceApi.AUTHENTICATION);
        API_MAPPING.put(SchemaApiOp.class, EnumResourceApi.SCHEMA);
        API_MAPPING.put(GetApiOp.class, EnumResourceApi.GET);
        API_MAPPING.put(CreateApiOp.class, EnumResourceApi.CREATE);
        API_MAPPING.put(UpdateApiOp.class, EnumResourceApi.UPDATE);
        API_MAPPING.put(DeleteApiOp.class, EnumResourceApi.DELETE);
        API_MAPPING.put(SearchApiOp.class, EnumResourceApi.SEARCH);
        API_MAPPING.put(SyncApiOp.class, EnumResourceApi.SYNC);
        API_MAPPING.put(ResolveUsernameApiOp.class, EnumResourceApi.RESOLVE_USERNAME);
        for (Map.Entry entry : API_MAPPING.entrySet()) {
            API_REVERSE_MAPPING.put((EnumResourceApi)entry.getValue(), (Class)entry.getKey());
        }
    }
}

