/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.resource;

import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceConfigurationPool;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceConfigurationProperty;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceConfigurationResultsHandler;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceApi;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class ResourceConfiguration
implements Serializable,
Cloneable {
    private final Map<String, ResourceConfigurationProperty> propertyMap = new LinkedHashMap();
    private ResourceConfigurationResultsHandler resultsHandlerConfig;
    private final Set<EnumResourceApi> supportedApiOperations = new LinkedHashSet();
    private boolean poolingSupported;
    private ResourceConfigurationPool poolConfig;
    private int defaultTimeout = 0;
    private int searchTimeout = 0;

    public Map<String, ResourceConfigurationProperty> getPropertyMap() {
        return this.propertyMap;
    }

    public void setPropertyMap(Map<String, ResourceConfigurationProperty> propertyMap) {
        if (propertyMap == null) {
            throw new IllegalArgumentException("'propertyMap' must be not null.");
        }
        this.propertyMap.clear();
        for (Map.Entry<String, ResourceConfigurationProperty> entry : propertyMap.entrySet()) {
            this.addProperty(entry.getKey(), entry.getValue());
        }
    }

    public ResourceConfiguration addProperty(String propertyName, ResourceConfigurationProperty property) {
        if (propertyName == null || propertyName.isEmpty()) {
            throw new IllegalArgumentException("'propertyName' must be not empty.");
        }
        if (property == null) {
            throw new IllegalArgumentException("'property' must be not null.");
        }
        this.propertyMap.put(propertyName, property);
        return this;
    }

    public ResourceConfigurationResultsHandler getResultsHandlerConfig() {
        return this.resultsHandlerConfig;
    }

    public void setResultsHandlerConfig(ResourceConfigurationResultsHandler resultsHandlerConfig) {
        this.resultsHandlerConfig = resultsHandlerConfig != null ? resultsHandlerConfig : new ResourceConfigurationResultsHandler();
    }

    public boolean isPoolingSupported() {
        return this.poolingSupported;
    }

    public Set<EnumResourceApi> getSupportedApiOperations() {
        return this.supportedApiOperations;
    }

    public void setSupportedApiOperations(Set<EnumResourceApi> supportedApiOperations) {
        this.supportedApiOperations.clear();
        if (supportedApiOperations != null) {
            this.supportedApiOperations.addAll(supportedApiOperations);
        }
    }

    public void setPoolingSupported(boolean poolingSupported) {
        this.poolingSupported = poolingSupported;
    }

    public ResourceConfigurationPool getPoolConfig() {
        return this.poolConfig;
    }

    public void setPoolConfig(ResourceConfigurationPool poolConfig) {
        this.poolConfig = poolConfig != null ? poolConfig : new ResourceConfigurationPool();
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(int defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public int getSearchTimeout() {
        return this.searchTimeout;
    }

    public void setSearchTimeout(int searchTimeout) {
        this.searchTimeout = searchTimeout;
    }

    @Generated
    public String toString() {
        return "ResourceConfiguration(propertyMap=" + this.getPropertyMap() + ", resultsHandlerConfig=" + this.getResultsHandlerConfig() + ", supportedApiOperations=" + this.getSupportedApiOperations() + ", poolingSupported=" + this.isPoolingSupported() + ", poolConfig=" + this.getPoolConfig() + ", defaultTimeout=" + this.getDefaultTimeout() + ", searchTimeout=" + this.getSearchTimeout() + ")";
    }
}

