/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.resource;

import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceOperationOptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceOperationOptions
implements Serializable {
    public static final String PAGE_SIZE = "PAGE_SIZE";
    public static final String PAGE_OFFSET = "PAGE_OFFSET";
    public static final String ATTRIBUTES_GET = "ATTRIBUTES_GET";
    public static final String SORT_KEYS = "SORT_KEYS";
    public static final String RUN_AS_USER = "RUN_AS_USER";
    public static final String RUN_WITH_PASSWORD = "RUN_WITH_PASSWORD";
    public static final String CUSTOM_PRAM = "CUSTOM_PRAM";
    public static final String APP_ID = "APP_ID";
    public static final String CROP_ID = "CROP_ID";
    public static final String ALL_ATTRIBUTES = "ALL_ATTRIBUTES";
    public static final String OP_PAGED_RESULTS_COOKIE = "PAGED_RESULTS_COOKIE";
    private final Map<String, Object> options = new LinkedHashMap();

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options.clear();
        if (options != null) {
            this.options.putAll(options);
        }
    }

    public ResourceOperationOptions setOption(String name, Object value) {
        this.options.put(name, value);
        return this;
    }

    public ResourceOperationOptions setPageSize(int pageSize) {
        if (pageSize > 0) {
            this.options.put("PAGE_SIZE", pageSize);
        } else {
            this.options.remove("PAGE_SIZE");
        }
        return this;
    }

    public ResourceOperationOptions setPageOffset(int pageOffset) {
        if (pageOffset >= 0) {
            this.options.put("PAGE_OFFSET", pageOffset);
        } else {
            this.options.remove("PAGE_OFFSET");
        }
        return this;
    }

    public ResourceOperationOptions setAttributesGet(String[] attributesGet) {
        if (attributesGet != null && attributesGet.length > 0) {
            this.options.put("ATTRIBUTES_GET", attributesGet);
        } else {
            this.options.remove("ATTRIBUTES_GET");
        }
        return this;
    }

    public ResourceOperationOptions setSortKeys(Map<String, ORDER> sortKeys) {
        if (sortKeys != null && !sortKeys.isEmpty()) {
            this.options.put("SORT_KEYS", sortKeys);
        } else {
            this.options.remove("SORT_KEYS");
        }
        return this;
    }

    public ResourceOperationOptions addSortKeys(String attributeName, ORDER order) {
        if (!this.options.containsKey("SORT_KEYS")) {
            this.options.put("SORT_KEYS", new LinkedHashMap());
        }
        ((Map)this.options.get("SORT_KEYS")).put(attributeName, order);
        return this;
    }

    public ResourceOperationOptions setRunAsUser(String runAsUser) {
        if (runAsUser != null && !runAsUser.isEmpty()) {
            this.options.put("RUN_AS_USER", runAsUser);
        } else {
            this.options.remove("RUN_AS_USER");
        }
        return this;
    }

    public ResourceOperationOptions setRunWithPassword(String runWithPassword) {
        if (runWithPassword != null && !runWithPassword.isEmpty()) {
            this.options.put("RUN_WITH_PASSWORD", runWithPassword);
        } else {
            this.options.remove("RUN_WITH_PASSWORD");
        }
        return this;
    }

    public Integer pageSize(boolean remove) {
        return this.parseInteger(remove ? this.options.remove("PAGE_SIZE") : this.options.get("PAGE_SIZE"));
    }

    public Integer pageOffset(boolean remove) {
        return this.parseInteger(remove ? this.options.remove("PAGE_OFFSET") : this.options.get("PAGE_OFFSET"));
    }

    public Set<String> attributesGet(boolean remove) {
        String[] array = this.parseStringArray(remove ? this.options.remove("ATTRIBUTES_GET") : this.options.get("ATTRIBUTES_GET"));
        return array != null ? new LinkedHashSet<String>(Arrays.asList(array)) : null;
    }

    public Map<String, ORDER> sortKeys(boolean remove) {
        LinkedHashMap<String, ORDER> map = new LinkedHashMap<String, ORDER>();
        Map sMap = this.parseMap(remove ? this.options.remove("SORT_KEYS") : this.options.get("SORT_KEYS"));
        if (sMap != null) {
            for (Map.Entry entry : sMap.entrySet()) {
                if (entry.getValue() == null || "".equals(entry.getValue())) continue;
                String sOrder = this.parseString(entry.getValue());
                ORDER order = ORDER.valueOf((String)sOrder);
                map.put((String)entry.getKey(), order);
            }
        }
        return map.isEmpty() ? null : map;
    }

    public String runAsUser(boolean remove) {
        return this.parseString(remove ? this.options.remove("RUN_AS_USER") : this.options.get("RUN_AS_USER"));
    }

    public String runWithPassword(boolean remove) {
        return this.parseString(remove ? this.options.remove("RUN_WITH_PASSWORD") : this.options.get("RUN_WITH_PASSWORD"));
    }

    private Integer parseInteger(Object obj) {
        Integer result = null;
        if (obj != null && !"".equals(obj)) {
            try {
                result = Integer.parseInt(obj.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private Boolean parseBoolean(Object obj) {
        Boolean result = null;
        if (obj != null && !"".equals(obj)) {
            try {
                result = Boolean.parseBoolean(obj.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private String parseString(Object obj) {
        String result = null;
        if (obj != null && !"".equals(obj)) {
            try {
                result = obj.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private String[] parseStringArray(Object obj) {
        ArrayList<String> list = null;
        if (obj != null && !"".equals(obj)) {
            ArrayList<String> _set = new ArrayList<String>();
            if (obj instanceof Collection) {
                for (Object o : (Collection)obj) {
                    String s = this.parseString(o);
                    if (s == null) continue;
                    _set.add(s);
                }
            } else if (obj.getClass().isArray()) {
                for (Object o : (Object[])obj) {
                    String s = this.parseString(o);
                    if (s == null) continue;
                    _set.add(s);
                }
            }
            if (!_set.isEmpty()) {
                list = _set;
            }
        }
        return list != null ? list.toArray(new String[0]) : null;
    }

    private Map<String, Object> parseMap(Object obj) {
        LinkedHashMap map = null;
        if (obj != null && !"".equals(obj)) {
            map = new LinkedHashMap();
            if (obj instanceof Map) {
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    String key = this.parseString(entry.getKey());
                    if (key == null) continue;
                    map.put(key, entry.getValue());
                }
            }
        }
        return map;
    }

    @Generated
    public String toString() {
        return "ResourceOperationOptions(options=" + this.getOptions() + ")";
    }
}

