/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.resource.util;

import com.alibaba.fastjson.JSON;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceValueType;
import com.bamboocloud.bcidaas.cloudbridge.resource.util.ResourceValueFormatFilter;
import com.bamboocloud.bcidaas.cloudbridge.resource.util.ResourceValueParseFilter;
import java.io.File;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Calendar;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceValueUtil {
    private static final String PATTERN_DATE = "yyyy-MM-dd";
    private static final String PATTERN_TIME = "HH:mm:ss";
    private static final String PATTERN_DATETIME = "yyyy-MM-dd HH:mm:ss";
    private static final String PATTERN_TIMESTAMP = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String UNSUPPORTED_VALUE_TYPE = "Unsupported value type.";

    private ResourceValueUtil() {
    }

    public static String format(Object value, EnumResourceValueType originType) {
        return ResourceValueUtil.format((Object)value, (EnumResourceValueType)originType, null);
    }

    public static String format(Object value, EnumResourceValueType originType, ResourceValueFormatFilter filter) {
        if (originType == null) {
            throw new IllegalArgumentException("'originType' must be not null.");
        }
        if (filter != null && value != null && !"".equals(value)) {
            value = filter.formatBefore(value, originType);
        }
        if (value != null && !"".equals(value) && !originType.getSupportedOriginClasses().contains(value.getClass())) {
            throw new IllegalArgumentException("Unsupported value class, valueClass=" + value.getClass());
        }
        String result = ResourceValueUtil.format((Object)value, (Class)originType.getTargetClass());
        if (filter != null && result != null && !result.isEmpty()) {
            result = filter.formatAfter(result, originType);
        }
        return result;
    }

    public static String format(Object value, Class<?> originClass) {
        if (originClass == null) {
            throw new IllegalArgumentException("'originClass' must be not null.");
        }
        if (value == null) {
            return null;
        }
        if ("".equals(value)) {
            return "";
        }
        String result = null;
        Throwable throwable = null;
        try {
            value = ResourceValueUtil.convert((Object)value, originClass);
            if (String.class == originClass) {
                return (String)value;
            }
            if (originClass.isArray()) {
                if (Byte[].class == originClass) {
                    result = ResourceValueUtil.formatByteObjectArray((Byte[])((Byte[])value));
                } else if (byte[].class == originClass) {
                    result = ResourceValueUtil.formatByteArray((byte[])((byte[])value));
                }
            } else {
                result = originClass.isPrimitive() ? ResourceValueUtil.formatForPrimitive((Object)value, originClass) : ResourceValueUtil.formatForObject((Object)value, originClass);
            }
        }
        catch (Throwable e) {
            throwable = e;
        }
        if (result == null) {
            if (throwable != null) {
                throw new IllegalArgumentException("Invalid value originClass=" + originClass.getName(), throwable);
            }
            throw new IllegalArgumentException("Unsupported value originClass=" + originClass.getName());
        }
        return result;
    }

    public static <T> T parse(String value, EnumResourceValueType targetType) {
        return (T)ResourceValueUtil.parse((String)value, (EnumResourceValueType)targetType, null, (boolean)false);
    }

    public static <T> T parse(String value, EnumResourceValueType targetType, ResourceValueParseFilter filter) {
        return (T)ResourceValueUtil.parse((String)value, (EnumResourceValueType)targetType, (ResourceValueParseFilter)filter, (boolean)true);
    }

    public static <T> T parse(String value, EnumResourceValueType targetType, ResourceValueParseFilter filter, boolean doParseBefore) {
        if (targetType == null) {
            throw new IllegalArgumentException("'targetType' must be not null.");
        }
        if (doParseBefore && filter != null && value != null && !value.isEmpty()) {
            value = filter.parseBefore(value, targetType);
        }
        Object result = ResourceValueUtil.parse((String)value, (Class)targetType.getTargetClass());
        if (filter != null && result != null && !"".equals(result)) {
            result = filter.parseAfter(result, targetType);
        }
        return (T)result;
    }

    public static <T> T parse(String value, Class<?> targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException("'targetClass' must be not null.");
        }
        Object result = null;
        if (value == null || "".equals(value)) {
            result = ResourceValueUtil.convertAsNull((Object)value, targetClass);
        } else {
            Throwable throwable = null;
            try {
                if (targetClass.isArray()) {
                    if (byte[].class == targetClass) {
                        result = ResourceValueUtil.parseByteArray((String)value);
                    } else if (Byte[].class == targetClass) {
                        result = ResourceValueUtil.parseByteObjectArray((String)value);
                    }
                } else {
                    result = targetClass.isPrimitive() ? ResourceValueUtil.parseForPrimitive((Object)value, targetClass) : ResourceValueUtil.parseForObject((String)value, targetClass);
                }
            }
            catch (Throwable e) {
                throwable = e;
            }
            if (result == null) {
                if (throwable != null) {
                    throw new IllegalArgumentException("Invalid valu targetClass=" + targetClass.getName(), throwable);
                }
                throw new IllegalArgumentException("Unsupported value targetClass=" + targetClass.getName());
            }
        }
        return (T)result;
    }

    public static <T> T convert(Object value, EnumResourceValueType targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("'targetType' must be not null.");
        }
        if (value != null && !"".equals(value) && !targetType.getSupportedOriginClasses().contains(value.getClass())) {
            throw new IllegalArgumentException("Unsupported value class.");
        }
        Object result = ResourceValueUtil.convert((Object)value, (Class)targetType.getTargetClass());
        return (T)result;
    }

    public static <T> T convert(Object value, Class<T> targetClass) {
        Object result;
        if (targetClass == null) {
            throw new IllegalArgumentException("'targetClass' must be not null.");
        }
        if (value == null || "".equals(value)) {
            return (T)ResourceValueUtil.convertAsNull((Object)value, targetClass);
        }
        if (String.class == targetClass) {
            result = ResourceValueUtil.convertAsString((Object)value);
        } else if (Boolean.class == targetClass) {
            result = ResourceValueUtil.convertAsBooleanObject((Object)value);
        } else if (Integer.class == targetClass) {
            result = ResourceValueUtil.convertAsIntegerObject((Object)value);
        } else if (Long.class == targetClass) {
            result = ResourceValueUtil.convertAsLongObject((Object)value);
        } else if (Float.class == targetClass) {
            result = ResourceValueUtil.convertAsFloatObject((Object)value);
        } else if (Double.class == targetClass) {
            result = ResourceValueUtil.convertAsDoubleObject((Object)value);
        } else if (BigInteger.class == targetClass) {
            result = ResourceValueUtil.convertAsBigIntegerObject((Object)value);
        } else if (BigDecimal.class == targetClass) {
            result = ResourceValueUtil.convertAsBigDecimal((Object)value);
        } else if (Character.class == targetClass) {
            result = ResourceValueUtil.convertAsCharacter((Object)value);
        } else if (Byte.class == targetClass) {
            result = ResourceValueUtil.convertAsByteObject((Object)value);
        } else if (byte[].class == targetClass) {
            result = ResourceValueUtil.convertAsByteArray((Object)value);
        } else if (java.util.Date.class == targetClass) {
            result = ResourceValueUtil.convertAsJavaDate((Object)value);
        } else if (Date.class == targetClass) {
            result = ResourceValueUtil.convertAsSqlDate((Object)value);
        } else if (Timestamp.class == targetClass) {
            result = ResourceValueUtil.convertAsSqlTimestamp((Object)value);
        } else if (ZonedDateTime.class == targetClass) {
            result = ResourceValueUtil.convertAsZonedDateTime((Object)value);
        } else if (Map.class == targetClass) {
            result = ResourceValueUtil.convertAsMap((Object)value);
        } else {
            throw new IllegalArgumentException("Unsupported targetClass=" + targetClass);
        }
        return (T)result;
    }

    public static <T> T convertAsNull(Object value, Class<?> targetClass) {
        if (targetClass.isPrimitive()) {
            Object array = Array.newInstance(targetClass, 0);
            return (T)Array.get(array, 0);
        }
        if (targetClass.isArray() && targetClass.getComponentType().isPrimitive()) {
            return (T)Array.newInstance(targetClass.getComponentType(), 0);
        }
        return (T)(value != null && String.class == targetClass ? value : null);
    }

    private static String convertAsString(Object value) {
        Class<?> valueClass = value.getClass();
        if (String.class == valueClass) {
            return (String)value;
        }
        if (Character[].class == valueClass) {
            value = ResourceValueUtil.convertToCharArray((Character[])((Character[])value));
        } else if (Byte[].class == valueClass) {
            value = ResourceValueUtil.convertToCharArray((Byte[])((Byte[])value));
        } else if (byte[].class == valueClass) {
            value = ResourceValueUtil.convertToCharArray((byte[])((byte[])value));
        } else if (File.class == valueClass || URI.class == valueClass || URL.class == valueClass) {
            return value.toString();
        }
        valueClass = value.getClass();
        if (char[].class == valueClass) {
            return new String((char[])value);
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    private static Boolean convertAsBooleanObject(Object value) {
        Class<?> valueClass = value.getClass();
        if (Boolean.class == valueClass) {
            return (Boolean)value;
        }
        if (Boolean.TYPE == valueClass) {
            return (boolean)((Boolean)value);
        }
        if (Integer.class == valueClass) {
            return (Integer)value == 1;
        }
        if (Integer.TYPE == valueClass) {
            return (Integer)value == 1;
        }
        if (String.class == valueClass) {
            return Boolean.valueOf((String)value);
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    private static Integer convertAsIntegerObject(Object value) {
        Class<?> valueClass = value.getClass();
        if (Integer.class == valueClass) {
            return (Integer)value;
        }
        if (Integer.TYPE == valueClass) {
            return (int)((Integer)value);
        }
        if (String.class == valueClass) {
            return Integer.valueOf((String)value);
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    private static Long convertAsLongObject(Object value) {
        Class<?> valueClass = value.getClass();
        if (Long.class == valueClass) {
            return (Long)value;
        }
        if (Integer.class == valueClass) {
            return ((Integer)value).longValue();
        }
        if (String.class == valueClass) {
            return Long.valueOf((String)value);
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    private static Float convertAsFloatObject(Object value) {
        Class<?> valueClass = value.getClass();
        if (Float.class == valueClass) {
            return (Float)value;
        }
        if (Long.class == valueClass) {
            return Float.valueOf(((Long)value).floatValue());
        }
        if (Integer.class == valueClass) {
            return Float.valueOf(((Integer)value).floatValue());
        }
        if (String.class == valueClass) {
            return Float.valueOf((String)value);
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    private static Double convertAsDoubleObject(Object value) {
        Class<?> valueClass = value.getClass();
        if (Double.class == valueClass) {
            return (Double)value;
        }
        if (Long.class == valueClass) {
            return ((Long)value).doubleValue();
        }
        if (Integer.class == valueClass) {
            return ((Integer)value).doubleValue();
        }
        if (String.class == valueClass) {
            return Double.valueOf((String)value);
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    private static BigInteger convertAsBigIntegerObject(Object value) {
        Class<?> valueClass = value.getClass();
        if (BigInteger.class == valueClass) {
            return (BigInteger)value;
        }
        if (Long.class == valueClass) {
            return BigInteger.valueOf((Long)value);
        }
        if (Integer.class == valueClass) {
            return BigInteger.valueOf(((Integer)value).intValue());
        }
        if (String.class == valueClass) {
            return new BigInteger((String)value);
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    private static BigDecimal convertAsBigDecimal(Object value) {
        Class<?> valueClass = value.getClass();
        if (BigDecimal.class == valueClass) {
            return (BigDecimal)value;
        }
        if (Long.class == valueClass) {
            return BigDecimal.valueOf((Long)value);
        }
        if (Integer.class == valueClass) {
            return BigDecimal.valueOf(((Integer)value).intValue());
        }
        if (Double.class == valueClass) {
            return BigDecimal.valueOf((Double)value);
        }
        if (String.class == valueClass) {
            return new BigDecimal((String)value);
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    private static Character convertAsCharacter(Object value) {
        Class<?> valueClass = value.getClass();
        if (Character.class == valueClass) {
            return (Character)value;
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    private static Byte convertAsByteObject(Object value) {
        Class<?> valueClass = value.getClass();
        if (Byte.class == valueClass) {
            return (Byte)value;
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    private static byte[] convertAsByteArray(Object value) {
        Class<?> valueClass = value.getClass();
        if (byte[].class == valueClass) {
            return (byte[])value;
        }
        if (Byte[].class == valueClass) {
            return ResourceValueUtil.convertToByteArray((Byte[])((Byte[])value));
        }
        if (Character[].class == valueClass) {
            return ResourceValueUtil.convertToByteArray((Character[])((Character[])value));
        }
        if (char[].class == valueClass) {
            return ResourceValueUtil.convertToByteArray((char[])((char[])value));
        }
        if (String.class == valueClass) {
            return ((String)value).getBytes();
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    private static java.util.Date convertAsJavaDate(Object value) {
        Class<?> valueClass = (value = ResourceValueUtil.parseDate((Object)value)).getClass();
        if (java.util.Date.class.isAssignableFrom(valueClass)) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)value);
            cal.set(14, 0);
            return cal.getTime();
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    private static Date convertAsSqlDate(Object value) {
        Class<?> valueClass = (value = ResourceValueUtil.parseDate((Object)value)).getClass();
        if (java.util.Date.class.isAssignableFrom(valueClass)) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)value);
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, 0);
            return new Date(cal.getTimeInMillis());
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    private static Timestamp convertAsSqlTimestamp(Object value) {
        Class<?> valueClass = (value = ResourceValueUtil.parseDate((Object)value)).getClass();
        if (java.util.Date.class.isAssignableFrom(valueClass)) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    private static ZonedDateTime convertAsZonedDateTime(Object value) {
        Class<?> valueClass = value.getClass();
        if (ZonedDateTime.class == valueClass) {
            return (ZonedDateTime)value;
        }
        if (LocalDateTime.class.isAssignableFrom(valueClass)) {
            return ZonedDateTime.ofLocal((LocalDateTime)value, ZoneId.systemDefault(), ZoneOffset.UTC);
        }
        valueClass = (value = ResourceValueUtil.parseDate((Object)value)).getClass();
        if (java.util.Date.class.isAssignableFrom(valueClass)) {
            return ZonedDateTime.ofInstant(((java.util.Date)value).toInstant(), ZoneId.systemDefault());
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    private static Map<String, Object> convertAsMap(Object value) {
        Class<?> valueClass = value.getClass();
        if (Map.class.isAssignableFrom(valueClass)) {
            return (Map)value;
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    private static char[] convertToCharArray(Character[] value) {
        char[] chars = new char[value.length];
        for (int i = 0; i < value.length; ++i) {
            chars[i] = value[i].charValue();
        }
        return chars;
    }

    private static char[] convertToCharArray(byte[] value) {
        ByteBuffer bb = ByteBuffer.allocate(value.length);
        bb.put(value).flip();
        CharBuffer cb = Charset.defaultCharset().decode(bb);
        return cb.array();
    }

    private static char[] convertToCharArray(Byte[] value) {
        byte[] bytes = ResourceValueUtil.convertToByteArray((Byte[])value);
        return ResourceValueUtil.convertToCharArray((byte[])bytes);
    }

    private static byte[] convertToByteArray(Byte[] value) {
        byte[] bytes = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            bytes[i] = value[i];
        }
        return bytes;
    }

    private static byte[] convertToByteArray(char[] value) {
        CharBuffer cb = CharBuffer.allocate(value.length);
        cb.put(value).flip();
        ByteBuffer bb = Charset.defaultCharset().encode(cb);
        return bb.array();
    }

    private static byte[] convertToByteArray(Character[] value) {
        char[] chars = ResourceValueUtil.convertToCharArray((Character[])value);
        return ResourceValueUtil.convertToByteArray((char[])chars);
    }

    private static Object parseForPrimitive(Object value, Class<?> clazz) {
        Object result = null;
        if (Boolean.TYPE == clazz) {
            result = Boolean.class.isAssignableFrom(value.getClass()) ? value : Boolean.valueOf(ResourceValueUtil.parseBoolean((String)value.toString()));
        } else if (Integer.TYPE == clazz) {
            result = Integer.class.isAssignableFrom(value.getClass()) ? value : Integer.valueOf(ResourceValueUtil.parseInteger((String)value.toString()));
        } else if (Long.TYPE == clazz) {
            result = ResourceValueUtil.parseLongValue((Object)value);
        } else if (Float.TYPE == clazz) {
            result = ResourceValueUtil.parseFloatValue((Object)value);
        } else if (Double.TYPE == clazz) {
            result = ResourceValueUtil.parseDoubleValue((Object)value);
        } else if (Character.TYPE == clazz) {
            result = ResourceValueUtil.parseCharacterValue((Object)value);
        } else if (Byte.TYPE == clazz) {
            result = ResourceValueUtil.parseByteValue((Object)value);
        }
        return result;
    }

    private static Object parseByteValue(Object value) {
        if (Byte.class.isAssignableFrom(value.getClass()) || Integer.TYPE == value.getClass()) {
            return value;
        }
        if (Integer.class.isAssignableFrom(value.getClass())) {
            return Float.valueOf(((Integer)value).floatValue());
        }
        return ResourceValueUtil.parseByte((String)value.toString());
    }

    private static Object parseCharacterValue(Object value) {
        if (Character.class.isAssignableFrom(value.getClass()) || Integer.TYPE == value.getClass()) {
            return value;
        }
        if (Integer.class.isAssignableFrom(value.getClass())) {
            return Float.valueOf(((Integer)value).floatValue());
        }
        return Character.valueOf(ResourceValueUtil.parseCharacter((String)value.toString()));
    }

    private static Object parseDoubleValue(Object value) {
        if (Double.class.isAssignableFrom(value.getClass()) || Integer.TYPE == value.getClass()) {
            return value;
        }
        if (Integer.class.isAssignableFrom(value.getClass())) {
            return ((Integer)value).doubleValue();
        }
        return ResourceValueUtil.parseDouble((String)value.toString());
    }

    private static Object parseLongValue(Object value) {
        if (Long.class.isAssignableFrom(value.getClass()) || Integer.TYPE == value.getClass()) {
            return value;
        }
        if (Integer.class.isAssignableFrom(value.getClass())) {
            return ((Integer)value).longValue();
        }
        return ResourceValueUtil.parseLong((String)value.toString());
    }

    private static Object parseFloatValue(Object value) {
        if (Float.class.isAssignableFrom(value.getClass()) || Integer.TYPE == value.getClass()) {
            return value;
        }
        if (Integer.class.isAssignableFrom(value.getClass())) {
            return Float.valueOf(((Integer)value).floatValue());
        }
        return Float.valueOf(ResourceValueUtil.parseFloat((String)value.toString()));
    }

    private static String formatForPrimitive(Object value, Class<?> originClass) {
        String result = null;
        if (Boolean.TYPE == originClass) {
            result = ResourceValueUtil.formatBoolean((boolean)((Boolean)value));
        } else if (Integer.TYPE == originClass) {
            result = ResourceValueUtil.formatInteger((int)((Integer)value));
        } else if (Long.TYPE == originClass) {
            result = ResourceValueUtil.formatLong((long)((Long)value));
        } else if (Float.TYPE == originClass) {
            result = ResourceValueUtil.formatFloat((float)((Float)value).floatValue());
        } else if (Double.TYPE == originClass) {
            result = ResourceValueUtil.formatDouble((double)((Double)value));
        } else if (Character.TYPE == originClass) {
            result = ResourceValueUtil.formatCharacter((char)((Character)value).charValue());
        } else if (Byte.TYPE == originClass) {
            result = ResourceValueUtil.formatByte((byte)((Byte)value));
        }
        return result;
    }

    private static Object parseForObject(String value, Class<?> targetClass) throws URISyntaxException {
        Object result = null;
        if (String.class == targetClass) {
            result = value;
        } else if (Boolean.class == targetClass) {
            result = ResourceValueUtil.parseBooleanObject((String)value);
        } else if (Number.class.isAssignableFrom(targetClass)) {
            result = ResourceValueUtil.parseForNumber((String)value, targetClass);
        } else if (Character.class == targetClass) {
            result = ResourceValueUtil.parseCharacterObject((String)value);
        } else if (java.util.Date.class.isAssignableFrom(targetClass)) {
            result = ResourceValueUtil.parseForDate((String)value, targetClass);
        } else if (ZonedDateTime.class == targetClass) {
            result = ResourceValueUtil.parseZonedDateTime((String)value);
        } else if (URI.class == targetClass) {
            result = ResourceValueUtil.parseURI((String)value);
        } else if (File.class == targetClass) {
            result = ResourceValueUtil.parseFile((String)value);
        } else if (Map.class.isAssignableFrom(targetClass)) {
            result = JSON.parseObject((String)value).getInnerMap();
        }
        return result;
    }

    private static String formatForObject(Object value, Class<?> originClass) {
        String result = null;
        if (String.class == originClass) {
            result = (String)value;
        } else if (Boolean.class == originClass) {
            result = ResourceValueUtil.formatBooleanObject((Boolean)((Boolean)value));
        } else if (Number.class.isAssignableFrom(value.getClass())) {
            result = ResourceValueUtil.formatForNumber((Number)((Number)value), originClass);
        } else if (Character.class == originClass) {
            result = ResourceValueUtil.formatCharacterObject((Character)((Character)value));
        } else if (java.util.Date.class.isAssignableFrom(originClass)) {
            result = ResourceValueUtil.formatForDate((java.util.Date)((java.util.Date)value), originClass);
        } else if (ZonedDateTime.class == originClass) {
            result = ResourceValueUtil.formatZonedDateTime((ZonedDateTime)((ZonedDateTime)value));
        } else if (URI.class == originClass) {
            result = ResourceValueUtil.formatURI((URI)((URI)value));
        } else if (File.class == originClass) {
            result = ResourceValueUtil.formatFile((File)((File)value));
        } else if (Map.class.isAssignableFrom(originClass)) {
            result = JSON.toJSONString((Object)value);
        }
        return result;
    }

    private static String formatForNumber(Number value, Class<? extends Number> originClass) {
        String result = null;
        if (Integer.class == originClass) {
            result = ResourceValueUtil.formatIntegerObject((Integer)((Integer)value));
        } else if (Long.class == originClass) {
            result = ResourceValueUtil.formatLongObject((Long)((Long)value));
        } else if (Float.class == originClass) {
            result = ResourceValueUtil.formatFloatObject((Float)((Float)value));
        } else if (Double.class == originClass) {
            result = ResourceValueUtil.formatDoubleObject((Double)((Double)value));
        } else if (Byte.class == originClass) {
            result = ResourceValueUtil.formatByteObject((Byte)((Byte)value));
        } else if (BigInteger.class == originClass) {
            result = ResourceValueUtil.formatBigInteger((BigInteger)((BigInteger)value));
        } else if (BigDecimal.class == originClass) {
            result = ResourceValueUtil.formatBigDecimal((BigDecimal)((BigDecimal)value));
        }
        return result;
    }

    private static Object parseForNumber(String value, Class<? extends Number> targetClass) {
        Number result = null;
        if (Integer.class == targetClass) {
            result = ResourceValueUtil.parseIntegerObject((String)value);
        } else if (Long.class == targetClass) {
            result = ResourceValueUtil.parseLongObject((String)value);
        } else if (Float.class == targetClass) {
            result = ResourceValueUtil.parseFloatObject((String)value);
        } else if (Double.class == targetClass) {
            result = ResourceValueUtil.parseDoubleObject((String)value);
        } else if (Byte.class == targetClass) {
            result = ResourceValueUtil.parseByteObject((String)value);
        } else if (BigInteger.class == targetClass) {
            result = ResourceValueUtil.parseBigInteger((String)value);
        } else if (BigDecimal.class == targetClass) {
            result = ResourceValueUtil.parseBigDecimal((String)value);
        }
        return result;
    }

    private static String formatForDate(java.util.Date value, Class<? extends java.util.Date> originClass) {
        if (Date.class.isAssignableFrom(originClass)) {
            return ResourceValueUtil.formatDate((java.util.Date)value, (String)"yyyy-MM-dd");
        }
        if (Timestamp.class.isAssignableFrom(originClass)) {
            return ResourceValueUtil.formatDate((java.util.Date)value, (String)"yyyy-MM-dd HH:mm:ss.SSS");
        }
        if (Time.class.isAssignableFrom(originClass)) {
            return ResourceValueUtil.formatDate((java.util.Date)value, (String)"HH:mm:ss");
        }
        return ResourceValueUtil.formatDate((java.util.Date)value, (String)"yyyy-MM-dd HH:mm:ss");
    }

    private static Object parseForDate(String value, Class<? extends java.util.Date> targetClass) {
        if (Date.class.isAssignableFrom(targetClass)) {
            return ResourceValueUtil.convertAsSqlDate((Object)value);
        }
        if (Timestamp.class.isAssignableFrom(targetClass)) {
            return ResourceValueUtil.convertAsSqlTimestamp((Object)value);
        }
        return ResourceValueUtil.convertAsJavaDate((Object)value);
    }

    private static String formatBooleanObject(Boolean value) {
        return value.toString();
    }

    private static Boolean parseBooleanObject(String value) {
        return ResourceValueUtil.parseBoolean((String)value);
    }

    private static String formatBoolean(boolean value) {
        return Boolean.toString(value);
    }

    private static boolean parseBoolean(String value) {
        return "true".equalsIgnoreCase(value) || "1".equals(value);
    }

    private static String formatIntegerObject(Integer value) {
        return value.toString();
    }

    private static Integer parseIntegerObject(String value) {
        return ResourceValueUtil.parseInteger((String)value);
    }

    private static String formatInteger(int value) {
        return Integer.toString(value);
    }

    private static int parseInteger(String value) {
        return Integer.parseInt(value);
    }

    private static String formatLongObject(Long value) {
        return value.toString();
    }

    private static Long parseLongObject(String value) {
        return ResourceValueUtil.parseLong((String)value);
    }

    private static String formatLong(long value) {
        return Long.toString(value);
    }

    private static long parseLong(String value) {
        return Long.parseLong(value);
    }

    private static String formatFloatObject(Float value) {
        return value.toString();
    }

    private static Float parseFloatObject(String value) {
        return Float.valueOf(ResourceValueUtil.parseFloat((String)value));
    }

    private static String formatFloat(float value) {
        return Float.toString(value);
    }

    private static float parseFloat(String value) {
        return Float.parseFloat(value);
    }

    private static String formatDoubleObject(Double value) {
        return value.toString();
    }

    private static Double parseDoubleObject(String value) {
        return ResourceValueUtil.parseDouble((String)value);
    }

    private static String formatDouble(double value) {
        return Double.toString(value);
    }

    private static double parseDouble(String value) {
        return Double.parseDouble(value);
    }

    private static String formatBigInteger(BigInteger value) {
        return value.toString();
    }

    private static BigInteger parseBigInteger(String value) {
        return new BigInteger(value);
    }

    private static String formatBigDecimal(BigDecimal value) {
        return value.toString();
    }

    private static BigDecimal parseBigDecimal(String value) {
        return new BigDecimal(value);
    }

    private static String formatByteObject(Byte value) {
        return value.toString();
    }

    private static Byte parseByteObject(String value) {
        return Byte.valueOf(value);
    }

    private static String formatByte(byte value) {
        return Byte.toString(value);
    }

    private static byte parseByte(String value) {
        return Byte.valueOf(value);
    }

    private static String formatByteObjectArray(Byte[] value) {
        byte[] bytes = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            bytes[i] = value[i];
        }
        return ResourceValueUtil.formatByteArray((byte[])bytes);
    }

    private static Byte[] parseByteObjectArray(String value) {
        byte[] _bytes = ResourceValueUtil.parseByteArray((String)value);
        Byte[] bytes = new Byte[_bytes.length];
        for (int i = 0; i < _bytes.length; ++i) {
            bytes[i] = _bytes[i];
        }
        return bytes;
    }

    private static String formatByteArray(byte[] value) {
        return Base64.getEncoder().encodeToString(value);
    }

    private static byte[] parseByteArray(String value) {
        return Base64.getDecoder().decode(value);
    }

    private static String formatCharacterObject(Character value) {
        return String.valueOf(value.charValue());
    }

    private static Character parseCharacterObject(String value) {
        return Character.valueOf(ResourceValueUtil.parseCharacter((String)value));
    }

    private static String formatCharacter(char value) {
        return String.valueOf(value);
    }

    private static char parseCharacter(String value) {
        char[] chars = value.toCharArray();
        if (chars.length == 1) {
            return chars[0];
        }
        throw new IllegalArgumentException("Invalid charcater");
    }

    private static String formatDate(java.util.Date value, String pattern) {
        return new SimpleDateFormat(pattern).format(value);
    }

    private static java.util.Date parseDate(Object value) {
        Class<?> valueClass = value.getClass();
        if (java.util.Date.class.isAssignableFrom(valueClass)) {
            return (java.util.Date)value;
        }
        if (Long.class == valueClass) {
            return new java.util.Date((Long)value);
        }
        if (String.class == valueClass) {
            String str = (String)value;
            try {
                if (str.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(str);
                }
                if (str.length() == "yyyy-MM-dd".length()) {
                    return new SimpleDateFormat("yyyy-MM-dd").parse(str);
                }
                if (str.length() == "yyyy-MM-dd HH:mm:ss.SSS".length()) {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").parse(str);
                }
            }
            catch (ParseException e) {
                throw new RuntimeException("Cannot parse string to date.", e);
            }
        }
        throw new RuntimeException("Cannot parse string to date.");
    }

    private static String formatZonedDateTime(ZonedDateTime value) {
        return value.toString();
    }

    private static ZonedDateTime parseZonedDateTime(String value) {
        return ZonedDateTime.parse(value);
    }

    private static String formatURI(URI value) {
        return value.toString();
    }

    private static URI parseURI(String value) throws URISyntaxException {
        return new URI(value);
    }

    private static String formatFile(File file) {
        return file.toString();
    }

    private static File parseFile(String value) {
        return new File(value);
    }
}

