/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.service.agent.config;

import com.bamboocloud.bcidaas.cloudbridge.agent.config.AgentConfiguration;
import com.bamboocloud.bcidaas.cloudbridge.service.auth.CustomLdapAuthoritiesPopulator;
import com.bamboocloud.bcidaas.cloudbridge.service.auth.LdapUserDetailsMapper;
import com.bamboocloud.bcidaas.cloudbridge.service.auth.config.AdConfiguration;
import com.bamboocloud.bcidaas.cloudbridge.service.auth.config.LdapConfiguration;
import com.bamboocloud.bcidaas.cloudbridge.service.auth.security.CustomSSLSocketFactory;
import com.bamboocloud.bcidaas.cloudbridge.service.auth.security.IgnoreSSLCheckSocketFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.authentication.ad.ActiveDirectoryLdapAuthenticationProvider;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={AgentConfiguration.class, AdConfiguration.class, LdapConfiguration.class})
public class AuthConfiguration {
    private Pattern ldapPattern = Pattern.compile("^((ldap|ldaps)?):\\/\\/[\\w\\-]+(\\.[\\w\\-]+)+([\\w\\-.,@?^=%&:\\/~+#]*[\\w\\-@?^=%&\\/~+#])?$");
    private Pattern adPattern = Pattern.compile("^(ldap|ldaps):\\/\\/([\\w\\-]+\\.){1,}([\\w\\-]+)+:\\d{1,5}\\/$");

    @Bean
    @ConditionalOnProperty(name={"authentication.ad.enable"}, havingValue="true")
    ActiveDirectoryLdapAuthenticationProvider activeDirectoryLdapAuthenticationProvider(AdConfiguration configuration) {
        this.checkAdLdapUrl(this.adPattern, configuration.getUrls());
        int timeout = this.checkAdLdapTimeout(configuration.getTimeout());
        ActiveDirectoryLdapAuthenticationProvider provider = new ActiveDirectoryLdapAuthenticationProvider(configuration.getDomain(), configuration.getUrls().replace(",", " "), configuration.getRootDn());
        provider.setSearchFilter(configuration.getSearchFilter());
        provider.setUserDetailsContextMapper((UserDetailsContextMapper)new LdapUserDetailsMapper());
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("java.naming.ldap.attributes.binary", "objectGUID objectSid");
        if (timeout > 0) {
            env.put("com.sun.jndi.ldap.connect.timeout", String.valueOf(timeout));
            env.put("com.sun.jndi.ldap.read.timeout", String.valueOf(timeout));
        }
        provider.setContextEnvironmentProperties(env);
        provider.setConvertSubErrorCodesToExceptions(true);
        return provider;
    }

    @Bean
    @ConditionalOnProperty(name={"authentication.ldap.enable"}, havingValue="true")
    LdapAuthenticationProvider ldapAuthenticationProvider(LdapConfiguration configuration) {
        return new LdapAuthenticationProvider(this.getLdapAuthenticator(configuration), (LdapAuthoritiesPopulator)new CustomLdapAuthoritiesPopulator());
    }

    private LdapAuthenticator getLdapAuthenticator(LdapConfiguration configuration) {
        this.checkAdLdapUrl(this.ldapPattern, configuration.getUrls());
        int timeout = this.checkAdLdapTimeout(configuration.getTimeout());
        List<String> urls = Arrays.asList(configuration.getUrls().split(","));
        String[] dnPatterns = null;
        if (configuration.getDnPatterns() != null && !configuration.getDnPatterns().isEmpty()) {
            dnPatterns = configuration.getDnPatterns().contains("\"") ? configuration.getDnPatterns().split("||") : new String[]{configuration.getDnPatterns()};
        }
        DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(urls, configuration.getBaseDn());
        HashMap<String, String> environment = new HashMap<String, String>();
        if (configuration.getUrls().contains("ldaps://") && !configuration.getUrls().contains("ldap://")) {
            environment.put("java.naming.security.protocol", "ssl");
            environment.put("java.naming.ldap.factory.socket", CustomSSLSocketFactory.class.getName());
            if (BooleanUtils.isFalse((Boolean)configuration.getSslCheck())) {
                environment.put("java.naming.ldap.factory.socket", IgnoreSSLCheckSocketFactory.class.getName());
            }
        } else if (timeout > 0) {
            environment.put("com.sun.jndi.ldap.connect.timeout", String.valueOf(timeout));
            environment.put("com.sun.jndi.ldap.read.timeout", String.valueOf(timeout));
        }
        contextSource.setBaseEnvironmentProperties(environment);
        contextSource.setUserDn(configuration.getManagerDn());
        contextSource.setPassword(configuration.getManagerPassword());
        contextSource.afterPropertiesSet();
        BindAuthenticator ldapAuthenticator = new BindAuthenticator((BaseLdapPathContextSource)contextSource);
        if (configuration.getUserSearchFilter() != null && !configuration.getUserSearchFilter().isEmpty()) {
            FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(configuration.getUserSearchBase(), configuration.getUserSearchFilter(), (BaseLdapPathContextSource)contextSource);
            userSearch.setSearchSubtree(true);
            userSearch.setSearchTimeLimit(1000);
            userSearch.setDerefLinkFlag(true);
            ldapAuthenticator.setUserSearch((LdapUserSearch)userSearch);
        }
        if (dnPatterns != null) {
            ldapAuthenticator.setUserDnPatterns(dnPatterns);
        }
        return ldapAuthenticator;
    }

    private void checkAdLdapUrl(Pattern pattern, String urls) {
        String[] urlArray = StringUtils.split((String)urls, (String)",");
        HashSet<String> schemaSet = new HashSet<String>();
        for (String url : urlArray) {
            if (!pattern.matcher(url).matches()) {
                throw new IllegalArgumentException("urls is invalid");
            }
            schemaSet.add(StringUtils.substringBefore((String)url, (String)"//"));
        }
        if (schemaSet.size() > 1) {
            throw new IllegalArgumentException("The url is not all ldaps or ldap");
        }
    }

    private int checkAdLdapTimeout(Integer timeout) {
        if (timeout == null) {
            return 0;
        }
        if (timeout < 1000) {
            throw new IllegalArgumentException("timeout cannot be less than 1000");
        }
        if (timeout > 3000) {
            throw new IllegalArgumentException("timeout cannot be greater than 3000");
        }
        return timeout;
    }
}

