/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.service.auth;

import com.bamboocloud.bcidaas.bridge.api.Packet;
import com.bamboocloud.bcidaas.bridge.api.exception.AuthenticationError;
import com.bamboocloud.bcidaas.bridge.api.object.LdapUser;
import com.bamboocloud.bcidaas.cloudbridge.agent.session.MessageSender;
import com.bamboocloud.bcidaas.cloudbridge.agent.websocket.handler.MessageHandler;
import com.bamboocloud.bcidaas.cloudbridge.service.auth.LdapGrantedAuthority;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.naming.AuthenticationException;
import javax.net.ssl.SSLException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.userdetails.LdapUserDetailsImpl;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketSession;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class LdapAuthenticationService
implements MessageHandler<Packet.LdapAuthRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LdapAuthenticationService.class);
    @Autowired(required=false)
    LdapAuthenticationProvider provider;
    public static final Map<Class<? extends Exception>, AuthenticationError> ldapExceptionMap = new HashMap();

    public Packet.MessageType getSupportedMessageType() {
        return Packet.MessageType.LDAP_AUTH_REQUEST;
    }

    public Packet.LdapAuthRequest getMessage(Packet.Message message) {
        return message.getLdapAuthRequest();
    }

    public void ProcessMessage(WebSocketSession session, Packet.LdapAuthRequest message) throws IOException {
        log.debug("ldap authentication request for user {}", (Object)message.getUserName());
        Packet.Message.Builder messageBuilder = Packet.Message.newBuilder();
        messageBuilder.setType(Packet.MessageType.LDAP_AUTH_RESPONSE);
        try {
            LdapUser adUser = this.ldapAuthentication(message.getUserName(), message.getPassword());
            messageBuilder.getLdapAuthResultBuilder().setSuccess(true).setRequestId(message.getRequestId()).getUserBuilder().putAllAttributes(adUser.getDetails());
            log.debug("ldap authentication request for user {} success", (Object)message.getUserName());
        }
        catch (Exception e) {
            this.authenticationError(message.getRequestId(), message.getUserName(), messageBuilder, e);
        }
        MessageSender.sendMessageSync((WebSocketSession)session, (Packet.Message)messageBuilder.build());
    }

    private LdapUser ldapAuthentication(String username, String password) {
        if (this.provider == null) {
            throw new UnsupportedOperationException("ldap authentication not supported");
        }
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        Authentication result = this.provider.authenticate((Authentication)authentication);
        LdapUserDetailsImpl ldapUserDetailsImpl = (LdapUserDetailsImpl)result.getPrincipal();
        return this.getLdapUser(ldapUserDetailsImpl);
    }

    private void authenticationError(int requestId, String userName, Packet.Message.Builder messageBuilder, Exception e) {
        AuthenticationError error = (AuthenticationError)ldapExceptionMap.get(e.getClass());
        if (error == null) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            error = ldapExceptionMap.getOrDefault(rootCause.getClass(), AuthenticationError.UNKNOWN_ERROR);
            if (AuthenticationError.UNKNOWN_ERROR == error && rootCause.getMessage().contains("timed out")) {
                error = (AuthenticationError)ldapExceptionMap.get(SocketTimeoutException.class);
            }
            if (AuthenticationError.UNKNOWN_ERROR == error && rootCause instanceof GeneralSecurityException) {
                error = AuthenticationError.CERTIFICATE_EXCEPTION;
            }
            if (AuthenticationError.UNKNOWN_ERROR == error && rootCause instanceof org.springframework.security.core.AuthenticationException) {
                error = AuthenticationError.BAD_CREDENTIALS;
            }
        }
        messageBuilder.getLdapAuthResultBuilder().setSuccess(false).setRequestId(requestId).setError(error.getCode());
        log.error("ldap authentication request {} for user {} failed with error {}", new Object[]{requestId, userName, error, e});
    }

    private LdapUser getLdapUser(LdapUserDetailsImpl ldapUserDetails) {
        LdapUser ldapUser = new LdapUser();
        HashMap map = new HashMap();
        ldapUserDetails.getAuthorities().forEach(grantedAuthority -> {
            LdapGrantedAuthority authority = (LdapGrantedAuthority)grantedAuthority;
            Object value = authority.getValue();
            if (value instanceof byte[]) {
                if (!"objectGUID".equals(authority.getKey())) {
                    return;
                }
                value = LdapAuthenticationService.getGuidAsString((byte[])((byte[])value));
            }
            map.put(authority.getKey(), (String)value);
        });
        ldapUser.setDetails(map);
        return ldapUser;
    }

    public static String getGuidAsString(byte[] guid) {
        StringBuilder res = new StringBuilder();
        res.append(LdapAuthenticationService.addLeadingZero((int)(guid[3] & 0xFF)));
        res.append(LdapAuthenticationService.addLeadingZero((int)(guid[2] & 0xFF)));
        res.append(LdapAuthenticationService.addLeadingZero((int)(guid[1] & 0xFF)));
        res.append(LdapAuthenticationService.addLeadingZero((int)(guid[0] & 0xFF)));
        res.append("-");
        res.append(LdapAuthenticationService.addLeadingZero((int)(guid[5] & 0xFF)));
        res.append(LdapAuthenticationService.addLeadingZero((int)(guid[4] & 0xFF)));
        res.append("-");
        res.append(LdapAuthenticationService.addLeadingZero((int)(guid[7] & 0xFF)));
        res.append(LdapAuthenticationService.addLeadingZero((int)(guid[6] & 0xFF)));
        res.append("-");
        res.append(LdapAuthenticationService.addLeadingZero((int)(guid[8] & 0xFF)));
        res.append(LdapAuthenticationService.addLeadingZero((int)(guid[9] & 0xFF)));
        res.append("-");
        res.append(LdapAuthenticationService.addLeadingZero((int)(guid[10] & 0xFF)));
        res.append(LdapAuthenticationService.addLeadingZero((int)(guid[11] & 0xFF)));
        res.append(LdapAuthenticationService.addLeadingZero((int)(guid[12] & 0xFF)));
        res.append(LdapAuthenticationService.addLeadingZero((int)(guid[13] & 0xFF)));
        res.append(LdapAuthenticationService.addLeadingZero((int)(guid[14] & 0xFF)));
        res.append(LdapAuthenticationService.addLeadingZero((int)(guid[15] & 0xFF)));
        return res.toString();
    }

    public static byte[] getGuidAsByteArray(String GUID) {
        UUID uuid = UUID.fromString(GUID);
        ByteBuffer buff = ByteBuffer.wrap(new byte[16]);
        buff.putLong(uuid.getMostSignificantBits());
        buff.putLong(uuid.getLeastSignificantBits());
        return new byte[]{buff.get(3), buff.get(2), buff.get(1), buff.get(0), buff.get(5), buff.get(4), buff.get(7), buff.get(6), buff.get(8), buff.get(9), buff.get(10), buff.get(11), buff.get(12), buff.get(13), buff.get(14), buff.get(15)};
    }

    private static String addLeadingZero(int k) {
        return k <= 15 ? "0" + Integer.toHexString(k) : Integer.toHexString(k);
    }

    static {
        ldapExceptionMap.put(BadCredentialsException.class, AuthenticationError.BAD_CREDENTIALS);
        ldapExceptionMap.put(DisabledException.class, AuthenticationError.ACCOUNT_DISABLED);
        ldapExceptionMap.put(LockedException.class, AuthenticationError.ACCOUNT_LOCKED);
        ldapExceptionMap.put(AccountExpiredException.class, AuthenticationError.ACCOUNT_EXPIRED);
        ldapExceptionMap.put(CredentialsExpiredException.class, AuthenticationError.ACCOUNT_EXPIRED);
        ldapExceptionMap.put(SSLException.class, AuthenticationError.SSL_EXCEPTION);
        ldapExceptionMap.put(GeneralSecurityException.class, AuthenticationError.CERTIFICATE_EXCEPTION);
        ldapExceptionMap.put(AuthenticationException.class, AuthenticationError.BAD_CREDENTIALS);
        ldapExceptionMap.put(ConnectException.class, AuthenticationError.LDAP_NETWORK_ERROR);
        ldapExceptionMap.put(SocketTimeoutException.class, AuthenticationError.LDAP_TIMEOUT);
        ldapExceptionMap.put(SocketException.class, AuthenticationError.LDAP_NETWORK_ERROR);
        ldapExceptionMap.put(UsernameNotFoundException.class, AuthenticationError.BAD_CREDENTIALS);
        ldapExceptionMap.put(NameNotFoundException.class, AuthenticationError.BAD_CREDENTIALS);
        ldapExceptionMap.put(javax.naming.NameNotFoundException.class, AuthenticationError.BAD_CREDENTIALS);
        ldapExceptionMap.put(UnsupportedOperationException.class, AuthenticationError.LDAP_AUTH_NOT_SUPPORTED);
        ldapExceptionMap.put(UnknownHostException.class, AuthenticationError.LDAP_NETWORK_ERROR);
        ldapExceptionMap.put(MalformedURLException.class, AuthenticationError.LDAP_NETWORK_ERROR);
    }
}

