/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.service.auth.security;

import com.bamboocloud.bcidaas.cloudbridge.service.auth.security.IgnoreSSLCheckSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreSSLCheckSocketFactory
extends SSLSocketFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IgnoreSSLCheckSocketFactory.class);
    private static final int TIME_OUT = 3000;
    private SSLSocketFactory socketFactory;

    public IgnoreSSLCheckSocketFactory() {
        try {
            SSLContext ctx = SSLContext.getInstance("TLSv1.2");
            ctx.init(null, new TrustManager[]{new CustomDummyTrustManager()}, new SecureRandom());
            this.socketFactory = ctx.getSocketFactory();
        }
        catch (Exception ex) {
            log.error("init CustomSSLSocketFactory failed", (Throwable)ex);
        }
    }

    public static SocketFactory getDefault() {
        return new IgnoreSSLCheckSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.socketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.socketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String string, int num, boolean bool) throws IOException {
        this.testConnect(string, num);
        return this.socketFactory.createSocket(socket, string, num, bool);
    }

    @Override
    public Socket createSocket(String string, int num) throws IOException {
        this.testConnect(string, num);
        return this.socketFactory.createSocket(string, num);
    }

    @Override
    public Socket createSocket(String string, int num, InetAddress netAdd, int i) throws IOException {
        this.testConnect(string, num);
        return this.socketFactory.createSocket(string, num, netAdd, i);
    }

    @Override
    public Socket createSocket(InetAddress netAdd, int num) throws IOException {
        this.testConnect(netAdd.getHostName(), num);
        return this.socketFactory.createSocket(netAdd, num);
    }

    @Override
    public Socket createSocket(InetAddress netAdd1, int num, InetAddress netAdd2, int i) throws IOException {
        this.testConnect(netAdd1.getHostName(), num);
        return this.socketFactory.createSocket(netAdd1, num, netAdd2, i);
    }

    private void testConnect(String host, int port) throws IOException {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, port), 3000);
        }
    }
}

