/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.service.auth;

import com.bamboocloud.bcidaas.cloudbridge.agent.exception.GetAttributeException;
import com.bamboocloud.bcidaas.cloudbridge.service.auth.LdapGrantedAuthority;
import java.util.ArrayList;
import java.util.Collection;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class CustomLdapAuthoritiesPopulator
implements LdapAuthoritiesPopulator {
    public Collection<? extends GrantedAuthority> getGrantedAuthorities(DirContextOperations userData, String username) {
        ArrayList<LdapGrantedAuthority> authorities = new ArrayList<LdapGrantedAuthority>();
        Attributes attributes = userData.getAttributes();
        NamingEnumeration<? extends Attribute> namingEnumerations = attributes.getAll();
        while (namingEnumerations.hasMoreElements()) {
            try {
                Attribute attribute = namingEnumerations.next();
                if (attribute.size() > 1) continue;
                authorities.add(new LdapGrantedAuthority(attribute.getID(), attribute.get()));
            }
            catch (NamingException e) {
                throw new GetAttributeException("Could not get attribute from " + namingEnumerations, (Throwable)e);
            }
        }
        return authorities;
    }
}

