/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.websocket;

import com.bamboocloud.bcidaas.bridge.api.Packet;
import com.bamboocloud.bcidaas.cloudbridge.agent.config.AgentConfiguration;
import com.bamboocloud.bcidaas.cloudbridge.agent.config.Version;
import com.bamboocloud.bcidaas.cloudbridge.agent.session.MessageSender;
import com.bamboocloud.bcidaas.cloudbridge.agent.websocket.AgentWebSocketHandler;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketSession;

@Component
@EnableConfigurationProperties(value={AgentConfiguration.class})
public class AuthAgentWebSocketHandler
extends AgentWebSocketHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthAgentWebSocketHandler.class);
    @Autowired
    private AgentConfiguration configuration;

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        log.info("connection established");
        Packet.Message.Builder builder = Packet.Message.newBuilder();
        builder.setType(Packet.MessageType.CLIENT_AUTH_REQUEST).getClientAuthRequestBuilder().setClientId(this.configuration.getAgentId()).setClientSecret(this.configuration.getAgentSecret()).setClientRandomNum(AGENT_RANDOM_NUM).setAgentType(Packet.AgentType.AUTH).setClientVersion(Version.getVersion()).setClientHost(this.getClientHost());
        MessageSender.sendMessageSync((WebSocketSession)session, (Packet.Message)builder.build());
    }
}

