/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.ldap;

import com.bamboocloud.icf.common.CollectionUtil;
import com.bamboocloud.icf.common.EqualsHashCodeBuilder;
import com.bamboocloud.icf.common.IPV4Util;
import com.bamboocloud.icf.common.StringUtil;
import com.bamboocloud.icf.common.security.GuardedByteArray;
import com.bamboocloud.icf.common.security.GuardedString;
import com.bamboocloud.icf.connector.ldap.commons.LdapConstants;
import com.bamboocloud.icf.connector.ldap.commons.LdapUtil;
import com.bamboocloud.icf.connector.ldap.commons.ObjectClassMappingConfig;
import com.bamboocloud.icf.connector.ldap.search.DefaultSearchStrategy;
import com.bamboocloud.icf.framework.common.exceptions.ConfigurationException;
import com.bamboocloud.icf.framework.common.objects.AttributeInfo;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import com.bamboocloud.icf.framework.spi.AbstractConfiguration;
import com.bamboocloud.icf.framework.spi.ConfigurationProperty;
import com.bamboocloud.icf.framework.spi.operations.SyncOp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang3.StringUtils;

public class LdapConfiguration
extends AbstractConfiguration {
    public static final String UCCP_FLAG = "userCannotChangePassword";
    public static final String PNE_FLAG = "passwordNeverExpires";
    public static final String PROMPT_USER_FLAG = "pwdLastSet";
    public static final String PROMPT_USER_VALUE = "0";
    public static final String NOT_PROMPT_USER_VALUE = "-1";
    public static final String LOCK_OUT_FLAG = "lockoutTime";
    public static final String LOCK_OUT_DEFAULT_VALUE = "0";
    public static final int DEFAULT_PORT = 636;
    private String host;
    private int port = 636;
    private String domain;
    private boolean ssl = true;
    private boolean startTLS = false;
    private boolean verifyingCertificate = false;
    private String protocolVersion = "TLSv1.2";
    private String[] failover = new String[0];
    private String principal;
    private GuardedString credentials;
    private String[] baseContexts = new String[0];
    private String passwordAttribute = "userPassword";
    private String accountSearchFilter = null;
    private String groupSearchFilter = null;
    private String groupMemberAttribute = "member";
    private boolean maintainLdapGroupMembership = false;
    private boolean maintainPosixGroupMembership = false;
    private String passwordHashAlgorithm;
    private boolean respectResourcePasswordPolicyChangeAfterReset;
    private boolean useVlvControls = false;
    private String vlvSortAttribute = "uid";
    private String uidAttribute = "entryUUID";
    private String gidAttribute = "objectGUID";
    private boolean readSchema = true;
    private String accountDNPrefix;
    private String accountCNAttribute;
    private String[] baseContextsToSynchronize = new String[0];
    private String[] objectClassesToSynchronize = new String[]{"inetOrgPerson"};
    private String[] attributesToSynchronize = new String[0];
    private String[] modifiersNamesToFilterOut = new String[0];
    private String accountSynchronizationFilter;
    private int changeLogBlockSize = 100;
    private String changeNumberAttribute = "changeNumber";
    private boolean filterWithOrInsteadOfAnd;
    private boolean removeLogEntryObjectClassFromFilter = true;
    private boolean synchronizePasswords;
    private String passwordAttributeToSynchronize;
    private String statusManagementClass = "DefaultStatusManagement";
    private String dnAttribute = "entryDN";
    private boolean retrievePasswordsWithSearch;
    private String[] groupBaseContexts = new String[0];
    private final ObjectClassMappingConfig accountConfig = new ObjectClassMappingConfig(ObjectClass.ACCOUNT, CollectionUtil.newList((Object[])new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"}), false, CollectionUtil.newList((Object[])new String[]{"uid", "cn"}), LdapConstants.PASSWORD);
    private final ObjectClassMappingConfig groupConfig = new ObjectClassMappingConfig(ObjectClass.GROUP, CollectionUtil.newList((Object[])new String[]{"top", "group"}), false, CollectionUtil.newList((Object[])new String[]{"cn"}), new AttributeInfo[0]);
    private final ObjectClassMappingConfig organizationConfig = new ObjectClassMappingConfig(ObjectClass.ORGANIZATION, CollectionUtil.newList((Object[])new String[]{"top", "organizationalUnit"}), false, CollectionUtil.newList((Object[])new String[]{"ou"}), new AttributeInfo[0]);
    private List<LdapName> baseContextsAsLdapNames;
    private List<LdapName> baseContextsToSynchronizeAsLdapNames;
    private Set<LdapName> modifiersNamesToFilterOutAsLdapNames;
    private long readTimeout = 30000L;
    private long connectTimeout = 6000L;

    public void validate() {
        this.checkNotBlank(this.host, "ldap.host.notBlank");
        if (IPV4Util.includePrivateIp((String)this.host)) {
            throw new ConfigurationException("ldap.baseUrl.public.error");
        }
        if (this.port < 0 || this.port > 65535) {
            this.failValidation("ldap.port.legalValue", new Object[0]);
        }
        if (this.isSsl() && this.isStartTLS()) {
            this.failValidation("ldap.sslAndStartTLS.legalValue", new Object[0]);
        }
        this.checkNotEmpty(this.baseContexts, "ldap.baseContexts.notEmpty");
        this.checkNoBlankValues(this.baseContexts, "ldap.baseContexts.noBlankValues");
        this.checkNoInvalidLdapNames(this.baseContexts, "ldap.baseContexts.noInvalidLdapNames");
        this.checkNotBlank(this.passwordAttribute, "ldap.passwordAttribute.notBlank");
        this.checkNotEmpty(this.accountConfig.getLdapClasses(), "ldap.accountObjectClasses.notEmpty");
        this.checkNoBlankValues(this.accountConfig.getLdapClasses(), "ldap.accountObjectClasses.noBlankValues");
        this.checkNotEmpty(this.accountConfig.getShortNameLdapAttributes(), "ldap.accountUserNameAttributes.notEmpty");
        this.checkNoBlankValues(this.accountConfig.getShortNameLdapAttributes(), "ldap.accountUserNameAttributes.noBlankValues");
        this.checkNotEmpty(this.groupConfig.getLdapClasses(), "ldap.groupObjectClasses.notEmpty");
        this.checkNoBlankValues(this.groupConfig.getLdapClasses(), "ldap.groupObjectClasses.noBlankValues");
        this.checkNotEmpty(this.groupConfig.getShortNameLdapAttributes(), "ldap.groupNameAttributes.notEmpty");
        this.checkNoBlankValues(this.groupConfig.getShortNameLdapAttributes(), "ldap.groupNameAttributes.noBlankValues");
        this.checkNotBlank(this.groupMemberAttribute, "ldap.groupMemberAttribute.notBlank");
        this.checkNotBlank(this.vlvSortAttribute, "ldap.vlvSortAttribute.notBlank");
        this.checkNotBlank(this.principal, "ldap.principal.notBlank");
        if (this.baseContextsToSynchronize != null && this.baseContextsToSynchronize.length > 0 && StringUtils.isNotBlank((CharSequence)this.baseContextsToSynchronize[0])) {
            this.checkNoBlankValues(this.baseContextsToSynchronize, "ldap.baseContextsToSynchronize.noBlankValues");
            this.checkNoInvalidLdapNames(this.baseContextsToSynchronize, "ldap.baseContextsToSynchronize.noInvalidLdapNames");
        }
        this.checkNotEmpty(this.objectClassesToSynchronize, "ldap.objectClassesToSynchronize.notEmpty");
        this.checkNoBlankValues(this.objectClassesToSynchronize, "ldap.objectClassesToSynchronize.noBlankValues");
        if (this.attributesToSynchronize != null && this.baseContextsToSynchronize.length > 0 && StringUtils.isNotBlank((CharSequence)this.baseContextsToSynchronize[0])) {
            this.checkNoBlankValues(this.attributesToSynchronize, "ldap.attributesToSynchronize.noBlankValues");
        }
        if (this.modifiersNamesToFilterOut != null && this.baseContextsToSynchronize.length > 0 && StringUtils.isNotBlank((CharSequence)this.baseContextsToSynchronize[0])) {
            this.checkNoBlankValues(this.modifiersNamesToFilterOut, "ldap.modifiersNamesToFilterOut.noBlankValues");
            this.checkNoInvalidLdapNames(this.modifiersNamesToFilterOut, "ldap.modifiersNamesToFilterOut.noInvalidLdapNames");
        }
        this.checkNotBlank(this.changeNumberAttribute, "ldap.changeNumberAttribute.notBlank");
        if (this.changeLogBlockSize <= 0) {
            this.failValidation("ldap.changeLogBlockSize.legalValue", new Object[0]);
        }
    }

    private void checkNotBlank(String value, String errorMessage) {
        if (StringUtil.isBlank((String)value)) {
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNotBlank(GuardedByteArray array, String errorMessage) {
        final int[] length = new int[]{0};
        if (array != null) {
            array.access(new GuardedByteArray.Accessor(){

                public void access(byte[] clearBytes) {
                    length[0] = clearBytes.length;
                }
            });
        }
        if (length[0] == 0) {
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNotEmpty(Collection<?> collection, String errorMessage) {
        if (collection.size() < 1) {
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNotEmpty(String[] array, String errorMessage) {
        if (array == null || array.length < 1) {
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNoBlankValues(Collection<String> collection, String errorMessage) {
        for (String each : collection) {
            if (!StringUtil.isBlank((String)each)) continue;
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNoBlankValues(String[] array, String errorMessage) {
        for (String each : array) {
            if (!StringUtil.isBlank((String)each)) continue;
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNoInvalidLdapNames(String[] array, String errorMessage) {
        for (String each : array) {
            try {
                new LdapName(each);
            }
            catch (InvalidNameException e) {
                this.failValidation(errorMessage, each);
            }
        }
    }

    private void failValidation(String key, Object ... args) {
        throw new ConfigurationException(this.getConnectorMessages().format(key, null, new Object[0]));
    }

    public DefaultSearchStrategy newDefaultSearchStrategy(boolean ignoreNonExistingBaseDN) {
        return new DefaultSearchStrategy(ignoreNonExistingBaseDN);
    }

    @ConfigurationProperty(order=1, required=true, displayMessageKey="ldap.host.display", helpMessageKey="ldap.host.help", groupMessageKey="ldap.general.group", regexp="[\\w\\-]+(\\.[\\w\\-]+)+([\\w\\-.,@?^=%&:\\/~+#]*[\\w\\-@?^=%&\\/~+#])?$")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @ConfigurationProperty(order=2, required=true, displayMessageKey="ldap.port.display", helpMessageKey="ldap.port.help", groupMessageKey="ldap.general.group", regexp="^\\d{1,5}$")
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @ConfigurationProperty(order=3, displayMessageKey="ldap.ssl.display", helpMessageKey="ldap.ssl.help", groupMessageKey="ldap.general.group")
    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    @ConfigurationProperty(order=4, displayMessageKey="ldap.startTLS.display", helpMessageKey="ldap.startTLS.help", groupMessageKey="ldap.general.group")
    public boolean isStartTLS() {
        return this.startTLS;
    }

    public void setStartTLS(boolean startTLS) {
        this.startTLS = startTLS;
    }

    @ConfigurationProperty(order=5, displayMessageKey="ldap.verifyingCertificate.display", helpMessageKey="ldap.verifyingCertificate.help", groupMessageKey="general.group")
    public boolean isVerifyingCertificate() {
        return this.verifyingCertificate;
    }

    public void setVerifyingCertificate(boolean verifyingCertificate) {
        this.verifyingCertificate = verifyingCertificate;
    }

    @ConfigurationProperty(order=5, displayMessageKey="ldap.protocolVersion.display", helpMessageKey="ldap.protocolVersion.help", groupMessageKey="ldap.general.group")
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @ConfigurationProperty(order=6, required=true, displayMessageKey="ldap.principal.display", helpMessageKey="ldap.principal.help", groupMessageKey="ldap.general.group")
    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    @ConfigurationProperty(order=7, required=true, confidential=true, displayMessageKey="ldap.credentials.display", helpMessageKey="ldap.credentials.help", groupMessageKey="ldap.general.group")
    public GuardedString getCredentials() {
        return this.credentials;
    }

    public void setCredentials(GuardedString credentials) {
        this.credentials = credentials != null ? credentials.copy() : null;
    }

    @ConfigurationProperty(order=8, required=true, displayMessageKey="ldap.baseContexts.display", helpMessageKey="ldap.baseContexts.help", groupMessageKey="ldap.general.group")
    public String[] getBaseContexts() {
        return (String[])this.baseContexts.clone();
    }

    public void setBaseContexts(String ... baseContexts) {
        this.baseContexts = (String[])baseContexts.clone();
    }

    @ConfigurationProperty(order=9, displayMessageKey="ldap.readTimeout.display", helpMessageKey="ldap.readTimeout.help", groupMessageKey="ldap.general.group")
    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout == 0L ? this.readTimeout : readTimeout;
    }

    @ConfigurationProperty(order=10, displayMessageKey="ldap.connectTimeout.display", helpMessageKey="ldap.connectTimeout.help", groupMessageKey="ldap.general.group")
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout == 0L ? this.connectTimeout : connectTimeout;
    }

    @ConfigurationProperty(order=1, displayMessageKey="ldap.uidAttribute.display", helpMessageKey="ldap.uidAttribute.help", groupMessageKey="ldap.optional.group")
    public String getUidAttribute() {
        return this.uidAttribute;
    }

    public void setUidAttribute(String uidAttribute) {
        this.uidAttribute = uidAttribute;
    }

    @ConfigurationProperty(order=2, displayMessageKey="ldap.accountObjectClasses.display", helpMessageKey="ldap.accountObjectClasses.help", groupMessageKey="ldap.optional.group")
    public String[] getAccountObjectClasses() {
        List<String> ldapClasses = this.accountConfig.getLdapClasses();
        return ldapClasses.toArray(new String[ldapClasses.size()]);
    }

    public void setAccountObjectClasses(String ... accountObjectClasses) {
        this.accountConfig.setLdapClasses(Arrays.asList(accountObjectClasses));
    }

    @ConfigurationProperty(order=3, displayMessageKey="ldap.accountUserNameAttributes.display", helpMessageKey="ldap.accountUserNameAttributes.help", groupMessageKey="ldap.optional.group")
    public String[] getAccountUserNameAttributes() {
        List<String> shortNameLdapAttributes = this.accountConfig.getShortNameLdapAttributes();
        return shortNameLdapAttributes.toArray(new String[shortNameLdapAttributes.size()]);
    }

    public void setAccountUserNameAttributes(String ... accountUserNameAttributes) {
        this.accountConfig.setShortNameLdapAttributes(Arrays.asList(accountUserNameAttributes));
    }

    @ConfigurationProperty(order=4, displayMessageKey="ldap.statusManagementClass.display", helpMessageKey="ldap.statusManagementClass.help", groupMessageKey="ldap.optional.group")
    public String getStatusManagementClass() {
        return this.statusManagementClass;
    }

    public void setStatusManagementClass(String statusManagementClass) {
        this.statusManagementClass = statusManagementClass;
    }

    @ConfigurationProperty(order=6, displayMessageKey="ldap.accountDNPrefix.display", helpMessageKey="ldap.accountDNPrefix.help", groupMessageKey="ldap.optional.group")
    public String getAccountDNPrefix() {
        return this.accountDNPrefix;
    }

    public void setAccountDNPrefix(String accountDNPrefix) {
        this.accountDNPrefix = accountDNPrefix;
    }

    @ConfigurationProperty(order=7, displayMessageKey="ldap.accountSearchFilter.display", helpMessageKey="ldap.accountSearchFilter.help", groupMessageKey="ldap.optional.group")
    public String getAccountSearchFilter() {
        return this.accountSearchFilter;
    }

    public void setAccountSearchFilter(String accountSearchFilter) {
        this.accountSearchFilter = accountSearchFilter;
    }

    @ConfigurationProperty(order=8, displayMessageKey="ldap.passwordAttribute.display", helpMessageKey="ldap.passwordAttribute.help", groupMessageKey="ldap.optional.group")
    public String getPasswordAttribute() {
        return this.passwordAttribute;
    }

    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
    }

    @ConfigurationProperty(order=9, displayMessageKey="ldap.passwordHashAlgorithm.display", helpMessageKey="ldap.passwordHashAlgorithm.help", groupMessageKey="ldap.optional.group")
    public String getPasswordHashAlgorithm() {
        return this.passwordHashAlgorithm;
    }

    public void setPasswordHashAlgorithm(String passwordHashAlgorithm) {
        this.passwordHashAlgorithm = passwordHashAlgorithm;
    }

    @ConfigurationProperty(order=10, operations={SyncOp.class}, displayMessageKey="ldap.synchronizePasswords.display", helpMessageKey="ldap.synchronizePasswords.help", groupMessageKey="ldap.optional.group")
    public boolean isSynchronizePasswords() {
        return this.synchronizePasswords;
    }

    public void setSynchronizePasswords(boolean synchronizePasswords) {
        this.synchronizePasswords = synchronizePasswords;
    }

    @ConfigurationProperty(order=11, operations={SyncOp.class}, displayMessageKey="ldap.passwordAttributeToSynchronize.display", helpMessageKey="ldap.passwordAttributeToSynchronize.help", groupMessageKey="ldap.optional.group")
    public String getPasswordAttributeToSynchronize() {
        return this.passwordAttributeToSynchronize;
    }

    public void setPasswordAttributeToSynchronize(String passwordAttributeToSynchronize) {
        this.passwordAttributeToSynchronize = passwordAttributeToSynchronize;
    }

    @ConfigurationProperty(order=12, displayMessageKey="ldap.retrievePasswordsWithSearch.display", helpMessageKey="ldap.retrievePasswordsWithSearch.help", groupMessageKey="ldap.optional.group")
    public boolean getRetrievePasswordsWithSearch() {
        return this.retrievePasswordsWithSearch;
    }

    public void setRetrievePasswordsWithSearch(boolean retrievePasswordsWithSearch) {
        this.retrievePasswordsWithSearch = retrievePasswordsWithSearch;
    }

    @ConfigurationProperty(order=13, displayMessageKey="ldap.respectResourcePasswordPolicyChangeAfterReset.display", helpMessageKey="ldap.respectResourcePasswordPolicyChangeAfterReset.help", groupMessageKey="ldap.optional.group")
    public boolean isRespectResourcePasswordPolicyChangeAfterReset() {
        return this.respectResourcePasswordPolicyChangeAfterReset;
    }

    @ConfigurationProperty(order=14, displayMessageKey="ldap.domain.display", helpMessageKey="ldap.domain.help", groupMessageKey="ldap.optional.group")
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @ConfigurationProperty(order=15, displayMessageKey="ldap.organizationObjectClasses.display", helpMessageKey="ldap.organizationObjectClasses.help", groupMessageKey="ldap.optional.group")
    public String[] getOrganizationObjectClasses() {
        List<String> ldapClasses = this.organizationConfig.getLdapClasses();
        return ldapClasses.toArray(new String[ldapClasses.size()]);
    }

    public void setOrganizationObjectClasses(String ... organizationObjectClasses) {
        this.organizationConfig.setLdapClasses(Arrays.asList(organizationObjectClasses));
    }

    @ConfigurationProperty(order=16, displayMessageKey="ldap.organizationNameAttributes.display", helpMessageKey="ldap.organizationNameAttributes.help", groupMessageKey="ldap.optional.group")
    public String[] getOrganizationNameAttributes() {
        List<String> shortNameLdapAttributes = this.organizationConfig.getShortNameLdapAttributes();
        return shortNameLdapAttributes.toArray(new String[shortNameLdapAttributes.size()]);
    }

    public void setOrganizationNameAttributes(String ... organizationNameAttributes) {
        this.organizationConfig.setShortNameLdapAttributes(Arrays.asList(organizationNameAttributes));
    }

    @ConfigurationProperty(order=17, displayMessageKey="ldap.groupObjectClasses.display", helpMessageKey="ldap.groupObjectClasses.help", groupMessageKey="ldap.optional.group", hidden=false)
    public String[] getGroupObjectClasses() {
        List<String> ldapClasses = this.groupConfig.getLdapClasses();
        return ldapClasses.toArray(new String[ldapClasses.size()]);
    }

    public void setGroupObjectClasses(String ... groupObjectClasses) {
        this.groupConfig.setLdapClasses(Arrays.asList(groupObjectClasses));
    }

    @ConfigurationProperty(order=18, displayMessageKey="ldap.groupBaseContexts.display", helpMessageKey="ldap.groupBaseContexts.help", groupMessageKey="ldap.optional.group")
    public String[] getGroupBaseContexts() {
        if (this.groupBaseContexts != null && this.groupBaseContexts.length > 0) {
            return (String[])this.groupBaseContexts.clone();
        }
        return this.getBaseContexts();
    }

    public void setGroupBaseContexts(String ... baseContexts) {
        this.groupBaseContexts = (String[])baseContexts.clone();
    }

    @ConfigurationProperty(order=19, displayMessageKey="ldap.groupMemberAttribute.display", helpMessageKey="ldap.groupMemberAttribute.help", groupMessageKey="ldap.optional.group", hidden=false)
    public String getGroupMemberAttribute() {
        return this.groupMemberAttribute;
    }

    public void setGroupMemberAttribute(String groupMemberAttribute) {
        this.groupMemberAttribute = groupMemberAttribute;
    }

    @ConfigurationProperty(order=20, displayMessageKey="ldap.groupSearchFilter.display", helpMessageKey="ldap.groupSearchFilter.help", groupMessageKey="ldap.optional.group")
    public String getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        this.groupSearchFilter = groupSearchFilter;
    }

    @ConfigurationProperty(order=21, displayMessageKey="ldap.maintainLdapGroupMembership.display", helpMessageKey="ldap.maintainLdapGroupMembership.help", groupMessageKey="ldap.optional.group", hidden=false)
    public boolean isMaintainLdapGroupMembership() {
        return this.maintainLdapGroupMembership;
    }

    public void setMaintainLdapGroupMembership(boolean maintainLdapGroupMembership) {
        this.maintainLdapGroupMembership = maintainLdapGroupMembership;
    }

    @ConfigurationProperty(order=22, displayMessageKey="ldap.gidAttribute.display", helpMessageKey="ldap.gidAttribute.help", groupMessageKey="ldap.optional.group", hidden=false)
    public String getGidAttribute() {
        return this.gidAttribute;
    }

    public void setGidAttribute(String gidAttribute) {
        this.gidAttribute = gidAttribute;
    }

    @ConfigurationProperty(order=23, displayMessageKey="ldap.readSchema.display", helpMessageKey="ldap.readSchema.help", groupMessageKey="ldap.optional.group")
    public boolean isReadSchema() {
        return this.readSchema;
    }

    public void setReadSchema(boolean readSchema) {
        this.readSchema = readSchema;
    }

    @ConfigurationProperty(order=24, displayMessageKey="ldap.useVlvControls.display", helpMessageKey="ldap.useVlvControls.help", groupMessageKey="ldap.optional.group")
    public boolean isUseVlvControls() {
        return this.useVlvControls;
    }

    public void setUseVlvControls(boolean useVlvControls) {
        this.useVlvControls = useVlvControls;
    }

    @ConfigurationProperty(order=25, displayMessageKey="ldap.vlvSortAttribute.display", helpMessageKey="ldap.vlvSortAttribute.help", groupMessageKey="ldap.optional.group")
    public String getVlvSortAttribute() {
        return this.vlvSortAttribute;
    }

    public void setVlvSortAttribute(String vlvSortAttribute) {
        this.vlvSortAttribute = vlvSortAttribute;
    }

    @ConfigurationProperty(order=26, operations={SyncOp.class}, displayMessageKey="ldap.baseContextsToSynchronize.display", helpMessageKey="ldap.baseContextsToSynchronize.help", groupMessageKey="ldap.optional.group")
    public String[] getBaseContextsToSynchronize() {
        return (String[])this.baseContextsToSynchronize.clone();
    }

    public void setBaseContextsToSynchronize(String ... baseContextsToSynchronize) {
        this.baseContextsToSynchronize = (String[])baseContextsToSynchronize.clone();
    }

    @ConfigurationProperty(order=27, operations={SyncOp.class}, displayMessageKey="ldap.objectClassesToSynchronize.display", helpMessageKey="ldap.objectClassesToSynchronize.help", groupMessageKey="ldap.optional.group")
    public String[] getObjectClassesToSynchronize() {
        return (String[])this.objectClassesToSynchronize.clone();
    }

    public void setObjectClassesToSynchronize(String ... objectClassesToSynchronize) {
        this.objectClassesToSynchronize = (String[])objectClassesToSynchronize.clone();
    }

    @ConfigurationProperty(order=28, operations={SyncOp.class}, displayMessageKey="ldap.changeLogBlockSize.display", helpMessageKey="ldap.changeLogBlockSize.help", groupMessageKey="ldap.optional.group")
    public int getChangeLogBlockSize() {
        return this.changeLogBlockSize;
    }

    public void setChangeLogBlockSize(int changeLogBlockSize) {
        this.changeLogBlockSize = changeLogBlockSize;
    }

    @ConfigurationProperty(order=29, operations={SyncOp.class}, displayMessageKey="ldap.changeNumberAttribute.display", helpMessageKey="ldap.changeNumberAttribute.help", groupMessageKey="ldap.optional.group")
    public String getChangeNumberAttribute() {
        return this.changeNumberAttribute;
    }

    public void setChangeNumberAttribute(String changeNumberAttribute) {
        this.changeNumberAttribute = changeNumberAttribute;
    }

    @ConfigurationProperty(order=30, operations={SyncOp.class}, displayMessageKey="ldap.filterWithOrInsteadOfAnd.display", helpMessageKey="ldap.filterWithOrInsteadOfAnd.help", groupMessageKey="ldap.optional.group")
    public boolean isFilterWithOrInsteadOfAnd() {
        return this.filterWithOrInsteadOfAnd;
    }

    public void setFilterWithOrInsteadOfAnd(boolean filterWithOrInsteadOfAnd) {
        this.filterWithOrInsteadOfAnd = filterWithOrInsteadOfAnd;
    }

    @ConfigurationProperty(order=31, operations={SyncOp.class}, displayMessageKey="ldap.removeLogEntryObjectClassFromFilter.display", helpMessageKey="ldap.removeLogEntryObjectClassFromFilter.help", groupMessageKey="ldap.optional.group")
    public boolean isRemoveLogEntryObjectClassFromFilter() {
        return this.removeLogEntryObjectClassFromFilter;
    }

    public void setRemoveLogEntryObjectClassFromFilter(boolean removeLogEntryObjectClassFromFilter) {
        this.removeLogEntryObjectClassFromFilter = removeLogEntryObjectClassFromFilter;
    }

    @ConfigurationProperty(order=32, displayMessageKey="ldap.dnAttribute.display", helpMessageKey="ldap.dnAttribute.help", groupMessageKey="ldap.optional.group")
    public String getDnAttribute() {
        return this.dnAttribute;
    }

    public void setDnAttribute(String dnAttribute) {
        this.dnAttribute = dnAttribute;
    }

    @ConfigurationProperty(order=33, displayMessageKey="ldap.failover.display", helpMessageKey="ldap.failover.help", groupMessageKey="ldap.optional.group")
    public String[] getFailover() {
        return (String[])this.failover.clone();
    }

    public void setFailover(String ... failover) {
        this.failover = failover;
    }

    @ConfigurationProperty(order=34, displayMessageKey="ldap.groupNameAttributes.display", helpMessageKey="ldap.groupNameAttributes.help", groupMessageKey="ldap.optional.group", hidden=true)
    public String[] getGroupNameAttributes() {
        List<String> shortNameLdapAttributes = this.groupConfig.getShortNameLdapAttributes();
        return shortNameLdapAttributes.toArray(new String[shortNameLdapAttributes.size()]);
    }

    public void setGroupNameAttributes(String ... groupNameAttributes) {
        this.groupConfig.setShortNameLdapAttributes(Arrays.asList(groupNameAttributes));
    }

    @ConfigurationProperty(order=35, displayMessageKey="ldap.maintainPosixGroupMembership.display", helpMessageKey="ldap.maintainPosixGroupMembership.help", groupMessageKey="ldap.optional.group", hidden=true)
    public boolean isMaintainPosixGroupMembership() {
        return this.maintainPosixGroupMembership;
    }

    public void setMaintainPosixGroupMembership(boolean maintainPosixGroupMembership) {
        this.maintainPosixGroupMembership = maintainPosixGroupMembership;
    }

    public void setRespectResourcePasswordPolicyChangeAfterReset(boolean respectResourcePasswordPolicyChangeAfterReset) {
        this.respectResourcePasswordPolicyChangeAfterReset = respectResourcePasswordPolicyChangeAfterReset;
    }

    @ConfigurationProperty(order=36, operations={SyncOp.class}, displayMessageKey="ldap.attributesToSynchronize.display", helpMessageKey="ldap.attributesToSynchronize.help", groupMessageKey="ldap.optional.group")
    public String[] getAttributesToSynchronize() {
        return (String[])this.attributesToSynchronize.clone();
    }

    public void setAttributesToSynchronize(String ... attributesToSynchronize) {
        this.attributesToSynchronize = (String[])attributesToSynchronize.clone();
    }

    @ConfigurationProperty(order=37, operations={SyncOp.class}, displayMessageKey="ldap.modifiersNamesToFilterOut.display", helpMessageKey="ldap.modifiersNamesToFilterOut.help", groupMessageKey="ldap.optional.group")
    public String[] getModifiersNamesToFilterOut() {
        return (String[])this.modifiersNamesToFilterOut.clone();
    }

    public void setModifiersNamesToFilterOut(String ... modifiersNamesToFilterOut) {
        this.modifiersNamesToFilterOut = (String[])modifiersNamesToFilterOut.clone();
    }

    @ConfigurationProperty(order=38, operations={SyncOp.class}, displayMessageKey="ldap.accountSynchronizationFilter.display", helpMessageKey="ldap.accountSynchronizationFilter.help", groupMessageKey="ldap.optional.group")
    public String getAccountSynchronizationFilter() {
        return this.accountSynchronizationFilter;
    }

    public void setAccountSynchronizationFilter(String accountSynchronizationFilter) {
        this.accountSynchronizationFilter = accountSynchronizationFilter;
    }

    public List<LdapName> getBaseContextsAsLdapNames() {
        if (this.baseContextsAsLdapNames == null) {
            ArrayList<LdapName> result = new ArrayList<LdapName>(this.baseContexts.length);
            try {
                for (String baseContext : this.baseContexts) {
                    result.add(new LdapName(baseContext));
                }
            }
            catch (InvalidNameException e) {
                throw new ConfigurationException("ldap.baseContexts.noInvalidLdapNames", (Throwable)e);
            }
            this.baseContextsAsLdapNames = result;
        }
        return this.baseContextsAsLdapNames;
    }

    public List<LdapName> getBaseContextsToSynchronizeAsLdapNames() {
        if (this.baseContextsToSynchronizeAsLdapNames == null) {
            String[] source = LdapUtil.nullAsEmpty(this.baseContextsToSynchronize);
            ArrayList<LdapName> result = new ArrayList<LdapName>(source.length);
            try {
                for (String each : source) {
                    result.add(new LdapName(each));
                }
            }
            catch (InvalidNameException e) {
                throw new ConfigurationException("ldap.baseContextsToSynchronize.noInvalidLdapNames", (Throwable)e);
            }
            this.baseContextsToSynchronizeAsLdapNames = result;
        }
        return this.baseContextsToSynchronizeAsLdapNames;
    }

    public Set<LdapName> getModifiersNamesToFilterOutAsLdapNames() {
        if (this.modifiersNamesToFilterOutAsLdapNames == null) {
            String[] source = LdapUtil.nullAsEmpty(this.modifiersNamesToFilterOut);
            HashSet<LdapName> result = new HashSet<LdapName>(source.length);
            try {
                for (String each : source) {
                    result.add(new LdapName(each));
                }
            }
            catch (InvalidNameException e) {
                throw new ConfigurationException("ldap.modifiersNamesToFilterOut.noInvalidLdapNames", (Throwable)e);
            }
            this.modifiersNamesToFilterOutAsLdapNames = result;
        }
        return this.modifiersNamesToFilterOutAsLdapNames;
    }

    public Map<ObjectClass, ObjectClassMappingConfig> getObjectClassMappingConfigs() {
        HashMap<ObjectClass, ObjectClassMappingConfig> result = new HashMap<ObjectClass, ObjectClassMappingConfig>();
        result.put(this.accountConfig.getObjectClass(), this.accountConfig);
        result.put(this.groupConfig.getObjectClass(), this.groupConfig);
        result.put(this.organizationConfig.getObjectClass(), this.organizationConfig);
        return result;
    }

    private EqualsHashCodeBuilder createHashCodeBuilder() {
        EqualsHashCodeBuilder builder = new EqualsHashCodeBuilder();
        builder.append((Object)this.host);
        builder.append((Object)this.port);
        builder.append((Object)this.ssl);
        builder.append((Object)this.failover);
        builder.append((Object)this.principal);
        builder.append((Object)this.credentials);
        for (String baseContext : this.baseContexts) {
            builder.append((Object)baseContext);
        }
        builder.append((Object)this.passwordAttribute);
        builder.append((Object)this.accountSearchFilter);
        builder.append((Object)this.groupMemberAttribute);
        builder.append((Object)this.maintainLdapGroupMembership);
        builder.append((Object)this.maintainPosixGroupMembership);
        builder.append((Object)this.passwordHashAlgorithm);
        builder.append((Object)this.respectResourcePasswordPolicyChangeAfterReset);
        builder.append((Object)this.useVlvControls);
        builder.append((Object)this.vlvSortAttribute);
        builder.append((Object)this.readSchema);
        for (String baseContextToSynchronize : this.baseContextsToSynchronize) {
            builder.append((Object)baseContextToSynchronize);
        }
        for (String objectClassToSynchronize : this.objectClassesToSynchronize) {
            builder.append((Object)objectClassToSynchronize);
        }
        for (String attributeToSynchronize : this.attributesToSynchronize) {
            builder.append((Object)attributeToSynchronize);
        }
        for (String modifiersNameToFilterOut : this.modifiersNamesToFilterOut) {
            builder.append((Object)modifiersNameToFilterOut);
        }
        builder.append((Object)this.accountSynchronizationFilter);
        builder.append((Object)this.changeLogBlockSize);
        builder.append((Object)this.changeNumberAttribute);
        builder.append((Object)this.filterWithOrInsteadOfAnd);
        builder.append((Object)this.removeLogEntryObjectClassFromFilter);
        builder.append((Object)this.synchronizePasswords);
        builder.append((Object)this.passwordAttributeToSynchronize);
        builder.append((Object)this.accountConfig);
        builder.append((Object)this.organizationConfig);
        builder.append((Object)this.groupConfig);
        builder.append((Object)this.retrievePasswordsWithSearch);
        builder.append((Object)this.groupSearchFilter);
        builder.append((Object)this.connectTimeout);
        builder.append((Object)this.readTimeout);
        return builder;
    }

    public int hashCode() {
        return this.createHashCodeBuilder().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LdapConfiguration) {
            LdapConfiguration that = (LdapConfiguration)((Object)obj);
            if (this == that) {
                return true;
            }
            return this.createHashCodeBuilder().equals((Object)that.createHashCodeBuilder());
        }
        return false;
    }
}

