/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.ldap;

import com.bamboocloud.icf.common.CollectionUtil;
import com.bamboocloud.icf.common.StringUtil;
import com.bamboocloud.icf.common.logging.Log;
import com.bamboocloud.icf.common.security.GuardedString;
import com.bamboocloud.icf.connector.ldap.LdapAuthenticate;
import com.bamboocloud.icf.connector.ldap.LdapConfiguration;
import com.bamboocloud.icf.connector.ldap.LdapConnection;
import com.bamboocloud.icf.connector.ldap.modify.LdapCreate;
import com.bamboocloud.icf.connector.ldap.modify.LdapDelete;
import com.bamboocloud.icf.connector.ldap.modify.LdapUpdate;
import com.bamboocloud.icf.connector.ldap.schema.LdapSchemaMapping;
import com.bamboocloud.icf.connector.ldap.search.LdapFilter;
import com.bamboocloud.icf.connector.ldap.search.LdapFilterTranslator;
import com.bamboocloud.icf.connector.ldap.search.LdapSearch;
import com.bamboocloud.icf.connector.ldap.search.LdapSearches;
import com.bamboocloud.icf.connector.ldap.sync.sunds.SunDSChangeLogSyncStrategy;
import com.bamboocloud.icf.framework.common.exceptions.ConfigurationException;
import com.bamboocloud.icf.framework.common.exceptions.ObjectNotExistsException;
import com.bamboocloud.icf.framework.common.exceptions.UnsupportedObjectOperationException;
import com.bamboocloud.icf.framework.common.objects.Attribute;
import com.bamboocloud.icf.framework.common.objects.AttributeBuilder;
import com.bamboocloud.icf.framework.common.objects.AttributeInfo;
import com.bamboocloud.icf.framework.common.objects.AttributeUtil;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import com.bamboocloud.icf.framework.common.objects.ObjectClassInfo;
import com.bamboocloud.icf.framework.common.objects.OperationOptions;
import com.bamboocloud.icf.framework.common.objects.ResultsHandler;
import com.bamboocloud.icf.framework.common.objects.Schema;
import com.bamboocloud.icf.framework.common.objects.SyncResultsHandler;
import com.bamboocloud.icf.framework.common.objects.SyncToken;
import com.bamboocloud.icf.framework.common.objects.attributes.Code;
import com.bamboocloud.icf.framework.common.objects.attributes.Fullname;
import com.bamboocloud.icf.framework.common.objects.attributes.GroupMemberOf;
import com.bamboocloud.icf.framework.common.objects.attributes.Id;
import com.bamboocloud.icf.framework.common.objects.attributes.Lockout;
import com.bamboocloud.icf.framework.common.objects.attributes.Name;
import com.bamboocloud.icf.framework.common.objects.attributes.Organization;
import com.bamboocloud.icf.framework.common.objects.attributes.Parent;
import com.bamboocloud.icf.framework.common.objects.attributes.Uid;
import com.bamboocloud.icf.framework.common.objects.filter.FilterTranslator;
import com.bamboocloud.icf.framework.spi.Configuration;
import com.bamboocloud.icf.framework.spi.ConnectorClass;
import com.bamboocloud.icf.framework.spi.PoolableConnector;
import com.bamboocloud.icf.framework.spi.operations.AuthenticateOp;
import com.bamboocloud.icf.framework.spi.operations.CreateOp;
import com.bamboocloud.icf.framework.spi.operations.DeleteOp;
import com.bamboocloud.icf.framework.spi.operations.ResolveUsernameOp;
import com.bamboocloud.icf.framework.spi.operations.SchemaOp;
import com.bamboocloud.icf.framework.spi.operations.SearchOp;
import com.bamboocloud.icf.framework.spi.operations.SyncOp;
import com.bamboocloud.icf.framework.spi.operations.TestOp;
import com.bamboocloud.icf.framework.spi.operations.UpdateAttributeValuesOp;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

@ConnectorClass(configurationClass=LdapConfiguration.class, displayNameKey="LdapConnector", ErrorMessageHandler=ConnectorClass.ErrorMessageHandlerEnum.NEW_ERROR_HANDLER)
public class LdapConnector
implements TestOp,
PoolableConnector,
SchemaOp,
SearchOp<LdapFilter>,
AuthenticateOp,
ResolveUsernameOp,
CreateOp,
DeleteOp,
UpdateAttributeValuesOp,
SyncOp {
    public static final String S_AM_ACCOUNT_NAME = "sAMAccountName";
    private LdapConfiguration config;
    private LdapConnection conn;
    private static final Log LOG = Log.getLog(LdapConnector.class);

    public Configuration getConfiguration() {
        return this.config;
    }

    public void init(Configuration cfg) {
        this.config = (LdapConfiguration)cfg;
        this.conn = new LdapConnection(this.config);
    }

    public void dispose() {
        this.conn.close();
    }

    public void test() {
        this.conn.test();
    }

    public void checkAlive() {
        this.conn.checkAlive();
    }

    public Schema schema() {
        return this.conn.getSchemaMapping().schema();
    }

    public Uid authenticate(ObjectClass objectClass, String username, GuardedString password, OperationOptions options) {
        return new LdapAuthenticate(this.conn, objectClass, username, options).authenticate(password);
    }

    public Uid resolveUsername(ObjectClass objectClass, String username, OperationOptions options) {
        return new LdapAuthenticate(this.conn, objectClass, username, options).resolveUsername();
    }

    public FilterTranslator<LdapFilter> createFilterTranslator(ObjectClass oclass, OperationOptions options) {
        return new LdapFilterTranslator(this.conn.getSchemaMapping(), oclass);
    }

    public void executeQuery(ObjectClass oclass, LdapFilter query, ResultsHandler handler, OperationOptions options) {
        new LdapSearch(this.conn, oclass, query, handler, options).execute();
    }

    public Uid create(ObjectClass oclass, Set<Attribute> attrs, OperationOptions options) {
        HashSet<Attribute> newAttributes = new HashSet<Attribute>(attrs);
        if (ObjectClass.ACCOUNT_NAME.equals(oclass.getObjectClassValue())) {
            Attribute uidAttribute;
            Attribute cnAttribute = AttributeUtil.find((String)"cn", newAttributes);
            if (null == cnAttribute) {
                Attribute newCnAttr = AttributeBuilder.build((String)"cn", (Object[])new Object[]{AttributeUtil.getAsStringValue((Attribute)AttributeUtil.find((String)Name.NAME, attrs))});
                newAttributes.add(newCnAttr);
            }
            if (null == (uidAttribute = AttributeUtil.find((String)"uid", attrs))) {
                Attribute newUidAttr = AttributeBuilder.build((String)"uid", (Object[])new Object[]{AttributeUtil.getAsStringValue((Attribute)AttributeUtil.find((String)Name.NAME, attrs))});
                newAttributes.add(newUidAttr);
            }
        }
        Set<Attribute> attributes = this.convertAttr(oclass, newAttributes);
        return new LdapCreate(this.conn, oclass, attributes, options).execute();
    }

    public Set<Attribute> convertAttr(ObjectClass oclass, Set<Attribute> attrs) {
        HashSet<Attribute> newAttrs = new HashSet<Attribute>();
        if (ObjectClass.ACCOUNT_NAME.equals(oclass.getObjectClassValue())) {
            String dnPrefix;
            String orgEntryDN;
            attrs.forEach(attr -> {
                if (Fullname.NAME.equals(attr.getName())) {
                    Attribute snAttr = AttributeBuilder.build((String)"sn", (Collection)attr.getValue());
                    newAttrs.add(snAttr);
                } else if (GroupMemberOf.NAME.equals(attr.getName())) {
                    LinkedList<String> groupDNList = new LinkedList<String>();
                    List groupUidList = attr.getValue();
                    if (!CollectionUtil.isEmpty((Collection)groupUidList)) {
                        for (Object groupUid : groupUidList) {
                            String groupDN;
                            if (groupUid == null || groupUid.equals("") || !StringUtil.isNotEmpty((String)(groupDN = LdapSearches.findEntryDN(this.conn, ObjectClass.GROUP, new Uid(groupUid.toString()))))) continue;
                            groupDNList.add(groupDN);
                        }
                    }
                    Attribute userGroupAttr = AttributeBuilder.build((String)"ldapGroups", groupDNList);
                    newAttrs.add(userGroupAttr);
                } else if (!(Uid.NAME.equals(attr.getName()) || Id.NAME.equals(attr.getName()) || Organization.NAME.equals(attr.getName()) || Parent.NAME.equals(attr.getName()) || Lockout.NAME.equals(attr.getName()) || Code.NAME.equals(attr.getName()) || Name.NAME.equals(attr.getName()) || "userPrincipalName".equals(attr.getName()) || S_AM_ACCOUNT_NAME.equals(attr.getName()))) {
                    newAttrs.add((Attribute)attr);
                }
            });
            Attribute orgAttr = AttributeUtil.find((String)Organization.NAME, attrs);
            if (orgAttr != null && !CollectionUtil.isEmpty((Collection)orgAttr.getValue()) && StringUtils.isNotBlank((CharSequence)((String)orgAttr.getValue().get(0)))) {
                String orgEntryUUID = AttributeUtil.getStringValue((Attribute)orgAttr);
                orgEntryDN = LdapSearches.findEntryDN(this.conn, LdapSchemaMapping.ANY_OBJECT_CLASS, new Uid(orgEntryUUID));
            } else {
                orgEntryDN = this.conn.getConfiguration().getBaseContexts()[0];
            }
            String string = dnPrefix = StringUtils.isNotBlank((CharSequence)this.conn.getConfiguration().getAccountDNPrefix()) ? this.conn.getConfiguration().getAccountDNPrefix() : "cn";
            if (dnPrefix.equalsIgnoreCase("cn")) {
                dnValue = dnPrefix + "=" + AttributeUtil.getAsStringValue((Attribute)AttributeUtil.find((String)"cn", newAttrs)) + "," + orgEntryDN;
                newAttrs.add((Attribute)new Name(dnValue));
            } else if (dnPrefix.equalsIgnoreCase("uid")) {
                dnValue = dnPrefix + "=" + AttributeUtil.getAsStringValue((Attribute)AttributeUtil.find((String)"uid", newAttrs)) + "," + orgEntryDN;
                newAttrs.add((Attribute)new Name(dnValue));
            } else {
                throw new ConfigurationException("ldap.accountDNPrefix.legalValue");
            }
            boolean isAD = false;
            if (this.conn.getServerType() == LdapConnection.ServerType.UNKNOWN) {
                block0: for (ObjectClassInfo objectClassInfo : this.schema().getObjectClassInfo()) {
                    if (!objectClassInfo.getType().equals(oclass.getObjectClassValue())) continue;
                    for (AttributeInfo attributeInfo : objectClassInfo.getAttributeInfo()) {
                        if (!attributeInfo.getName().equals("userPrincipalName") && !attributeInfo.getName().equals(S_AM_ACCOUNT_NAME)) continue;
                        isAD = true;
                        continue block0;
                    }
                }
            }
            if (isAD) {
                Attribute upnAttr = AttributeUtil.find((String)"userPrincipalName", attrs);
                if (upnAttr != null && ObjectUtils.isNotEmpty((Object)upnAttr.getValue()) && StringUtils.isNotBlank((CharSequence)((String)upnAttr.getValue().get(0)))) {
                    newAttrs.add(AttributeBuilder.build((String)"userPrincipalName", (Object[])new Object[]{AttributeUtil.getSingleValue((Attribute)upnAttr) + "@" + this.getDomain()}));
                } else {
                    newAttrs.add(AttributeBuilder.build((String)"userPrincipalName", (Object[])new Object[]{AttributeUtil.getSingleValue((Attribute)AttributeUtil.find((String)Name.NAME, attrs)) + "@" + this.getDomain()}));
                }
                Attribute samAttr = AttributeUtil.find((String)S_AM_ACCOUNT_NAME, attrs);
                if (samAttr != null && ObjectUtils.isNotEmpty((Object)samAttr.getValue()) && StringUtils.isNotBlank((CharSequence)((String)samAttr.getValue().get(0)))) {
                    newAttrs.add(AttributeBuilder.build((String)S_AM_ACCOUNT_NAME, (Object[])new Object[]{AttributeUtil.getSingleValue((Attribute)samAttr)}));
                } else {
                    newAttrs.add(AttributeBuilder.build((String)S_AM_ACCOUNT_NAME, (Object[])new Object[]{AttributeUtil.getSingleValue((Attribute)AttributeUtil.find((String)Name.NAME, attrs))}));
                }
            }
        } else if (ObjectClass.ORGANIZATION_NAME.equals(oclass.getObjectClassValue())) {
            attrs.forEach(attr -> {
                if (Name.NAME.equals(attr.getName())) {
                    String nameValue = "ou=" + AttributeUtil.getAsStringValue((Attribute)attr);
                    Attribute orgParentAttr = AttributeUtil.find((String)Parent.NAME, (Set)attrs);
                    if (orgParentAttr != null && AttributeUtil.getStringValue((Attribute)orgParentAttr) != null) {
                        String orgParentEntryUUID = AttributeUtil.getStringValue((Attribute)orgParentAttr);
                        String orgParentEntryDN = LdapSearches.findEntryDN(this.conn, oclass, new Uid(orgParentEntryUUID));
                        nameValue = nameValue + "," + orgParentEntryDN;
                    } else {
                        String[] baseContexts = this.conn.getConfiguration().getBaseContexts();
                        if (baseContexts != null) {
                            for (String s : baseContexts) {
                                nameValue = nameValue + "," + s;
                            }
                        }
                    }
                    newAttrs.add((Attribute)new Name(nameValue));
                } else if (Code.NAME.equals(attr.getName())) {
                    Attribute seeAlso = AttributeBuilder.build((String)"description", (Collection)attr.getValue());
                    newAttrs.add(seeAlso);
                } else if (!(Uid.NAME.equals(attr.getName()) || Id.NAME.equals(attr.getName()) || Parent.NAME.equals(attr.getName()) || Fullname.NAME.equals(attr.getName()))) {
                    newAttrs.add((Attribute)attr);
                }
            });
        } else {
            throw new UnsupportedObjectOperationException("ldap.object.operation.unsupported", new String[]{oclass.getObjectClassValue()});
        }
        return newAttrs;
    }

    private String getDomain() {
        String domainContext;
        String[] baseContexts = this.conn.getConfiguration().getBaseContexts();
        Object domain = "";
        if (baseContexts != null && (domainContext = baseContexts[0]).contains("DC=")) {
            String[] domainContextArray;
            domainContext = domainContext.substring(domainContext.indexOf("DC"), domainContext.length());
            for (String s : domainContextArray = domainContext.split("(?i)DC=")) {
                domain = (String)domain + s;
            }
            domain = ((String)domain).replace(",", ".");
        }
        return domain;
    }

    public void delete(ObjectClass oclass, Uid uid, Set<Attribute> attributes, OperationOptions options) {
        new LdapDelete(this.conn, oclass, uid).execute();
    }

    public Uid update(ObjectClass oclass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        HashSet<Attribute> newReplaceAttributes = new HashSet<Attribute>(replaceAttributes);
        if (ObjectClass.ACCOUNT_NAME.equals(oclass.getObjectClassValue())) {
            String dnPrefix;
            Attribute dnPrefixAttribute;
            Attribute orgAttr = AttributeUtil.find((String)Organization.NAME, newReplaceAttributes);
            if (orgAttr == null || CollectionUtil.isEmpty((Collection)orgAttr.getValue()) || orgAttr.getValue().get(0) == null) {
                String existedDN = LdapSearches.findEntryDN(this.conn, oclass, uid);
                String existedOrgDN = existedDN.substring(existedDN.indexOf(",") + 1);
                Uid orgUid = this.conn.getSchemaMapping().createUid(oclass, existedOrgDN);
                newReplaceAttributes.remove(orgAttr);
                newReplaceAttributes.add(AttributeBuilder.build((String)Organization.NAME, (Object[])new Object[]{orgUid.getSingleValue()}));
            }
            if (null == (dnPrefixAttribute = AttributeUtil.find((String)(dnPrefix = StringUtils.isNotBlank((CharSequence)this.conn.getConfiguration().getAccountDNPrefix()) ? this.conn.getConfiguration().getAccountDNPrefix() : "cn"), replaceAttributes)) || dnPrefixAttribute.getValue() == null || StringUtils.isBlank((CharSequence)((String)dnPrefixAttribute.getValue().get(0)))) {
                newReplaceAttributes.remove(dnPrefixAttribute);
                String accOldDN = LdapSearches.getEntryDN(this.conn, oclass, uid);
                if (StringUtils.isNotBlank((CharSequence)accOldDN)) {
                    newReplaceAttributes.add(AttributeBuilder.build((String)dnPrefix, (Object[])new Object[]{accOldDN.substring(accOldDN.indexOf("=") + 1, accOldDN.indexOf(","))}));
                } else {
                    LOG.error("Failed in find account from LDAP by " + accOldDN, new Object[0]);
                    throw new ObjectNotExistsException("ldap.account.not.exist", new String[]{accOldDN});
                }
            }
        }
        Set<Attribute> attributes = this.convertAttr(oclass, newReplaceAttributes);
        return new LdapUpdate(this.conn, oclass, uid).update(attributes);
    }

    public Uid addAttributeValues(ObjectClass oclass, Uid uid, Set<Attribute> valuesToAdd, OperationOptions options) {
        return new LdapUpdate(this.conn, oclass, uid).addAttributeValues(valuesToAdd);
    }

    public Uid removeAttributeValues(ObjectClass oclass, Uid uid, Set<Attribute> valuesToRemove, OperationOptions options) {
        return new LdapUpdate(this.conn, oclass, uid).removeAttributeValues(valuesToRemove);
    }

    public SyncToken getLatestSyncToken(ObjectClass oclass) {
        return new SunDSChangeLogSyncStrategy(this.conn, oclass).getLatestSyncToken();
    }

    public void sync(ObjectClass oclass, SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        new SunDSChangeLogSyncStrategy(this.conn, oclass).sync(token, handler, options);
    }
}

