/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.ldap.commons;

import com.bamboocloud.icf.common.logging.Log;
import com.bamboocloud.icf.connector.ldap.LdapConnection;
import com.bamboocloud.icf.connector.ldap.commons.LdapEntry;
import com.bamboocloud.icf.connector.ldap.search.LdapInternalSearch;
import com.bamboocloud.icf.framework.common.exceptions.InvalidAttributeValueException;
import com.bamboocloud.icf.framework.common.objects.Attribute;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;

public class ADLdapUtil {
    private static final Log log = Log.getLog(ADLdapUtil.class);
    public static final int GROUP_MEMBERS_MAXRANGE = 1500;
    public static final long DIFF_NET_JAVA_FOR_DATE_AND_TIMES = 11644473600000L;

    static String AddLeadingZero(int k) {
        return k <= 15 ? "0" + Integer.toHexString(k) : Integer.toHexString(k);
    }

    public static String objectGUIDtoDashedString(javax.naming.directory.Attribute attr) {
        if (attr == null) {
            return null;
        }
        byte[] GUID = null;
        try {
            GUID = (byte[])attr.get();
            if (GUID.length != 16) {
                throw new InvalidAttributeValueException("objectGUID attribute has the wrong length (" + GUID.length + "). Should be 16 bytes.");
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (GUID == null) {
            return null;
        }
        StringBuilder sGUID = new StringBuilder(43);
        sGUID.append("<GUID=");
        sGUID.append(ADLdapUtil.AddLeadingZero(GUID[3] & 0xFF));
        sGUID.append(ADLdapUtil.AddLeadingZero(GUID[2] & 0xFF));
        sGUID.append(ADLdapUtil.AddLeadingZero(GUID[1] & 0xFF));
        sGUID.append(ADLdapUtil.AddLeadingZero(GUID[0] & 0xFF));
        sGUID.append("-");
        sGUID.append(ADLdapUtil.AddLeadingZero(GUID[5] & 0xFF));
        sGUID.append(ADLdapUtil.AddLeadingZero(GUID[4] & 0xFF));
        sGUID.append("-");
        sGUID.append(ADLdapUtil.AddLeadingZero(GUID[7] & 0xFF));
        sGUID.append(ADLdapUtil.AddLeadingZero(GUID[6] & 0xFF));
        sGUID.append("-");
        sGUID.append(ADLdapUtil.AddLeadingZero(GUID[8] & 0xFF));
        sGUID.append(ADLdapUtil.AddLeadingZero(GUID[9] & 0xFF));
        sGUID.append("-");
        sGUID.append(ADLdapUtil.AddLeadingZero(GUID[10] & 0xFF));
        sGUID.append(ADLdapUtil.AddLeadingZero(GUID[11] & 0xFF));
        sGUID.append(ADLdapUtil.AddLeadingZero(GUID[12] & 0xFF));
        sGUID.append(ADLdapUtil.AddLeadingZero(GUID[13] & 0xFF));
        sGUID.append(ADLdapUtil.AddLeadingZero(GUID[14] & 0xFF));
        sGUID.append(ADLdapUtil.AddLeadingZero(GUID[15] & 0xFF));
        sGUID.append(">");
        return sGUID.toString();
    }

    public static String objectGUIDtoString(javax.naming.directory.Attribute attr) {
        byte[] GUID = null;
        try {
            GUID = ((String)attr.get()).getBytes();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (GUID == null) {
            return null;
        }
        StringBuilder sGUID = new StringBuilder(39);
        sGUID.append("<GUID=");
        for (int i = 0; i < 16; ++i) {
            sGUID.append(ADLdapUtil.AddLeadingZero(GUID[i] & 0xFF));
        }
        sGUID.append(">");
        return sGUID.toString();
    }

    public static String guidDashedStringtoByteString(String dashed) {
        if (dashed.length() != 43) {
            throw new InvalidAttributeValueException("objectGUID attribute has the wrong length (" + dashed.length() + "). Should be 43 characters.");
        }
        StringBuilder bString = new StringBuilder("\\");
        bString.append(dashed.substring(12, 14));
        bString.append("\\");
        bString.append(dashed.substring(10, 12));
        bString.append("\\");
        bString.append(dashed.substring(8, 10));
        bString.append("\\");
        bString.append(dashed.substring(6, 8));
        bString.append("\\");
        bString.append(dashed.substring(17, 19));
        bString.append("\\");
        bString.append(dashed.substring(15, 17));
        bString.append("\\");
        bString.append(dashed.substring(22, 24));
        bString.append("\\");
        bString.append(dashed.substring(20, 22));
        bString.append("\\");
        bString.append(dashed.substring(25, 27));
        bString.append("\\");
        bString.append(dashed.substring(27, 29));
        bString.append("\\");
        bString.append(dashed.substring(30, 32));
        bString.append("\\");
        bString.append(dashed.substring(32, 34));
        bString.append("\\");
        bString.append(dashed.substring(34, 36));
        bString.append("\\");
        bString.append(dashed.substring(36, 38));
        bString.append("\\");
        bString.append(dashed.substring(38, 40));
        bString.append("\\");
        bString.append(dashed.substring(40, 42));
        return bString.toString();
    }

    public static String guidStringtoByteString(String dashed) {
        if (dashed.length() != 39) {
            throw new InvalidAttributeValueException("objectGUID attribute has the wrong length (" + dashed.length() + "). Should be 39 characters.");
        }
        StringBuilder bString = new StringBuilder();
        for (int i = 6; i < 37; i += 2) {
            bString.append("\\");
            bString.append(dashed.substring(i, i + 2));
        }
        return bString.toString();
    }

    public static List fetchGroupMembersByRange(LdapConnection conn, SearchResult result) {
        return ADLdapUtil.fetchGroupMembersByRange(conn, LdapEntry.create(null, result));
    }

    public static List fetchGroupMembersByRange(LdapConnection conn, LdapEntry entry) {
        boolean done = false;
        int first = 0;
        int last = 1499;
        ArrayList members = new ArrayList();
        Attribute range = conn.getSchemaMapping().createAttribute(ObjectClass.GROUP, String.format("member;range=%d-%d", first, last), entry, false);
        if (range != null) {
            members.addAll(range.getValue());
            first = last + 1;
            last = first + 1500 - 1;
            while (!done) {
                try {
                    SearchControls controls = LdapInternalSearch.createDefaultSearchControls();
                    controls.setSearchScope(0);
                    controls.setReturningAttributes(new String[]{String.format("member;range=%d-%d", first, last)});
                    LdapContext context = conn.getInitialContext().newInstance(null);
                    NamingEnumeration<SearchResult> entries = context.search((Name)entry.getDN(), "objectclass=*", controls);
                    SearchResult res = entries.next();
                    if (res != null) {
                        range = conn.getSchemaMapping().createAttribute(ObjectClass.GROUP, String.format("member;range=%d-%d", first, last), LdapEntry.create(null, res), true);
                        if (range.getValue().isEmpty()) {
                            range = conn.getSchemaMapping().createAttribute(ObjectClass.GROUP, String.format("member;range=%d-*", first), LdapEntry.create(null, res), true);
                            done = true;
                        }
                        members.addAll(range.getValue());
                    }
                }
                catch (NamingException e) {
                    log.error((Throwable)e, "Error reading group member;range attribute", new Object[0]);
                }
                first = last + 1;
                last = first + 1500 - 1;
            }
        }
        return members;
    }

    public static Date getJavaDateFromADTime(String adTime) {
        long milliseconds = Long.parseLong(adTime) / 10000L - 11644473600000L;
        return new Date(milliseconds);
    }

    public static String getADTimeFromJavaDate(Date date) {
        return Long.toString((date.getTime() + 11644473600000L) * 10000L);
    }

    public static String getADTimeFromISO8601Date(String date) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return ADLdapUtil.getADTimeFromJavaDate(df.parse(date));
    }

    public static String getADLdapDatefromJavaDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(date) + ".0Z";
    }

    public static String getISO8601DatefromJavaDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(date);
    }

    public static byte[] charToByte(char c) {
        byte[] b = new byte[]{(byte)((c & 0xFF00) >> 8), (byte)(c & 0xFF)};
        return b;
    }
}

