/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.ldap.commons;

import com.bamboocloud.icf.common.CollectionUtil;
import com.bamboocloud.icf.framework.common.objects.AttributeInfo;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import java.util.List;
import java.util.Set;

public class ObjectClassMappingConfig {
    private final ObjectClass objectClass;
    private List<String> ldapClasses;
    private final boolean container;
    private List<String> shortNameLdapAttributes;
    private final Set<AttributeInfo> operationalAttributes;

    public ObjectClassMappingConfig(ObjectClass objectClass, List<String> ldapClasses, boolean container, List<String> shortNameLdapAttributes, AttributeInfo ... operationalAttributes) {
        assert (objectClass != null);
        this.objectClass = objectClass;
        assert (ldapClasses != null);
        this.setLdapClasses(ldapClasses);
        this.container = container;
        assert (shortNameLdapAttributes != null);
        this.shortNameLdapAttributes = CollectionUtil.newReadOnlyList(shortNameLdapAttributes);
        this.operationalAttributes = CollectionUtil.newReadOnlySet((Object[])operationalAttributes);
    }

    public ObjectClass getObjectClass() {
        return this.objectClass;
    }

    public List<String> getLdapClasses() {
        return this.ldapClasses;
    }

    public final void setLdapClasses(List<String> ldapClasses) {
        this.ldapClasses = CollectionUtil.newReadOnlyList(ldapClasses);
    }

    public boolean isContainer() {
        return this.container;
    }

    public List<String> getShortNameLdapAttributes() {
        return this.shortNameLdapAttributes;
    }

    public void setShortNameLdapAttributes(List<String> shortNameLdapAttributes) {
        this.shortNameLdapAttributes = CollectionUtil.newReadOnlyList(shortNameLdapAttributes);
    }

    public Set<AttributeInfo> getOperationalAttributes() {
        return this.operationalAttributes;
    }

    public int hashCode() {
        return this.objectClass.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ObjectClassMappingConfig) {
            ObjectClassMappingConfig that = (ObjectClassMappingConfig)o;
            if (!this.objectClass.equals((Object)that.objectClass)) {
                return false;
            }
            if (!this.ldapClasses.equals(that.ldapClasses)) {
                return false;
            }
            if (this.container != that.container) {
                return false;
            }
            if (!this.shortNameLdapAttributes.equals(that.shortNameLdapAttributes)) {
                return false;
            }
            return this.operationalAttributes.equals(that.operationalAttributes);
        }
        return false;
    }
}

