/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.ldap.modify;

import com.bamboocloud.icf.common.CollectionUtil;
import com.bamboocloud.icf.common.logging.Log;
import com.bamboocloud.icf.connector.ldap.LdapConnection;
import com.bamboocloud.icf.connector.ldap.commons.GroupHelper;
import com.bamboocloud.icf.connector.ldap.commons.LdapConstants;
import com.bamboocloud.icf.connector.ldap.commons.LdapModifyOperation;
import com.bamboocloud.icf.connector.ldap.commons.LdapUtil;
import com.bamboocloud.icf.connector.ldap.commons.StatusManagement;
import com.bamboocloud.icf.connector.ldap.schema.GuardedPasswordAttribute;
import com.bamboocloud.icf.connector.ldap.search.LdapSearches;
import com.bamboocloud.icf.connector.ldap.util.ADGuardedPasswordAttribute;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorException;
import com.bamboocloud.icf.framework.common.objects.Attribute;
import com.bamboocloud.icf.framework.common.objects.AttributeUtil;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import com.bamboocloud.icf.framework.common.objects.OperationOptions;
import com.bamboocloud.icf.framework.common.objects.OperationalAttributes;
import com.bamboocloud.icf.framework.common.objects.attributes.ManagerId;
import com.bamboocloud.icf.framework.common.objects.attributes.Name;
import com.bamboocloud.icf.framework.common.objects.attributes.Password;
import com.bamboocloud.icf.framework.common.objects.attributes.Uid;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidAttributeValueException;

public class LdapCreate
extends LdapModifyOperation {
    private final ObjectClass oclass;
    private final Set<Attribute> attrs;
    private static final Log LOG = Log.getLog(LdapConnection.class);

    public LdapCreate(LdapConnection conn, ObjectClass oclass, Set<Attribute> attrs, OperationOptions options) {
        super(conn);
        this.oclass = oclass;
        this.attrs = attrs;
    }

    public Uid execute() {
        try {
            return this.executeImpl();
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private Uid executeImpl() throws NamingException {
        final Name nameAttr = AttributeUtil.getNameFromAttributes(this.attrs);
        if (nameAttr == null) {
            throw new InvalidAttributeValueException("ldap.attribute.not.have.error");
        }
        ArrayList<String> ldapGroups = new ArrayList<String>();
        ArrayList<String> posixGroups = new ArrayList<String>();
        GuardedPasswordAttribute pwdAttr = null;
        ADGuardedPasswordAttribute adPwdAttr = null;
        Boolean status = null;
        int uacValue = 512;
        final BasicAttributes ldapAttrs = new BasicAttributes(true);
        String uidAttribute = this.conn.getConfiguration().getUidAttribute();
        for (Attribute attr2 : this.attrs) {
            javax.naming.directory.Attribute ldapAttr = null;
            if (attr2.is(Name.NAME)) continue;
            if (LdapConstants.isLdapGroups(attr2.getName())) {
                ldapGroups.addAll(LdapUtil.checkedListByFilter(CollectionUtil.nullAsEmpty((List)attr2.getValue()), String.class));
                continue;
            }
            if (LdapConstants.isPosixGroups(attr2.getName())) {
                posixGroups.addAll(LdapUtil.checkedListByFilter(CollectionUtil.nullAsEmpty((List)attr2.getValue()), String.class));
                continue;
            }
            if (attr2.is(OperationalAttributes.PASSWORD_NAME)) {
                if ("objectGUID".equals(uidAttribute)) {
                    adPwdAttr = ADGuardedPasswordAttribute.create(this.conn.getConfiguration().getPasswordAttribute(), attr2);
                    ldapAttrs.put(Password.NAME, adPwdAttr);
                    continue;
                }
                pwdAttr = this.conn.getSchemaMapping().encodePassword(this.oclass, attr2);
                continue;
            }
            if (attr2.is(OperationalAttributes.ENABLE_NAME)) {
                if (attr2.getValue() == null || attr2.getValue().isEmpty()) continue;
                status = Boolean.parseBoolean(attr2.getValue().get(0).toString());
                continue;
            }
            if (attr2.is(ManagerId.NAME)) {
                if (attr2.getValue() == null || attr2.getValue().isEmpty() || attr2.getValue().get(0) == null) continue;
                String manager = LdapSearches.getEntryDN(this.conn, ObjectClass.ACCOUNT, new Uid(attr2.getValue().get(0).toString()));
                BasicAttribute managerAttr = new BasicAttribute("manager", manager);
                ldapAttrs.put(managerAttr);
                continue;
            }
            ldapAttr = this.conn.getSchemaMapping().encodeAttribute(this.oclass, attr2);
            if (ldapAttr == null || ldapAttr.size() <= 0) continue;
            ldapAttrs.put(ldapAttr);
        }
        long countUserAccountControl = this.attrs.stream().filter(attr -> attr.is("userAccountControl")).count();
        if (countUserAccountControl == 0L) {
            this.setUserAccountControl(ldapAttrs, status, uacValue, uidAttribute);
        }
        if (ObjectClass.GROUP.equals((Object)this.oclass)) {
            this.groupHelper.addMemberAttributeIfMissing(ldapAttrs);
        }
        final String[] entryDN = new String[]{null};
        if (pwdAttr != null) {
            pwdAttr.access(new GuardedPasswordAttribute.Accessor(){

                @Override
                public void access(javax.naming.directory.Attribute passwordAttr) {
                    LdapCreate.this.hashPassword(passwordAttr, null);
                    ldapAttrs.put(passwordAttr);
                    entryDN[0] = LdapCreate.this.conn.getSchemaMapping().create(LdapCreate.this.oclass, nameAttr, ldapAttrs);
                }
            });
        }
        if (adPwdAttr != null) {
            adPwdAttr.access(new ADGuardedPasswordAttribute.Accessor(){

                @Override
                public void access(BasicAttribute attr) {
                    try {
                        if (attr.get() != null && !attr.get().toString().isEmpty()) {
                            ldapAttrs.put(attr);
                        }
                    }
                    catch (NamingException e) {
                        LOG.error((Throwable)e, "Error retrieving password value", new Object[0]);
                    }
                }
            });
            entryDN[0] = this.conn.getSchemaMapping().create(this.oclass, nameAttr, ldapAttrs);
        }
        if (entryDN[0] == null) {
            entryDN[0] = this.conn.getSchemaMapping().create(this.oclass, nameAttr, ldapAttrs);
        }
        if (!CollectionUtil.isEmpty(ldapGroups)) {
            this.groupHelper.addLdapGroupMemberships(entryDN[0], ldapGroups);
        }
        if (!CollectionUtil.isEmpty(posixGroups)) {
            Set<String> posixRefAttrs = LdapCreate.getAttributeValues(GroupHelper.getPosixRefAttribute(), null, ldapAttrs);
            String posixRefAttr = this.getFirstPosixRefAttr(entryDN[0], posixRefAttrs);
            this.groupHelper.addPosixGroupMemberships(posixRefAttr, posixGroups);
        }
        return this.conn.getSchemaMapping().createUid(this.oclass, entryDN[0]);
    }

    private void setUserAccountControl(BasicAttributes ldapAttrs, Boolean status, int uacValue, String uidAttribute) {
        if (!this.oclass.is(ObjectClass.ACCOUNT_NAME) || !"objectGUID".equals(uidAttribute)) {
            return;
        }
        javax.naming.directory.Attribute passwordAttr = ldapAttrs.get(Password.NAME);
        if (passwordAttr != null) {
            javax.naming.directory.Attribute passwordNeverExpiresAttr = ldapAttrs.get("passwordNeverExpires");
            if (passwordNeverExpiresAttr != null) {
                try {
                    Object value = passwordNeverExpiresAttr.get();
                    if (value != null && ((Boolean)value).booleanValue()) {
                        uacValue |= 0x10000;
                    }
                }
                catch (NamingException e) {
                    LOG.error("The value of passwordNeverExpires of UserAccountControl is calculated abnormally, message:" + e.getMessage(), new Object[]{e});
                }
                ldapAttrs.remove("passwordNeverExpires");
            }
            ldapAttrs.remove(Password.NAME);
        } else {
            uacValue |= 0x20;
        }
        ldapAttrs.put("userAccountControl", String.valueOf(uacValue));
        if (status != null) {
            String statusManagementClass = this.conn.getConfiguration().getStatusManagementClass();
            StatusManagement.getInstance(statusManagementClass == null ? "DefaultStatusManagement" : statusManagementClass).setStatus(status, ldapAttrs, null, null);
        }
    }
}

