/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.ldap.modify;

import com.bamboocloud.icf.connector.ldap.LdapConnection;
import com.bamboocloud.icf.connector.ldap.commons.GroupHelper;
import com.bamboocloud.icf.connector.ldap.commons.LdapModifyOperation;
import com.bamboocloud.icf.connector.ldap.search.LdapSearches;
import com.bamboocloud.icf.framework.common.exceptions.APIFailedException;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import com.bamboocloud.icf.framework.common.objects.attributes.Uid;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;

public class LdapDelete
extends LdapModifyOperation {
    private final ObjectClass oclass;
    private final Uid uid;

    public LdapDelete(LdapConnection conn, ObjectClass oclass, Uid uid) {
        super(conn);
        this.oclass = oclass;
        this.uid = uid;
    }

    public void execute() {
        String entryDN = LdapSearches.getEntryDN(this.conn, this.oclass, this.uid);
        if (this.conn.getConfiguration().isMaintainLdapGroupMembership()) {
            List<String> ldapGroups = this.groupHelper.getLdapGroups(entryDN);
            this.groupHelper.removeLdapGroupMemberships(entryDN, ldapGroups);
        }
        if (this.conn.getConfiguration().isMaintainPosixGroupMembership()) {
            LdapModifyOperation.PosixGroupMember posixMember = new LdapModifyOperation.PosixGroupMember(entryDN);
            Set<GroupHelper.GroupMembership> memberships = posixMember.getPosixGroupMemberships();
            this.groupHelper.removePosixGroupMemberships(memberships);
        }
        try {
            this.conn.getInitialContext().destroySubcontext(entryDN);
        }
        catch (NamingException e) {
            throw new APIFailedException((Throwable)e);
        }
    }
}

