/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.ldap.modify;

import com.bamboocloud.icf.common.CollectionUtil;
import com.bamboocloud.icf.common.Pair;
import com.bamboocloud.icf.connector.ldap.LdapConnection;
import com.bamboocloud.icf.connector.ldap.commons.ADLdapUtil;
import com.bamboocloud.icf.connector.ldap.commons.GroupHelper;
import com.bamboocloud.icf.connector.ldap.commons.LdapConstants;
import com.bamboocloud.icf.connector.ldap.commons.LdapModifyOperation;
import com.bamboocloud.icf.connector.ldap.commons.LdapUtil;
import com.bamboocloud.icf.connector.ldap.commons.StatusManagement;
import com.bamboocloud.icf.connector.ldap.schema.GuardedPasswordAttribute;
import com.bamboocloud.icf.connector.ldap.search.LdapFilter;
import com.bamboocloud.icf.connector.ldap.search.LdapSearches;
import com.bamboocloud.icf.connector.ldap.util.ADGuardedPasswordAttribute;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorException;
import com.bamboocloud.icf.framework.common.exceptions.InvalidAttributeValueException;
import com.bamboocloud.icf.framework.common.objects.Attribute;
import com.bamboocloud.icf.framework.common.objects.AttributeBuilder;
import com.bamboocloud.icf.framework.common.objects.AttributeUtil;
import com.bamboocloud.icf.framework.common.objects.ConnectorObject;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import com.bamboocloud.icf.framework.common.objects.OperationalAttributes;
import com.bamboocloud.icf.framework.common.objects.attributes.ManagerId;
import com.bamboocloud.icf.framework.common.objects.attributes.Name;
import com.bamboocloud.icf.framework.common.objects.attributes.Uid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class LdapUpdate
extends LdapModifyOperation {
    public static final String OBJECTGUID = "objectGUID";
    public static final String UACCONTROL_ATTR = "userAccountControl";
    private final ObjectClass oclass;
    private final Uid uid;

    public LdapUpdate(LdapConnection conn, ObjectClass oclass, Uid uid) {
        super(conn);
        this.oclass = oclass;
        this.uid = uid;
    }

    public Uid update(Set<Attribute> attrs) {
        Attributes ldapAttrs;
        String entryDN = LdapSearches.findEntryDN(this.conn, this.oclass, this.uid);
        LdapModifyOperation.PosixGroupMember posixMember = new LdapModifyOperation.PosixGroupMember(entryDN);
        Set updateAttrs = attrs;
        Name newName = AttributeUtil.getNameFromAttributes((Set)attrs);
        Attribute status = AttributeUtil.find((String)OperationalAttributes.ENABLE_NAME, (Set)attrs);
        String newEntryDN = null;
        if (newName != null) {
            updateAttrs = CollectionUtil.newSet((Collection)attrs);
            updateAttrs.remove(newName);
            updateAttrs.remove(AttributeUtil.find((String)LdapUtil.getDNAttributeName(newName), (Set)attrs));
            newEntryDN = this.conn.getSchemaMapping().getEntryDN(this.oclass, newName);
        }
        List<String> ldapGroups = this.getStringListValue(updateAttrs, "ldapGroups");
        List<String> posixGroups = this.getStringListValue(updateAttrs, "posixGroups");
        String uidAttribute = this.conn.getConfiguration().getUidAttribute();
        Pair<Attributes, ADGuardedPasswordAttribute> adAttributesToModify = null;
        Pair<Attributes, GuardedPasswordAttribute> attrToModify = null;
        if (uidAttribute != null && !uidAttribute.isEmpty() && OBJECTGUID.equals(uidAttribute)) {
            adAttributesToModify = this.getAdAttributesToModify(updateAttrs);
            ldapAttrs = (Attributes)adAttributesToModify.first;
        } else {
            attrToModify = this.getAttributesToModify(updateAttrs);
            ldapAttrs = (Attributes)attrToModify.first;
        }
        Set<String> newPosixRefAttrs = LdapUpdate.getAttributeValues(GroupHelper.getPosixRefAttribute(), LdapUtil.quietCreateLdapName(newEntryDN != null ? newEntryDN : entryDN), ldapAttrs);
        if (newPosixRefAttrs != null && newPosixRefAttrs.isEmpty()) {
            this.checkRemovedPosixRefAttrs(posixMember.getPosixRefAttributes(), posixMember.getPosixGroupMemberships());
        }
        if (status != null && status.getValue() != null && !status.getValue().isEmpty()) {
            StatusManagement.getInstance(this.conn.getConfiguration().getStatusManagementClass()).setStatus((Boolean)status.getValue().get(0), ldapAttrs, posixGroups, ldapGroups);
        }
        if (uidAttribute != null && !uidAttribute.isEmpty() && OBJECTGUID.equals(uidAttribute)) {
            this.adModifyAttributes(entryDN, adAttributesToModify, 2);
        } else {
            this.modifyAttributes(entryDN, attrToModify, 2);
        }
        String oldEntryDN = null;
        if (newName != null) {
            if (newPosixRefAttrs != null && this.conn.getConfiguration().isMaintainPosixGroupMembership() || posixGroups != null) {
                posixMember.getPosixRefAttributes();
            }
            oldEntryDN = entryDN;
            entryDN = this.conn.getSchemaMapping().rename(this.oclass, oldEntryDN, newName);
        }
        GroupHelper.Modification<GroupHelper.GroupMembership> ldapGroupMod = new GroupHelper.Modification<GroupHelper.GroupMembership>();
        if (oldEntryDN != null && this.conn.getConfiguration().isMaintainLdapGroupMembership()) {
            Set<GroupHelper.GroupMembership> members = this.groupHelper.getLdapGroupMemberships(oldEntryDN);
            ldapGroupMod.removeAll(members);
            for (GroupHelper.GroupMembership groupMembership : members) {
                ldapGroupMod.add(new GroupHelper.GroupMembership(entryDN, groupMembership.getGroupDN()));
            }
        }
        if (ldapGroups != null) {
            String groupSearchFilter = this.conn.getConfiguration().getGroupSearchFilter();
            Set<GroupHelper.GroupMembership> oldMembers = this.groupHelper.getLdapGroupMembershipsWithFilter(entryDN, groupSearchFilter);
            ldapGroupMod.removeAll(oldMembers);
            ldapGroupMod.clearAdded();
            for (String ldapGroup : ldapGroups) {
                ldapGroupMod.add(new GroupHelper.GroupMembership(entryDN, ldapGroup));
            }
        }
        this.groupHelper.modifyLdapGroupMemberships(ldapGroupMod);
        GroupHelper.Modification<GroupHelper.GroupMembership> posixGroupMod = new GroupHelper.Modification<GroupHelper.GroupMembership>();
        if (newPosixRefAttrs != null && this.conn.getConfiguration().isMaintainPosixGroupMembership()) {
            HashSet<String> removedPosixRefAttrs = new HashSet<String>(posixMember.getPosixRefAttributes());
            removedPosixRefAttrs.removeAll(newPosixRefAttrs);
            Set<GroupHelper.GroupMembership> set = posixMember.getPosixGroupMembershipsByAttrs(removedPosixRefAttrs);
            posixGroupMod.removeAll(set);
            if (!set.isEmpty()) {
                String firstPosixRefAttr = this.getFirstPosixRefAttr(entryDN, newPosixRefAttrs);
                for (GroupHelper.GroupMembership member : set) {
                    posixGroupMod.add(new GroupHelper.GroupMembership(firstPosixRefAttr, member.getGroupDN()));
                }
            }
        }
        if (posixGroups != null) {
            Set<GroupHelper.GroupMembership> members = posixMember.getPosixGroupMemberships();
            posixGroupMod.removeAll(members);
            posixGroupMod.clearAdded();
            if (!posixGroups.isEmpty()) {
                String string = this.getFirstPosixRefAttr(entryDN, newPosixRefAttrs);
                for (String posixGroup : posixGroups) {
                    posixGroupMod.add(new GroupHelper.GroupMembership(string, posixGroup));
                }
            }
        }
        this.groupHelper.modifyPosixGroupMemberships(posixGroupMod);
        return this.conn.getSchemaMapping().createUid(this.oclass, entryDN);
    }

    public Uid addAttributeValues(Set<Attribute> attrs) {
        List<String> posixGroups;
        String entryDN = LdapSearches.findEntryDN(this.conn, this.oclass, this.uid);
        LdapModifyOperation.PosixGroupMember posixMember = new LdapModifyOperation.PosixGroupMember(entryDN);
        Pair<Attributes, GuardedPasswordAttribute> attrsToModify = this.getAttributesToModify(attrs);
        this.modifyAttributes(entryDN, attrsToModify, 1);
        List<String> ldapGroups = this.getStringListValue(attrs, "ldapGroups");
        if (!CollectionUtil.isEmpty(ldapGroups)) {
            this.groupHelper.addLdapGroupMemberships(entryDN, ldapGroups);
        }
        if (!CollectionUtil.isEmpty(posixGroups = this.getStringListValue(attrs, "posixGroups"))) {
            Set<String> posixRefAttrs = posixMember.getPosixRefAttributes();
            String posixRefAttr = this.getFirstPosixRefAttr(entryDN, posixRefAttrs);
            this.groupHelper.addPosixGroupMemberships(posixRefAttr, posixGroups);
        }
        return this.uid;
    }

    public Uid removeAttributeValues(Set<Attribute> attrs) {
        List<String> posixGroups;
        String entryDN = LdapSearches.findEntryDN(this.conn, this.oclass, this.uid);
        LdapModifyOperation.PosixGroupMember posixMember = new LdapModifyOperation.PosixGroupMember(entryDN);
        Pair<Attributes, GuardedPasswordAttribute> attrsToModify = this.getAttributesToModify(attrs);
        Attributes ldapAttrs = (Attributes)attrsToModify.first;
        Set<String> removedPosixRefAttrs = LdapUpdate.getAttributeValues(GroupHelper.getPosixRefAttribute(), null, ldapAttrs);
        if (!CollectionUtil.isEmpty(removedPosixRefAttrs)) {
            this.checkRemovedPosixRefAttrs(removedPosixRefAttrs, posixMember.getPosixGroupMemberships());
        }
        this.modifyAttributes(entryDN, attrsToModify, 3);
        List<String> ldapGroups = this.getStringListValue(attrs, "ldapGroups");
        if (!CollectionUtil.isEmpty(ldapGroups)) {
            this.groupHelper.removeLdapGroupMemberships(entryDN, ldapGroups);
        }
        if (!CollectionUtil.isEmpty(posixGroups = this.getStringListValue(attrs, "posixGroups"))) {
            Set<GroupHelper.GroupMembership> members = posixMember.getPosixGroupMembershipsByGroups(posixGroups);
            this.groupHelper.removePosixGroupMemberships(members);
        }
        return this.uid;
    }

    private Pair<Attributes, ADGuardedPasswordAttribute> getAdAttributesToModify(Set<Attribute> attrs) {
        BasicAttributes ldapAttrs = new BasicAttributes();
        ADGuardedPasswordAttribute pwdAttr = null;
        String entryDN = LdapSearches.findEntryDN(this.conn, this.oclass, this.uid);
        Attributes attributes = null;
        int currentUACValue = 0;
        try {
            attributes = this.conn.getInitialContext().getAttributes(entryDN, new String[]{UACCONTROL_ATTR});
            if (ObjectUtils.isNotEmpty((Object)attributes.get(UACCONTROL_ATTR))) {
                currentUACValue = Integer.parseInt(attributes.get(UACCONTROL_ATTR).get().toString());
            }
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
        int newUACValue = -1;
        Boolean pne = null;
        Boolean status = null;
        for (Attribute attr : attrs) {
            javax.naming.directory.Attribute ldapAttr = null;
            if (attr.is(Uid.NAME)) {
                throw new InvalidAttributeValueException("ldap.attribute.unable.modify.uid.error");
            }
            if (attr.is(Name.NAME)) {
                throw new InvalidAttributeValueException("ldap.attribute.unable.modify.name.error");
            }
            if (attr.is("passwordNeverExpires")) {
                value = attr.getValue();
                if (value != null && !value.isEmpty()) {
                    pne = (Boolean)value.get(0);
                }
            } else if (attr.is("pwdLastSet")) {
                value = attr.getValue();
                if (value != null && !value.isEmpty()) {
                    Boolean enabled = (Boolean)value.get(0);
                    if (enabled.booleanValue()) {
                        ldapAttrs.put(new BasicAttribute("pwdLastSet", "0"));
                    } else {
                        ldapAttrs.put(new BasicAttribute("pwdLastSet", "-1"));
                    }
                }
            } else if (attr.is("lockoutTime")) {
                value = attr.getValue();
                if (value != null && !value.isEmpty() && ((Boolean)value.get(0)).booleanValue()) {
                    ldapAttrs.put(new BasicAttribute("lockoutTime", "0"));
                }
            } else if (!LdapConstants.isLdapGroups(attr.getName())) {
                if (attr.is(OperationalAttributes.PASSWORD_NAME)) {
                    pwdAttr = ADGuardedPasswordAttribute.create(this.conn.getConfiguration().getPasswordAttribute(), attr);
                } else if (attr.is(UACCONTROL_ATTR) && this.oclass.is(ObjectClass.ACCOUNT_NAME)) {
                    newUACValue = attr.getValue() == null || attr.getValue().isEmpty() ? -1 : Integer.parseInt(attr.getValue().get(0).toString());
                } else if (attr.is(OperationalAttributes.ENABLE_NAME) && this.oclass.is(ObjectClass.ACCOUNT_NAME)) {
                    status = attr.getValue() == null || attr.getValue().isEmpty() || Boolean.parseBoolean(attr.getValue().get(0).toString());
                } else if (!attr.is(OBJECTGUID)) {
                    if (attr.is(ManagerId.NAME)) {
                        if (attr.getValue() != null && !attr.getValue().isEmpty() && attr.getValue().get(0) != null) {
                            String managerId = attr.getValue().get(0).toString();
                            String manager = StringUtils.isEmpty((CharSequence)managerId) ? null : LdapSearches.getEntryDN(this.conn, ObjectClass.ACCOUNT, new Uid(managerId));
                            ldapAttr = new BasicAttribute("manager");
                            ldapAttr.add(manager);
                        }
                    } else {
                        ldapAttr = this.conn.getSchemaMapping().encodeAttribute(this.oclass, attr);
                    }
                }
            }
            this.addAttribute(ldapAttr, ldapAttrs);
        }
        if (this.oclass.is(ObjectClass.ACCOUNT_NAME)) {
            if (pne != null) {
                if ((currentUACValue & 0x10000) == 65536 && !pne.booleanValue()) {
                    newUACValue = currentUACValue - 65536;
                } else if ((currentUACValue & 0x10000) != 65536 && pne.booleanValue()) {
                    newUACValue = currentUACValue + 65536;
                }
            }
            if (status != null) {
                if ((currentUACValue & 2) == 2 && status.booleanValue()) {
                    newUACValue = currentUACValue - 2;
                } else if ((currentUACValue & 2) != 2 && !status.booleanValue()) {
                    newUACValue = currentUACValue + 2;
                }
            }
            if (newUACValue >= 0) {
                this.addAttribute(this.conn.getSchemaMapping().encodeAttribute(this.oclass, AttributeBuilder.build((String)UACCONTROL_ATTR, (Object[])new Object[]{Integer.toString(newUACValue)})), ldapAttrs);
            }
        }
        return new Pair((Object)ldapAttrs, pwdAttr);
    }

    private void addAttribute(javax.naming.directory.Attribute ldapAttr, BasicAttributes ldapAttrs) {
        if (ldapAttr != null) {
            javax.naming.directory.Attribute existingAttr = ldapAttrs.get(ldapAttr.getID());
            if (existingAttr != null) {
                try {
                    NamingEnumeration<?> all = ldapAttr.getAll();
                    while (all.hasMoreElements()) {
                        existingAttr.add(all.nextElement());
                    }
                }
                catch (NamingException e) {
                    throw new ConnectorException((Throwable)e);
                }
            } else {
                ldapAttrs.put(ldapAttr);
            }
        }
    }

    private void checkRemovedPosixRefAttrs(Set<String> removedPosixRefAttrs, Set<GroupHelper.GroupMembership> memberships) {
        for (GroupHelper.GroupMembership membership : memberships) {
            if (!removedPosixRefAttrs.contains(membership.getMemberRef())) continue;
            throw new InvalidAttributeValueException("ldap.cannotRemoveBecausePosixMember", new String[]{GroupHelper.getPosixRefAttribute()});
        }
    }

    private Pair<Attributes, GuardedPasswordAttribute> getAttributesToModify(Set<Attribute> attrs) {
        BasicAttributes ldapAttrs = new BasicAttributes();
        GuardedPasswordAttribute pwdAttr = null;
        Boolean status = null;
        int currentUACValue = 0;
        int newUACValue = -1;
        String uidAttribute = this.conn.getConfiguration().getUidAttribute();
        if (uidAttribute != null && !uidAttribute.isEmpty() && OBJECTGUID.equals(uidAttribute)) {
            LdapFilter adFilter = LdapFilter.forNativeFilter("(objectGUID=" + ADLdapUtil.guidDashedStringtoByteString(this.uid.getSingleValue()) + ")");
            ConnectorObject object = LdapSearches.findObject(this.conn, this.oclass, adFilter, UACCONTROL_ATTR);
            Attribute uac = object.getAttributeByName(UACCONTROL_ATTR);
            currentUACValue = uac == null || uac.getValue() == null || uac.getValue().isEmpty() ? 0 : Integer.parseInt(uac.getValue().get(0).toString());
        }
        for (Attribute attr : attrs) {
            javax.naming.directory.Attribute ldapAttr = null;
            if (attr.is(Uid.NAME)) {
                throw new InvalidAttributeValueException("ldap.attribute.unable.modify.uid.error");
            }
            if (attr.is(Name.NAME)) {
                throw new InvalidAttributeValueException("ldap.attribute.unable.modify.name.error");
            }
            if (!LdapConstants.isLdapGroups(attr.getName()) && !LdapConstants.isPosixGroups(attr.getName())) {
                if (attr.is(OperationalAttributes.PASSWORD_NAME)) {
                    pwdAttr = this.conn.getSchemaMapping().encodePassword(this.oclass, attr);
                } else if (OBJECTGUID.equals(uidAttribute) && attr.is(OperationalAttributes.ENABLE_NAME) && this.oclass.is(ObjectClass.ACCOUNT_NAME)) {
                    status = attr.getValue() == null || attr.getValue().isEmpty() || Boolean.parseBoolean(attr.getValue().get(0).toString());
                    if (status != null) {
                        if ((currentUACValue & 2) == 2 && status.booleanValue()) {
                            newUACValue = currentUACValue - 2;
                        } else if ((currentUACValue & 2) != 2 && !status.booleanValue()) {
                            newUACValue = currentUACValue + 2;
                        }
                    }
                    if (newUACValue >= 0) {
                        ldapAttr = this.conn.getSchemaMapping().encodeAttribute(this.oclass, AttributeBuilder.build((String)UACCONTROL_ATTR, (Object[])new Object[]{Integer.toString(newUACValue)}));
                    }
                } else if (attr.is(ManagerId.NAME)) {
                    if (attr.getValue() != null && !attr.getValue().isEmpty() && attr.getValue().get(0) != null) {
                        String managerId = attr.getValue().get(0).toString();
                        String manager = StringUtils.isEmpty((CharSequence)managerId) ? null : LdapSearches.getEntryDN(this.conn, ObjectClass.ACCOUNT, new Uid(managerId));
                        ldapAttr = new BasicAttribute("manager");
                        ldapAttr.add(manager);
                    }
                } else {
                    ldapAttr = this.conn.getSchemaMapping().encodeAttribute(this.oclass, attr);
                }
            }
            if (ldapAttr == null) continue;
            javax.naming.directory.Attribute existingAttr = ldapAttrs.get(ldapAttr.getID());
            if (existingAttr != null) {
                try {
                    NamingEnumeration<?> all = ldapAttr.getAll();
                    while (all.hasMoreElements()) {
                        existingAttr.add(all.nextElement());
                    }
                    continue;
                }
                catch (NamingException e) {
                    throw new ConnectorException((Throwable)e);
                }
            }
            ldapAttrs.put(ldapAttr);
        }
        return new Pair((Object)ldapAttrs, pwdAttr);
    }

    private void modifyAttributes(final String entryDN, Pair<Attributes, GuardedPasswordAttribute> attrs, final int ldapModifyOp) {
        final ArrayList<ModificationItem> modItems = new ArrayList<ModificationItem>(((Attributes)attrs.first).size());
        NamingEnumeration<? extends javax.naming.directory.Attribute> attrEnum = ((Attributes)attrs.first).getAll();
        while (attrEnum.hasMoreElements()) {
            modItems.add(new ModificationItem(ldapModifyOp, (javax.naming.directory.Attribute)attrEnum.nextElement()));
        }
        if (attrs.second != null) {
            ((GuardedPasswordAttribute)attrs.second).access(new GuardedPasswordAttribute.Accessor(){

                @Override
                public void access(javax.naming.directory.Attribute passwordAttr) {
                    LdapUpdate.this.hashPassword(passwordAttr, entryDN);
                    modItems.add(new ModificationItem(ldapModifyOp, passwordAttr));
                    LdapUpdate.this.modifyAttributes(entryDN, modItems);
                }
            });
        } else {
            this.modifyAttributes(entryDN, modItems);
        }
    }

    private void adModifyAttributes(final String entryDN, Pair<Attributes, ADGuardedPasswordAttribute> attrs, final int ldapModifyOp) {
        final ArrayList<ModificationItem> modItems = new ArrayList<ModificationItem>(((Attributes)attrs.first).size());
        NamingEnumeration<? extends javax.naming.directory.Attribute> attrEnum = ((Attributes)attrs.first).getAll();
        while (attrEnum.hasMoreElements()) {
            modItems.add(new ModificationItem(ldapModifyOp, (javax.naming.directory.Attribute)attrEnum.nextElement()));
        }
        if (attrs.second != null) {
            ((ADGuardedPasswordAttribute)attrs.second).access(new ADGuardedPasswordAttribute.Accessor(){

                @Override
                public void access(BasicAttribute passwordAttr) {
                    LdapUpdate.this.hashPassword(passwordAttr, entryDN);
                    modItems.add(new ModificationItem(ldapModifyOp, passwordAttr));
                    LdapUpdate.this.modifyAttributes(entryDN, modItems);
                }
            });
        } else {
            this.modifyAttributes(entryDN, modItems);
        }
    }

    private void modifyAttributes(String entryDN, List<ModificationItem> modItems) {
        try {
            this.conn.getInitialContext().modifyAttributes(entryDN, modItems.toArray(new ModificationItem[modItems.size()]));
        }
        catch (NamingException e) {
            throw LdapUtil.buildConnectorException(e);
        }
    }

    private List<String> getStringListValue(Set<Attribute> attrs, String attrName) {
        Attribute attr = AttributeUtil.find((String)attrName, attrs);
        return attr == null ? null : LdapUtil.checkedListByFilter(CollectionUtil.nullAsEmpty((List)attr.getValue()), String.class);
    }
}

