/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.ldap.schema;

import com.bamboocloud.icf.common.CollectionUtil;
import com.bamboocloud.icf.common.StringUtil;
import com.bamboocloud.icf.common.logging.Log;
import com.bamboocloud.icf.common.security.GuardedString;
import com.bamboocloud.icf.connector.ldap.LdapConnection;
import com.bamboocloud.icf.connector.ldap.commons.LdapEntry;
import com.bamboocloud.icf.connector.ldap.commons.LdapUtil;
import com.bamboocloud.icf.connector.ldap.commons.ObjectClassMappingConfig;
import com.bamboocloud.icf.connector.ldap.schema.GuardedPasswordAttribute;
import com.bamboocloud.icf.connector.ldap.schema.LdapSchemaBuilder;
import com.bamboocloud.icf.framework.common.exceptions.ConfigurationException;
import com.bamboocloud.icf.framework.common.exceptions.InvalidAttributeValueException;
import com.bamboocloud.icf.framework.common.exceptions.ObjectNotExistsException;
import com.bamboocloud.icf.framework.common.objects.Attribute;
import com.bamboocloud.icf.framework.common.objects.AttributeBuilder;
import com.bamboocloud.icf.framework.common.objects.AttributeInfo;
import com.bamboocloud.icf.framework.common.objects.AttributeUtil;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import com.bamboocloud.icf.framework.common.objects.ObjectClassInfo;
import com.bamboocloud.icf.framework.common.objects.ObjectClassUtil;
import com.bamboocloud.icf.framework.common.objects.OperationalAttributes;
import com.bamboocloud.icf.framework.common.objects.Schema;
import com.bamboocloud.icf.framework.common.objects.attributes.Name;
import com.bamboocloud.icf.framework.common.objects.attributes.Uid;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;

public class LdapSchemaMapping {
    private static final Log LOG = Log.getLog(LdapSchemaMapping.class);
    public static final ObjectClass ANY_OBJECT_CLASS = new ObjectClass(ObjectClassUtil.createSpecialName((String)"ANY"));
    static final String DEFAULT_LDAP_NAME_ATTR = "entryDN";
    private final LdapConnection conn;
    private final Map<String, Set<String>> ldapClass2Effective = CollectionUtil.newCaseInsensitiveMap();
    private Schema schema;

    public LdapSchemaMapping(LdapConnection conn) {
        this.conn = conn;
    }

    public Schema schema() {
        if (this.schema == null) {
            this.schema = new LdapSchemaBuilder(this.conn).getSchema();
        }
        return this.schema;
    }

    private Set<String> getEffectiveLdapClasses(String ldapClass) {
        Set<String> result = this.ldapClass2Effective.get(ldapClass);
        if (result == null) {
            result = this.conn.createNativeSchema().getEffectiveObjectClasses(ldapClass);
            this.ldapClass2Effective.put(ldapClass, result);
        }
        return result;
    }

    public List<String> getLdapClasses(ObjectClass oclass) {
        if (oclass.equals((Object)ANY_OBJECT_CLASS)) {
            return Collections.emptyList();
        }
        ObjectClassMappingConfig oclassConfig = this.conn.getConfiguration().getObjectClassMappingConfigs().get(oclass);
        if (oclassConfig != null) {
            return oclassConfig.getLdapClasses();
        }
        if (!ObjectClassUtil.isSpecial((ObjectClass)oclass)) {
            return CollectionUtil.newReadOnlyList((Object[])new String[]{oclass.getObjectClassValue()});
        }
        throw new ConfigurationException("ldap.object.class.mapped.error", new String[]{oclass.getObjectClassValue()});
    }

    public Set<String> getEffectiveLdapClasses(ObjectClass oclass) {
        SortedSet result = CollectionUtil.newCaseInsensitiveSet();
        for (String ldapClass : this.getLdapClasses(oclass)) {
            result.addAll(this.getEffectiveLdapClasses(ldapClass));
        }
        return Collections.unmodifiableSet(result);
    }

    public List<String> getUserNameLdapAttributes(ObjectClass oclass) {
        ObjectClassMappingConfig oclassConfig = this.conn.getConfiguration().getObjectClassMappingConfigs().get(oclass);
        return oclassConfig == null ? Collections.emptyList() : oclassConfig.getShortNameLdapAttributes();
    }

    public String getLdapAttribute(ObjectClass oclass, String attrName, boolean transfer) {
        String result = null;
        if (AttributeUtil.namesEqual((String)Uid.NAME, (String)attrName)) {
            result = this.getLdapUidAttribute(oclass);
        } else if (AttributeUtil.namesEqual((String)Name.NAME, (String)attrName)) {
            result = this.getLdapNameAttribute(oclass);
        } else if (OperationalAttributes.PASSWORD_NAME.equals(attrName)) {
            result = this.getLdapPasswordAttribute(oclass);
        }
        if (result == null && !AttributeUtil.isSpecialName((String)attrName)) {
            result = attrName;
        }
        if (result != null && transfer && this.conn.needsBinaryOption(result)) {
            result = LdapUtil.addBinaryOption(result);
        }
        if (result == null && !oclass.equals((Object)ANY_OBJECT_CLASS)) {
            LOG.warn("Attribute {0} of object class {1} is not mapped to an LDAP attribute", new Object[]{attrName, oclass.getObjectClassValue()});
        }
        return result;
    }

    public String getLdapAttribute(ObjectClass oclass, Attribute attr) {
        return this.getLdapAttribute(oclass, attr.getName(), false);
    }

    public Set<String> getLdapAttributes(ObjectClass oclass, Set<String> attrs, boolean transfer) {
        SortedSet result = CollectionUtil.newCaseInsensitiveSet();
        for (String attr : attrs) {
            String ldapAttr = this.getLdapAttribute(oclass, attr, transfer);
            if (ldapAttr == null) continue;
            result.add(ldapAttr);
        }
        return result;
    }

    public String getLdapUidAttribute(ObjectClass oclass) {
        String idAttribute;
        if (oclass.equals((Object)ObjectClass.GROUP)) {
            ObjectClass clazz = oclass;
            idAttribute = this.conn.getConfiguration().getGidAttribute();
        } else if (oclass.equals((Object)ObjectClass.ACCOUNT)) {
            ObjectClass clazz = oclass;
            idAttribute = this.conn.getConfiguration().getUidAttribute();
        } else if (oclass.equals((Object)ObjectClass.ORGANIZATION)) {
            ObjectClass clazz = oclass;
            idAttribute = this.conn.getConfiguration().getUidAttribute();
        } else {
            ObjectClass clazz = ObjectClass.ALL;
            idAttribute = null;
        }
        return StringUtil.isBlank((String)idAttribute) ? this.conn.getConfiguration().getUidAttribute() : idAttribute;
    }

    public String getLdapPasswordAttribute(ObjectClass oclass) {
        return this.conn.getConfiguration().getPasswordAttribute();
    }

    public String getLdapNameAttribute(ObjectClass oclass) {
        return DEFAULT_LDAP_NAME_ATTR;
    }

    public Uid createUid(ObjectClass oclass, LdapEntry entry) {
        return this.createUid(this.getLdapUidAttribute(oclass), entry.getAttributes());
    }

    public Uid createUid(ObjectClass oclass, String entryDN) {
        String ldapUidAttr = this.getLdapUidAttribute(oclass);
        if (LdapEntry.isDNAttribute(ldapUidAttr)) {
            return new Uid(entryDN);
        }
        try {
            Attributes attributes = this.conn.getInitialContext().getAttributes(entryDN, new String[]{ldapUidAttr});
            return this.createUid(ldapUidAttr, attributes);
        }
        catch (NamingException e) {
            throw LdapUtil.buildConnectorException(e);
        }
    }

    private Uid createUid(String ldapUidAttr, Attributes attributes) {
        String value = LdapUtil.getStringAttrValue(attributes, ldapUidAttr);
        if (value != null) {
            return new Uid(value);
        }
        throw new ObjectNotExistsException("ldap.search.attribute.result.error", new String[]{ldapUidAttr});
    }

    public Name createName(ObjectClass oclass, LdapEntry entry) {
        String ldapNameAttr = this.getLdapNameAttribute(oclass);
        if (!LdapEntry.isDNAttribute(ldapNameAttr)) {
            throw new InvalidAttributeValueException("ldap.mapped.dn.error");
        }
        return new Name(entry.getDN().toString());
    }

    public Attribute createAttribute(ObjectClass oclass, String attrName, LdapEntry entry, boolean emptyWhenNotFound) {
        String ldapAttrNameForTransfer = this.getLdapAttribute(oclass, attrName, true);
        javax.naming.directory.Attribute ldapAttr = null;
        if (ldapAttrNameForTransfer != null) {
            ldapAttr = entry.getAttributes().get(ldapAttrNameForTransfer);
        }
        if (ldapAttr == null) {
            return emptyWhenNotFound ? AttributeBuilder.build((String)attrName, Collections.emptyList()) : null;
        }
        AttributeBuilder builder = new AttributeBuilder();
        builder.setName(attrName);
        try {
            if (OperationalAttributes.PASSWORD_NAME.equals(attrName)) {
                String password = new String((byte[])ldapAttr.get());
                builder.addValue(new Object[]{new GuardedString(password.toCharArray())});
            } else {
                NamingEnumeration<?> valEnum = ldapAttr.getAll();
                while (valEnum.hasMore()) {
                    builder.addValue(new Object[]{valEnum.next()});
                }
            }
        }
        catch (NamingException e) {
            throw LdapUtil.buildConnectorException(e);
        }
        return builder.build();
    }

    public String create(ObjectClass oclass, Name name, Attributes initialAttrs) {
        LdapName entryName = LdapUtil.quietCreateLdapName(this.getEntryDN(oclass, name));
        BasicAttributes ldapAttrs = new BasicAttributes();
        NamingEnumeration<? extends javax.naming.directory.Attribute> initialAttrEnum = initialAttrs.getAll();
        while (initialAttrEnum.hasMoreElements()) {
            ldapAttrs.put((javax.naming.directory.Attribute)initialAttrEnum.nextElement());
        }
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        for (String ldapClass : this.conn.getSchemaMapping().getEffectiveLdapClasses(oclass)) {
            objectClass.add(ldapClass);
        }
        ldapAttrs.put(objectClass);
        LOG.ok("Creating LDAP subcontext {0} with attributes {1}", new Object[]{entryName, ldapAttrs});
        try {
            this.conn.getInitialContext().createSubcontext(entryName, (Attributes)ldapAttrs).close();
            return entryName.toString();
        }
        catch (NamingException e) {
            throw LdapUtil.buildConnectorException(e);
        }
    }

    public javax.naming.directory.Attribute encodeAttribute(ObjectClass oclass, Attribute attr) {
        if (attr.is(OperationalAttributes.PASSWORD_NAME)) {
            throw new InvalidAttributeValueException("ldap.attribute.validate.not.password.error");
        }
        String ldapAttrName = this.getLdapAttribute(oclass, attr.getName(), true);
        if (ldapAttrName == null) {
            return null;
        }
        BasicAttribute ldapAttr = new BasicAttribute(ldapAttrName);
        List value = attr.getValue();
        if (value != null) {
            for (Object each : value) {
                if (StringUtil.isBlank((String)((String)each))) {
                    ldapAttr.add(null);
                    continue;
                }
                ldapAttr.add(each);
            }
        }
        return ldapAttr;
    }

    public GuardedPasswordAttribute encodePassword(ObjectClass oclass, Attribute attr) {
        assert (attr.is(OperationalAttributes.PASSWORD_NAME));
        String pwdAttrName = this.conn.getConfiguration().getPasswordAttribute();
        List value = attr.getValue();
        if (value != null && !value.isEmpty()) {
            return GuardedPasswordAttribute.create(pwdAttrName, (GuardedString)value.get(0));
        }
        return GuardedPasswordAttribute.create(pwdAttrName);
    }

    public String getEntryDN(ObjectClass oclass, Name name) {
        String ldapNameAttr = this.getLdapNameAttribute(oclass);
        if (!LdapEntry.isDNAttribute(ldapNameAttr)) {
            throw new InvalidAttributeValueException("ldap.mapped.dn.error");
        }
        return name.getSingleValue();
    }

    public String rename(ObjectClass oclass, String entryDN, Name newName) {
        String newEntryDN = this.getEntryDN(oclass, newName);
        try {
            this.conn.getInitialContext().rename(entryDN, newEntryDN);
            return newEntryDN;
        }
        catch (NamingException e) {
            throw LdapUtil.buildConnectorException(e);
        }
    }

    public void removeNonReadableAttributes(ObjectClass oclass, Set<String> attrNames) {
        ObjectClassInfo oci = this.schema().findObjectClassInfo(oclass.getObjectClassValue());
        if (oci == null) {
            return;
        }
        SortedSet attrs = CollectionUtil.newCaseInsensitiveSet();
        SortedSet readableAttrs = CollectionUtil.newCaseInsensitiveSet();
        for (AttributeInfo info : oci.getAttributeInfo()) {
            String attrName = info.getName();
            attrs.add(attrName);
            if (!info.isReadable()) continue;
            readableAttrs.add(attrName);
        }
        Iterator<String> i = attrNames.iterator();
        while (i.hasNext()) {
            String attrName = i.next();
            if (!attrs.contains(attrName) || readableAttrs.contains(attrName)) continue;
            i.remove();
        }
    }
}

