/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.ldap.search;

import com.bamboocloud.icf.connector.ldap.commons.LdapEntry;
import com.bamboocloud.icf.connector.ldap.commons.LdapUtil;
import com.bamboocloud.icf.connector.ldap.schema.LdapSchemaMapping;
import com.bamboocloud.icf.connector.ldap.search.LdapFilter;
import com.bamboocloud.icf.framework.common.objects.Attribute;
import com.bamboocloud.icf.framework.common.objects.AttributeBuilder;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import com.bamboocloud.icf.framework.common.objects.filter.AbstractFilterTranslator;
import com.bamboocloud.icf.framework.common.objects.filter.AttributeFilter;
import com.bamboocloud.icf.framework.common.objects.filter.ContainsAllValuesFilter;
import com.bamboocloud.icf.framework.common.objects.filter.ContainsFilter;
import com.bamboocloud.icf.framework.common.objects.filter.EndsWithFilter;
import com.bamboocloud.icf.framework.common.objects.filter.EqualsFilter;
import com.bamboocloud.icf.framework.common.objects.filter.EqualsIgnoreCaseFilter;
import com.bamboocloud.icf.framework.common.objects.filter.GreaterThanFilter;
import com.bamboocloud.icf.framework.common.objects.filter.GreaterThanOrEqualFilter;
import com.bamboocloud.icf.framework.common.objects.filter.LessThanFilter;
import com.bamboocloud.icf.framework.common.objects.filter.LessThanOrEqualFilter;
import com.bamboocloud.icf.framework.common.objects.filter.SingleValueAttributeFilter;
import com.bamboocloud.icf.framework.common.objects.filter.StartsWithFilter;
import java.util.List;

public class LdapFilterTranslator
extends AbstractFilterTranslator<LdapFilter> {
    private final LdapSchemaMapping mapping;
    private final ObjectClass objectClass;

    public LdapFilterTranslator(LdapSchemaMapping mapping, ObjectClass objectClass) {
        this.mapping = mapping;
        this.objectClass = objectClass;
    }

    public LdapFilter createAndExpression(LdapFilter leftExpression, LdapFilter rightExpression) {
        return leftExpression.and(rightExpression);
    }

    public LdapFilter createOrExpression(LdapFilter leftExpression, LdapFilter rightExpression) {
        return leftExpression.or(rightExpression);
    }

    public LdapFilter createContainsExpression(ContainsFilter filter, boolean not) {
        String attrName = this.mapping.getLdapAttribute(this.objectClass, filter.getAttribute());
        if (attrName == null) {
            return null;
        }
        if (LdapEntry.isDNAttribute(attrName)) {
            return LdapFilter.forEntryDN(filter.getValue());
        }
        StringBuilder builder = this.createBuilder(not);
        builder.append(attrName);
        builder.append('=');
        builder.append('*');
        if (LdapUtil.escapeAttrValue(filter.getValue(), builder)) {
            builder.append('*');
        }
        return this.finishBuilder(builder);
    }

    public LdapFilter createEndsWithExpression(EndsWithFilter filter, boolean not) {
        String attrName = this.mapping.getLdapAttribute(this.objectClass, filter.getAttribute());
        if (attrName == null) {
            return null;
        }
        if (LdapEntry.isDNAttribute(attrName)) {
            return LdapFilter.forEntryDN(filter.getValue());
        }
        StringBuilder builder = this.createBuilder(not);
        builder.append(attrName);
        builder.append('=');
        builder.append('*');
        LdapUtil.escapeAttrValue(filter.getValue(), builder);
        return this.finishBuilder(builder);
    }

    public LdapFilter createEqualsExpression(EqualsFilter filter, boolean not) {
        return this.createContainsAllValuesFilter((AttributeFilter)filter, not);
    }

    protected LdapFilter createEqualsIgnoreCaseExpression(EqualsIgnoreCaseFilter filter, boolean not) {
        Attribute attr = filter.getValue() == null ? AttributeBuilder.build((String)filter.getName()) : AttributeBuilder.build((String)filter.getName(), (Object[])new Object[]{filter.getValue()});
        return this.createEqualsExpression(new EqualsFilter(attr), not);
    }

    public LdapFilter createGreaterThanExpression(GreaterThanFilter filter, boolean not) {
        return this.createSingleValueFilter("<=", (SingleValueAttributeFilter)filter, !not);
    }

    public LdapFilter createGreaterThanOrEqualExpression(GreaterThanOrEqualFilter filter, boolean not) {
        return this.createSingleValueFilter(">=", (SingleValueAttributeFilter)filter, not);
    }

    public LdapFilter createLessThanExpression(LessThanFilter filter, boolean not) {
        return this.createSingleValueFilter(">=", (SingleValueAttributeFilter)filter, !not);
    }

    public LdapFilter createLessThanOrEqualExpression(LessThanOrEqualFilter filter, boolean not) {
        return this.createSingleValueFilter("<=", (SingleValueAttributeFilter)filter, not);
    }

    public LdapFilter createStartsWithExpression(StartsWithFilter filter, boolean not) {
        String attrName = this.mapping.getLdapAttribute(this.objectClass, filter.getAttribute());
        if (attrName == null) {
            return null;
        }
        if (LdapEntry.isDNAttribute(attrName)) {
            return LdapFilter.forEntryDN(filter.getValue());
        }
        StringBuilder builder = this.createBuilder(not);
        builder.append(attrName);
        builder.append('=');
        LdapUtil.escapeAttrValue(filter.getValue(), builder);
        builder.append('*');
        return this.finishBuilder(builder);
    }

    public LdapFilter createContainsAllValuesExpression(ContainsAllValuesFilter filter, boolean not) {
        return this.createContainsAllValuesFilter((AttributeFilter)filter, not);
    }

    private LdapFilter createSingleValueFilter(String type, SingleValueAttributeFilter filter, boolean not) {
        String attrName = this.mapping.getLdapAttribute(this.objectClass, filter.getAttribute());
        if (attrName == null) {
            return null;
        }
        if (LdapEntry.isDNAttribute(attrName)) {
            return LdapFilter.forEntryDN(filter.getValue().toString());
        }
        StringBuilder builder = this.createBuilder(not);
        Object value = filter.getValue();
        this.addSimpleFilter(attrName, type, value, builder);
        return this.finishBuilder(builder);
    }

    private void addSimpleFilter(String ldapAttr, String type, Object value, StringBuilder toBuilder) {
        toBuilder.append(ldapAttr);
        toBuilder.append(type);
        if (!LdapUtil.escapeAttrValue(value, toBuilder)) {
            toBuilder.append('*');
        }
    }

    private LdapFilter createContainsAllValuesFilter(AttributeFilter filter, boolean not) {
        String attrName = this.mapping.getLdapAttribute(this.objectClass, filter.getAttribute());
        if (attrName == null) {
            return null;
        }
        List values = filter.getAttribute().getValue();
        if (values == null) {
            return null;
        }
        switch (values.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Object single = values.get(0);
                if (single == null) {
                    return null;
                }
                if (LdapEntry.isDNAttribute(attrName)) {
                    return LdapFilter.forEntryDN(single.toString());
                }
                StringBuilder builder = this.createBuilder(not);
                this.addSimpleFilter(attrName, "=", values.get(0), builder);
                return this.finishBuilder(builder);
            }
        }
        if (LdapEntry.isDNAttribute(attrName)) {
            return null;
        }
        StringBuilder builder = this.createBuilder(not);
        boolean hasValue = false;
        builder.append('&');
        for (Object value : values) {
            if (value == null) continue;
            hasValue = true;
            builder.append('(');
            this.addSimpleFilter(attrName, "=", value, builder);
            builder.append(')');
        }
        if (!hasValue) {
            return null;
        }
        return this.finishBuilder(builder);
    }

    private StringBuilder createBuilder(boolean not) {
        return new StringBuilder(not ? "(!(" : "(");
    }

    private LdapFilter finishBuilder(StringBuilder builder) {
        boolean not = builder.charAt(0) == '(' && builder.charAt(1) == '!';
        builder.append(not ? "))" : ")");
        return LdapFilter.forNativeFilter(builder.toString());
    }
}

