/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.ldap.search;

import com.bamboocloud.icf.common.CollectionUtil;
import com.bamboocloud.icf.common.StringUtil;
import com.bamboocloud.icf.common.logging.Log;
import com.bamboocloud.icf.common.security.GuardedString;
import com.bamboocloud.icf.connector.ldap.LdapConnection;
import com.bamboocloud.icf.connector.ldap.commons.ADLdapUtil;
import com.bamboocloud.icf.connector.ldap.commons.GroupHelper;
import com.bamboocloud.icf.connector.ldap.commons.LdapConstants;
import com.bamboocloud.icf.connector.ldap.commons.LdapEntry;
import com.bamboocloud.icf.connector.ldap.commons.LdapUtil;
import com.bamboocloud.icf.connector.ldap.commons.StatusManagement;
import com.bamboocloud.icf.connector.ldap.schema.LdapSchemaMapping;
import com.bamboocloud.icf.connector.ldap.search.LdapFilter;
import com.bamboocloud.icf.connector.ldap.search.LdapInternalSearch;
import com.bamboocloud.icf.connector.ldap.search.LdapSearchResultsHandler;
import com.bamboocloud.icf.connector.ldap.search.LdapSearchStrategy;
import com.bamboocloud.icf.connector.ldap.search.LdapSearches;
import com.bamboocloud.icf.connector.ldap.search.PagedSearchStrategy;
import com.bamboocloud.icf.connector.ldap.search.VlvIndexSearchStrategy;
import com.bamboocloud.icf.framework.common.exceptions.InvalidAttributeValueException;
import com.bamboocloud.icf.framework.common.exceptions.PermissionDeniedException;
import com.bamboocloud.icf.framework.common.objects.Attribute;
import com.bamboocloud.icf.framework.common.objects.AttributeBuilder;
import com.bamboocloud.icf.framework.common.objects.AttributeInfo;
import com.bamboocloud.icf.framework.common.objects.ConnectorObject;
import com.bamboocloud.icf.framework.common.objects.ConnectorObjectBuilder;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import com.bamboocloud.icf.framework.common.objects.ObjectClassInfo;
import com.bamboocloud.icf.framework.common.objects.OperationOptions;
import com.bamboocloud.icf.framework.common.objects.OperationalAttributes;
import com.bamboocloud.icf.framework.common.objects.QualifiedUid;
import com.bamboocloud.icf.framework.common.objects.ResultsHandler;
import com.bamboocloud.icf.framework.common.objects.attributes.GroupMemberOf;
import com.bamboocloud.icf.framework.common.objects.attributes.ManagerId;
import com.bamboocloud.icf.framework.common.objects.attributes.Name;
import com.bamboocloud.icf.framework.common.objects.attributes.Uid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang3.StringUtils;

public class LdapSearch {
    private static final Log LOG = Log.getLog(LdapSearch.class);
    private static final String USER_NAME = "username";
    private static final String LDAP_NAME = "name";
    private static final String LDAP_CN = "cn";
    private static final String LDAP_OU = "ou";
    private final LdapConnection conn;
    private final ObjectClass oclass;
    private final LdapFilter filter;
    private final OperationOptions options;
    private final GroupHelper groupHelper;
    private final String[] baseDNs;
    private final ResultsHandler handler;

    public static Set<String> getAttributesReturnedByDefault(LdapConnection conn, ObjectClass oclass) {
        if (oclass.equals((Object)LdapSchemaMapping.ANY_OBJECT_CLASS)) {
            return CollectionUtil.newSet((Object[])new String[]{Name.NAME});
        }
        SortedSet result = CollectionUtil.newCaseInsensitiveSet();
        ObjectClassInfo oci = conn.getSchemaMapping().schema().findObjectClassInfo(oclass.getObjectClassValue());
        if (oci != null) {
            for (AttributeInfo info : oci.getAttributeInfo()) {
                if (!info.isReturnedByDefault()) continue;
                result.add(info.getName());
            }
        }
        return result;
    }

    public LdapSearch(LdapConnection conn, ObjectClass oclass, LdapFilter filter, ResultsHandler handler, OperationOptions options) {
        this(conn, oclass, filter, handler, options, conn.getConfiguration().getBaseContexts());
    }

    public LdapSearch(LdapConnection conn, ObjectClass oclass, LdapFilter filter, ResultsHandler handler, OperationOptions options, String ... baseDNs) {
        this.conn = conn;
        this.oclass = oclass;
        this.filter = filter;
        this.options = options;
        this.baseDNs = baseDNs;
        this.groupHelper = new GroupHelper(conn);
        this.handler = handler;
    }

    public final void execute() {
        final String[] attrsToGetOption = this.options.getAttributesToGet();
        final Set<String> attrsToGet = this.getAttributesToGet(attrsToGetOption);
        LdapInternalSearch search = this.getInternalSearch(attrsToGet);
        search.execute(new LdapSearchResultsHandler(){

            @Override
            public boolean handle(String baseDN, SearchResult result) throws NamingException {
                return LdapSearch.this.handler.handle(LdapSearch.this.createConnectorObject(baseDN, result, attrsToGet, attrsToGetOption != null));
            }
        });
    }

    public final ConnectorObject getSingleResult() {
        final String[] attrsToGetOption = this.options.getAttributesToGet();
        final Set<String> attrsToGet = this.getAttributesToGet(attrsToGetOption);
        final ConnectorObject[] results = new ConnectorObject[]{null};
        LdapInternalSearch search = this.getInternalSearch(attrsToGet);
        search.execute(new LdapSearchResultsHandler(){

            @Override
            public boolean handle(String baseDN, SearchResult result) throws NamingException {
                results[0] = LdapSearch.this.createConnectorObject(baseDN, result, attrsToGet, attrsToGetOption != null);
                return false;
            }
        });
        return results[0];
    }

    private LdapInternalSearch getInternalSearch(Set<String> attrsToGet) {
        int searchScope;
        LdapSearchStrategy strategy;
        String filterEntryDN;
        List<Object> dns = new ArrayList<String>();
        String string = filterEntryDN = this.filter == null ? null : this.filter.getEntryDN();
        if (filterEntryDN == null) {
            String[] groupBaseContexts;
            strategy = this.getSearchStrategy();
            List<String> baseDNs = this.getBaseDNs();
            dns.addAll(baseDNs);
            if (this.oclass.equals((Object)ObjectClass.GROUP) && (groupBaseContexts = this.conn.getConfiguration().getGroupBaseContexts()) != null && groupBaseContexts.length > 0) {
                List<String> groupDNs = Arrays.asList(groupBaseContexts);
                dns.removeAll(baseDNs);
                dns.addAll(groupDNs);
            }
            searchScope = this.getLdapSearchScope();
        } else {
            strategy = this.conn.getConfiguration().newDefaultSearchStrategy(true);
            dns = Collections.singletonList(filterEntryDN);
            searchScope = 0;
        }
        SearchControls controls = LdapInternalSearch.createDefaultSearchControls();
        Set<String> ldapAttrsToGet = this.getLdapAttributesToGet(attrsToGet);
        controls.setReturningAttributes(ldapAttrsToGet.toArray(new String[ldapAttrsToGet.size()]));
        controls.setSearchScope(searchScope);
        String optionsFilter = LdapConstants.getSearchFilter(this.options);
        String searchFilter = null;
        if (this.oclass.equals((Object)ObjectClass.ACCOUNT)) {
            searchFilter = this.conn.getConfiguration().getAccountSearchFilter();
        } else if (this.oclass.equals((Object)ObjectClass.GROUP)) {
            searchFilter = this.conn.getConfiguration().getGroupSearchFilter();
        }
        String nativeFilter = this.filter == null ? null : this.filter.getNativeFilter();
        return new LdapInternalSearch(this.conn, this.getSearchFilter(optionsFilter, nativeFilter, searchFilter), dns, strategy, controls);
    }

    private Set<String> getLdapAttributesToGet(Set<String> attrsToGet) {
        SortedSet cleanAttrsToGet = CollectionUtil.newCaseInsensitiveSet();
        cleanAttrsToGet.addAll(attrsToGet);
        cleanAttrsToGet.remove("ldapGroups");
        boolean posixGroups = cleanAttrsToGet.remove("posixGroups");
        Set<String> result = this.conn.getSchemaMapping().getLdapAttributes(this.oclass, cleanAttrsToGet, true);
        if (posixGroups) {
            result.add(GroupHelper.getPosixRefAttribute());
        }
        result.addAll(StatusManagement.getInstance(this.conn.getConfiguration().getStatusManagementClass()).getOperationalAttributes());
        result.removeAll(LdapEntry.ENTRY_DN_ATTRS);
        return result;
    }

    private ConnectorObject createConnectorObject(String baseDN, SearchResult result, Set<String> attrsToGet, boolean emptyAttrWhenNotFound) {
        LdapEntry entry = LdapEntry.create(baseDN, result);
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(this.oclass);
        if ("objectGUID".equalsIgnoreCase(this.conn.getSchemaMapping().getLdapUidAttribute(this.oclass))) {
            builder.setUid(ADLdapUtil.objectGUIDtoDashedString(entry.getAttributes().get("objectGUID")));
        } else {
            builder.setUid(this.conn.getSchemaMapping().createUid(this.oclass, entry));
        }
        builder.setName(this.conn.getSchemaMapping().createName(this.oclass, entry));
        ArrayList<String> ldapGroups = new ArrayList<String>();
        ArrayList<String> posixGroups = new ArrayList<String>();
        for (String attrName : attrsToGet) {
            Attribute attribute = null;
            if (LdapConstants.isLdapGroups(attrName)) {
                ldapGroups.addAll(this.groupHelper.getLdapGroups(entry.getDN().toString()));
                attribute = AttributeBuilder.build((String)"ldapGroups", ldapGroups);
            } else if (LdapConstants.isPosixGroups(attrName)) {
                Set<String> posixRefAttrs = LdapUtil.getStringAttrValues(entry.getAttributes(), GroupHelper.getPosixRefAttribute());
                posixGroups.addAll(this.groupHelper.getPosixGroups(posixRefAttrs));
                attribute = AttributeBuilder.build((String)"posixGroups", posixGroups);
            } else {
                attribute = LdapConstants.PASSWORD.is(attrName) && !this.conn.getConfiguration().getRetrievePasswordsWithSearch() ? AttributeBuilder.build((String)attrName, (Object[])new Object[]{new GuardedString()}) : ("objectGUID".equalsIgnoreCase(attrName) || Uid.NAME.equals(attrName) ? AttributeBuilder.build((String)"objectGUID", (Object[])new Object[]{ADLdapUtil.objectGUIDtoDashedString(entry.getAttributes().get("objectGUID"))}) : (ManagerId.NAME.equals(attrName) ? this.getManagerAttribute(entry) : this.conn.getSchemaMapping().createAttribute(this.oclass, attrName, entry, emptyAttrWhenNotFound)));
            }
            if (attribute == null) continue;
            builder.addAttribute(new Attribute[]{attribute});
        }
        String statusManagementClass = this.conn.getConfiguration().getStatusManagementClass();
        Boolean status = StatusManagement.getInstance(statusManagementClass == null ? "DefaultStatusManagement" : statusManagementClass).getStatus(result.getAttributes(), posixGroups, ldapGroups);
        if (status != null) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.buildEnabled((boolean)status)});
        }
        this.setAdUserNameExcludeDomain(builder);
        this.setLdapUsername(builder);
        this.converAccGroups(builder);
        this.setOrganizationName(builder);
        String searchResultDN = result.getNameInNamespace();
        String searchResultParentDn = searchResultDN.substring(searchResultDN.indexOf(",") + 1);
        LdapEntry parentEntry = LdapSearches.getEntry(this.conn, LdapUtil.quietCreateLdapName(searchResultParentDn), this.conn.getConfiguration().getUidAttribute());
        if (null == parentEntry) {
            return builder.build();
        }
        String guid = null;
        if ("objectGUID".equalsIgnoreCase(this.conn.getSchemaMapping().getLdapUidAttribute(this.oclass))) {
            guid = ADLdapUtil.objectGUIDtoDashedString(parentEntry.getAttributes().get("objectGUID"));
        } else {
            try {
                guid = parentEntry.getAttributes().get(this.conn.getConfiguration().getUidAttribute()).get(0).toString();
            }
            catch (NamingException e) {
                LOG.error("Failed to obtain the upper-level GUID.message:" + e.getMessage(), new Object[0]);
            }
        }
        if (ObjectClass.ACCOUNT.getObjectClassValue().equals(this.oclass.getObjectClassValue()) || ObjectClass.GROUP.getObjectClassValue().equals(this.oclass.getObjectClassValue())) {
            builder.addAttribute("organizationId", new Object[]{guid});
        } else if (ObjectClass.ORGANIZATION.getObjectClassValue().equals(this.oclass.getObjectClassValue())) {
            builder.addAttribute("parentId", new Object[]{guid});
        }
        return builder.build();
    }

    private Attribute getManagerAttribute(LdapEntry entry) {
        try {
            if (!this.oclass.is(ObjectClass.ACCOUNT_NAME)) {
                return null;
            }
            Attributes attributes = entry.getAttributes();
            javax.naming.directory.Attribute attribute = attributes.get("manager");
            if (attribute == null || attribute.get() == null || StringUtils.isBlank((CharSequence)attribute.get().toString())) {
                return null;
            }
            String managerDn = attribute.get().toString();
            LdapEntry manageEntry = LdapSearches.getEntry(this.conn, LdapUtil.quietCreateLdapName(managerDn), this.conn.getConfiguration().getUidAttribute());
            if (manageEntry == null) {
                return null;
            }
            String managerID = "";
            if ("objectGUID".equalsIgnoreCase(this.conn.getSchemaMapping().getLdapUidAttribute(this.oclass))) {
                managerID = ADLdapUtil.objectGUIDtoDashedString(manageEntry.getAttributes().get("objectGUID"));
            }
            if ("entryUUID".equalsIgnoreCase(this.conn.getSchemaMapping().getLdapUidAttribute(this.oclass))) {
                managerID = manageEntry.getAttributes().get(this.conn.getConfiguration().getUidAttribute()).get(0).toString();
            }
            return new ManagerId(managerID);
        }
        catch (NamingException e) {
            LOG.error("Failed to process the direct superior of the account.message:" + e.getMessage(), new Object[0]);
            throw new InvalidAttributeValueException("ldap.get.org.leader.error", (Throwable)e);
        }
    }

    private void setOrganizationName(ConnectorObjectBuilder builder) {
        if (!this.oclass.is(ObjectClass.ORGANIZATION_NAME)) {
            return;
        }
        Attribute attributeByOu = builder.build().getAttributeByName(LDAP_OU);
        if (null != attributeByOu && null != attributeByOu.getValue()) {
            Attribute attrName = AttributeBuilder.build((String)LDAP_NAME, (Object[])new Object[]{attributeByOu.getValue().get(0)});
            builder.addAttribute(new Attribute[]{attrName});
        }
    }

    private void setLdapUsername(ConnectorObjectBuilder builder) {
        if (!this.oclass.is(ObjectClass.ACCOUNT_NAME)) {
            return;
        }
        if (!"objectGUID".equalsIgnoreCase(this.conn.getSchemaMapping().getLdapUidAttribute(this.oclass))) {
            Attribute attr = builder.build().getAttributeByName(LDAP_CN);
            if (attr == null || attr.getValue() == null || attr.getValue().get(0) == null || StringUtils.isBlank((CharSequence)attr.getValue().get(0).toString())) {
                return;
            }
            String cn = attr.getValue().get(0).toString();
            Attribute attrName = AttributeBuilder.build((String)USER_NAME, (Object[])new Object[]{cn});
            builder.addAttribute(new Attribute[]{attrName});
        }
    }

    private void converAccGroups(ConnectorObjectBuilder builder) {
        if (!this.oclass.is(ObjectClass.ACCOUNT_NAME)) {
            return;
        }
        Attribute attributeByName = builder.build().getAttributeByName(GroupMemberOf.NAME);
        if (attributeByName == null) {
            return;
        }
        String attrName = "objectGUID".equalsIgnoreCase(this.conn.getSchemaMapping().getLdapUidAttribute(this.oclass)) ? "memberOf" : "isMemberOf";
        Attribute attribute = builder.build().getAttributeByName(attrName);
        if (attribute == null || attribute.getValue() == null || attribute.getValue().isEmpty() || attribute.getValue().get(0) == null) {
            builder.setGroupMemberOf(new LinkedList());
            return;
        }
        List members = attribute.getValue();
        ArrayList<String> newMembers = new ArrayList<String>();
        for (Object member : members) {
            LdapEntry groupDN = LdapSearches.getEntry(this.conn, LdapUtil.quietCreateLdapName(member.toString()), this.conn.getConfiguration().getGidAttribute());
            String guid = null;
            if (groupDN == null) continue;
            if ("objectGUID".equalsIgnoreCase(this.conn.getSchemaMapping().getLdapUidAttribute(this.oclass))) {
                guid = ADLdapUtil.objectGUIDtoDashedString(groupDN.getAttributes().get("objectGUID"));
            } else {
                try {
                    guid = groupDN.getAttributes().get(this.conn.getConfiguration().getUidAttribute()).get(0).toString();
                }
                catch (NamingException e) {
                    LOG.error("Failed to convert guid to the group to which the LDAP reclaimed account belongs. The reason is:" + e.getMessage(), new Object[0]);
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)guid)) continue;
            newMembers.add(guid);
        }
        builder.setGroupMemberOf(newMembers);
    }

    private void setAdUserNameExcludeDomain(ConnectorObjectBuilder builder) {
        if (!ObjectClass.ACCOUNT.getObjectClassValue().equals(this.oclass.getObjectClassValue()) || !"objectGUID".equalsIgnoreCase(this.conn.getSchemaMapping().getLdapUidAttribute(this.oclass))) {
            return;
        }
        Attribute attributeByName = builder.build().getAttributeByName("userPrincipalName");
        if (attributeByName == null) {
            return;
        }
        List userPrincipalNameObj = attributeByName.getValue();
        String domains = this.conn.getConfiguration().getDomain();
        if (userPrincipalNameObj == null || userPrincipalNameObj.isEmpty() || userPrincipalNameObj.get(0) == null || StringUtils.isBlank((CharSequence)userPrincipalNameObj.get(0).toString())) {
            Attribute cnAttr = builder.build().getAttributeByName(LDAP_CN);
            if (cnAttr == null || cnAttr.getValue() == null || cnAttr.getValue().isEmpty() || cnAttr.getValue().get(0) == null || StringUtils.isBlank((CharSequence)cnAttr.getValue().get(0).toString())) {
                return;
            }
            String cn = cnAttr.getValue().get(0).toString();
            Attribute attr = AttributeBuilder.build((String)USER_NAME, (Object[])new Object[]{cn});
            builder.addAttribute(new Attribute[]{attr});
            return;
        }
        String userPrincipalNameStr = userPrincipalNameObj.get(0).toString();
        if (userPrincipalNameObj != null && !userPrincipalNameObj.isEmpty() && StringUtils.isNotBlank((CharSequence)domains)) {
            String[] domainSplit;
            for (String domain : domainSplit = domains.split(",")) {
                int lastIndexOf = userPrincipalNameStr.lastIndexOf("@" + domain);
                if (lastIndexOf <= 0) continue;
                userPrincipalNameStr = userPrincipalNameStr.substring(0, lastIndexOf);
                break;
            }
        } else if (userPrincipalNameStr.contains("@")) {
            userPrincipalNameStr = userPrincipalNameStr.substring(0, userPrincipalNameStr.lastIndexOf("@"));
        }
        Attribute attr = AttributeBuilder.build((String)USER_NAME, (Object[])new Object[]{userPrincipalNameStr});
        builder.addAttribute(new Attribute[]{attr});
    }

    private String getSearchFilter(String ... optionalFilters) {
        StringBuilder builder = new StringBuilder();
        String ocFilter = this.getObjectClassFilter();
        int nonBlank = StringUtil.isBlank((String)ocFilter) ? 0 : 1;
        for (String optionalFilter : optionalFilters) {
            nonBlank += StringUtil.isBlank((String)optionalFilter) ? 0 : 1;
        }
        if (nonBlank > 1) {
            builder.append("(&");
        }
        LdapSearch.appendFilter(ocFilter, builder);
        for (String optionalFilter : optionalFilters) {
            LdapSearch.appendFilter(optionalFilter, builder);
        }
        if (nonBlank > 1) {
            builder.append(')');
        }
        return builder.toString();
    }

    private String getObjectClassFilter() {
        boolean and;
        StringBuilder builder = new StringBuilder();
        List<String> ldapClasses = this.conn.getSchemaMapping().getLdapClasses(this.oclass);
        boolean bl = and = ldapClasses.size() > 1;
        if (and) {
            builder.append("(&");
        }
        for (String ldapClass : ldapClasses) {
            builder.append("(objectClass=");
            builder.append(ldapClass);
            builder.append(')');
        }
        if (and) {
            builder.append(')');
        }
        return builder.toString();
    }

    private static void appendFilter(String filter, StringBuilder toBuilder) {
        if (!StringUtil.isBlank((String)filter)) {
            boolean enclose;
            String trimmedUserFilter = filter.trim();
            boolean bl = enclose = filter.charAt(0) != '(';
            if (enclose) {
                toBuilder.append('(');
            }
            toBuilder.append(trimmedUserFilter);
            if (enclose) {
                toBuilder.append(')');
            }
        }
    }

    private List<String> getBaseDNs() {
        QualifiedUid container = this.options.getContainer();
        List<String> result = container != null ? Collections.singletonList(LdapSearches.findEntryDN(this.conn, container.getObjectClass(), container.getUid())) : Arrays.asList(this.baseDNs);
        assert (result != null);
        return result;
    }

    private LdapSearchStrategy getSearchStrategy() {
        int pageSize = 1000;
        LdapSearchStrategy result = this.conn.getConfiguration().newDefaultSearchStrategy(false);
        if (this.conn.getConfiguration().isUseVlvControls() && this.conn.supportsControl("2.16.840.1.113730.3.4.9")) {
            String vlvSortAttr = this.conn.getConfiguration().getVlvSortAttribute();
            result = new VlvIndexSearchStrategy(vlvSortAttr, pageSize);
        } else if (this.conn.supportsControl("1.2.840.113556.1.4.319")) {
            result = new PagedSearchStrategy(pageSize);
        }
        return result;
    }

    private Set<String> getAttributesToGet(String[] attributesToGet) {
        Set<Object> result;
        if (attributesToGet != null) {
            result = CollectionUtil.newCaseInsensitiveSet();
            result.addAll(Arrays.asList(attributesToGet));
            this.removeNonReadableAttributes(result);
            result.add(Name.NAME);
        } else {
            result = LdapSearch.getAttributesReturnedByDefault(this.conn, this.oclass);
        }
        result.add(Uid.NAME);
        if (!this.conn.getConfiguration().getRetrievePasswordsWithSearch() && result.contains(OperationalAttributes.PASSWORD_NAME)) {
            LOG.warn("Reading passwords not supported", new Object[0]);
        }
        if (this.oclass.is(ObjectClass.ACCOUNT_NAME)) {
            String accGroups;
            if (result.contains(USER_NAME)) {
                result.add(LDAP_CN);
            }
            if ("objectGUID".equalsIgnoreCase(this.conn.getSchemaMapping().getLdapUidAttribute(this.oclass))) {
                accGroups = "memberOf";
                result.add("userPrincipalName");
            } else {
                accGroups = "isMemberOf";
            }
            if (result.contains(ManagerId.NAME)) {
                result.add("manager");
            }
            result.add(accGroups);
        }
        if (this.oclass.is(ObjectClass.ORGANIZATION_NAME) && result.contains(LDAP_NAME)) {
            result.add(LDAP_OU);
        }
        return result;
    }

    private void removeNonReadableAttributes(Set<String> attributes) {
        boolean ldapGroups = attributes.remove("ldapGroups");
        boolean posixGroups = attributes.remove("posixGroups");
        this.conn.getSchemaMapping().removeNonReadableAttributes(this.oclass, attributes);
        if (ldapGroups) {
            attributes.add("ldapGroups");
        }
        if (posixGroups) {
            attributes.add("posixGroups");
        }
    }

    private int getLdapSearchScope() {
        String scope = this.options.getScope();
        if ("object".equals(scope)) {
            return 0;
        }
        if ("onelevel".equals(scope)) {
            return 1;
        }
        if ("subtree".equals(scope) || scope == null) {
            return 2;
        }
        throw new PermissionDeniedException("ldap.search.scope.error", new String[]{scope});
    }
}

