/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.ldap.search;

import com.bamboocloud.icf.common.logging.Log;
import com.bamboocloud.icf.connector.ldap.search.LdapSearchResultsHandler;
import com.bamboocloud.icf.connector.ldap.search.LdapSearchStrategy;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;

public class PagedSearchStrategy
extends LdapSearchStrategy {
    private static final Log LOG = Log.getLog(PagedSearchStrategy.class);
    private final int pageSize;

    public PagedSearchStrategy(int pageSize) {
        this.pageSize = pageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSearch(LdapContext initCtx, List<String> baseDNs, String query, SearchControls searchControls, LdapSearchResultsHandler handler) throws IOException, NamingException {
        LOG.ok("Searching in {0} with filter {1} and {2}", new Object[]{baseDNs, query, PagedSearchStrategy.searchControlsToString(searchControls)});
        try (LdapContext ctx = initCtx.newInstance(null);){
            Iterator<String> baseDNIter = baseDNs.iterator();
            boolean proceed = true;
            while (baseDNIter.hasNext() && proceed) {
                String baseDN = baseDNIter.next();
                byte[] cookie = null;
                do {
                    ctx.setRequestControls(new Control[]{new PagedResultsControl(this.pageSize, cookie, true)});
                    NamingEnumeration<SearchResult> results = ctx.search(baseDN, query, searchControls);
                    try {
                        while (proceed && results.hasMore()) {
                            proceed = handler.handle(baseDN, results.next());
                        }
                    }
                    catch (PartialResultException e) {
                        LOG.ok("PartialResultException caught: {0}", new Object[]{e.getRemainingName()});
                        results.close();
                    }
                } while ((cookie = this.getResponseCookie(ctx.getResponseControls())) != null);
            }
        }
    }

    private byte[] getResponseCookie(Control[] controls) {
        if (controls != null) {
            for (Control control : controls) {
                if (!(control instanceof PagedResultsResponseControl)) continue;
                PagedResultsResponseControl pagedControl = (PagedResultsResponseControl)control;
                return pagedControl.getCookie();
            }
        }
        return null;
    }

    private PagedResultsResponseControl getPagedControl(Control[] controls) {
        if (controls != null) {
            for (Control control : controls) {
                if (!(control instanceof PagedResultsResponseControl)) continue;
                return (PagedResultsResponseControl)control;
            }
        }
        return null;
    }
}

