/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.ldap.search;

import com.bamboocloud.icf.common.StringUtil;
import com.bamboocloud.icf.common.logging.Log;
import com.bamboocloud.icf.connector.ldap.search.LdapSearchResultsHandler;
import com.bamboocloud.icf.connector.ldap.search.LdapSearchStrategy;
import com.sun.jndi.ldap.ctl.VirtualListViewControl;
import com.sun.jndi.ldap.ctl.VirtualListViewResponseControl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.SortControl;
import javax.naming.ldap.SortResponseControl;

public class VlvIndexSearchStrategy
extends LdapSearchStrategy {
    private static Log LOG;
    private final String vlvIndexAttr;
    private final int pageSize;
    private int index;
    private int lastListSize;
    private byte[] cookie;

    static synchronized void setLog(Log log) {
        LOG = log;
    }

    static synchronized Log getLog() {
        if (LOG == null) {
            LOG = Log.getLog(VlvIndexSearchStrategy.class);
        }
        return LOG;
    }

    public VlvIndexSearchStrategy(String vlvSortAttr, int pageSize) {
        this.vlvIndexAttr = StringUtil.isNotBlank((String)vlvSortAttr) ? vlvSortAttr : "uid";
        this.pageSize = pageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSearch(LdapContext initCtx, List<String> baseDNs, String query, SearchControls searchControls, LdapSearchResultsHandler handler) throws IOException, NamingException {
        VlvIndexSearchStrategy.getLog().ok("Searching in {0} with filter {1} and {2}", new Object[]{baseDNs, query, VlvIndexSearchStrategy.searchControlsToString(searchControls)});
        Iterator<String> baseDNIter = baseDNs.iterator();
        boolean proceed = true;
        try (LdapContext ctx = initCtx.newInstance(null);){
            while (baseDNIter.hasNext() && proceed) {
                proceed = this.searchBaseDN(ctx, baseDNIter.next(), query, searchControls, handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean searchBaseDN(LdapContext ctx, String baseDN, String query, SearchControls searchControls, LdapSearchResultsHandler handler) throws IOException, NamingException {
        block10: {
            ArrayList<SearchResult> resultList;
            VlvIndexSearchStrategy.getLog().ok("Searching in {0}", new Object[]{baseDN});
            this.index = 1;
            this.lastListSize = 0;
            this.cookie = null;
            String lastResultName = null;
            do {
                SearchResult result2;
                SortControl sortControl = new SortControl(this.vlvIndexAttr, true);
                int afterCount = this.pageSize - 1;
                VirtualListViewControl vlvControl = new VirtualListViewControl(this.index, this.lastListSize, 0, afterCount, true);
                vlvControl.setContextID(this.cookie);
                VlvIndexSearchStrategy.getLog().ok("New search: target = {0}, afterCount = {1}", new Object[]{this.index, afterCount});
                ctx.setRequestControls(new Control[]{sortControl, vlvControl});
                resultList = new ArrayList<SearchResult>(this.pageSize);
                try (NamingEnumeration<SearchResult> results = ctx.search(baseDN, query, searchControls);){
                    while (results.hasMore()) {
                        result2 = results.next();
                        boolean overlap = false;
                        if (lastResultName != null) {
                            if (lastResultName.equals(result2.getName())) {
                                VlvIndexSearchStrategy.getLog().warn("Working around rounding error overlap at index " + this.index, new Object[0]);
                                overlap = true;
                            }
                            lastResultName = null;
                        }
                        if (overlap) continue;
                        resultList.add(result2);
                    }
                }
                this.processResponseControls(ctx.getResponseControls());
                result2 = null;
                for (SearchResult result2 : resultList) {
                    ++this.index;
                    if (handler.handle(baseDN, result2)) continue;
                    return false;
                }
                if (result2 != null) {
                    lastResultName = result2.getName();
                }
                if (this.index > this.lastListSize) break block10;
            } while (!resultList.isEmpty());
            VlvIndexSearchStrategy.getLog().warn("Ending search because received no results", new Object[0]);
        }
        return true;
    }

    private void processResponseControls(Control[] controls) throws NamingException {
        if (controls != null) {
            for (Control control : controls) {
                SortResponseControl sortControl;
                if (control instanceof SortResponseControl && (!(sortControl = (SortResponseControl)control).isSorted() || sortControl.getResultCode() != 0)) {
                    throw sortControl.getException();
                }
                if (!(control instanceof VirtualListViewResponseControl)) continue;
                VirtualListViewResponseControl vlvControl = (VirtualListViewResponseControl)control;
                if (vlvControl.getResultCode() == 0) {
                    this.lastListSize = vlvControl.getListSize();
                    this.cookie = vlvControl.getContextID();
                    VlvIndexSearchStrategy.getLog().ok("Response control: lastListSize = {0}", new Object[]{this.lastListSize});
                    continue;
                }
                throw vlvControl.getException();
            }
        }
    }
}

