/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.ldap.sync.sunds;

import com.bamboocloud.icf.framework.common.exceptions.ConnectorUnKnownException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LdifParser
implements Iterable<Line> {
    private final String ldif;

    public LdifParser(String ldif) {
        this.ldif = ldif;
    }

    @Override
    public Iterator<Line> iterator() {
        return new LineIterator(this.getUnfoldedLines());
    }

    private List<String> getUnfoldedLines() {
        String[] lines = this.ldif.split("\n", -1);
        ArrayList<String> result = new ArrayList<String>(lines.length);
        StringBuilder builder = null;
        for (String line : lines) {
            if (line.startsWith(" ")) {
                String content = line.substring(1);
                if (builder == null) {
                    builder = new StringBuilder(content);
                    continue;
                }
                builder.append(content);
                continue;
            }
            if (builder != null) {
                result.add(builder.toString());
            }
            builder = new StringBuilder(line);
        }
        if (builder != null) {
            result.add(builder.toString());
        }
        return result;
    }

    private static final class LineIterator
    implements Iterator<Line> {
        private final Iterator<String> rawLines;
        private Line lastLine;
        private Line next;

        public LineIterator(List<String> rawLines) {
            this.rawLines = rawLines.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.getNext();
            }
            return this.next != null;
        }

        @Override
        public Line next() {
            if (this.next == null) {
                this.next = this.getNext();
            }
            if (this.next == null) {
                throw new ConnectorUnKnownException();
            }
            Line result = this.next;
            this.next = null;
            return result;
        }

        private Line getNext() {
            Line result = null;
            while (result == null && this.rawLines.hasNext()) {
                String rawLine = this.rawLines.next();
                if (rawLine.trim().length() == 0 && this.lastLine != ChangeSeparator.INSTANCE) {
                    result = ChangeSeparator.INSTANCE;
                    continue;
                }
                if (rawLine.startsWith("-") && this.lastLine != Separator.INSTANCE) {
                    result = Separator.INSTANCE;
                    continue;
                }
                int sepIndex = rawLine.indexOf(58);
                if (sepIndex <= 0) continue;
                String name = rawLine.substring(0, sepIndex).trim();
                String value = rawLine.substring(sepIndex + 1).trim();
                result = new NameValue(name, value);
            }
            if (result == null && this.lastLine != ChangeSeparator.INSTANCE) {
                result = ChangeSeparator.INSTANCE;
            }
            this.lastLine = result;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class ChangeSeparator
    extends Line {
        static final ChangeSeparator INSTANCE = new ChangeSeparator();

        private ChangeSeparator() {
        }

        public String toString() {
            return "LdifParser$ChangeSeparator";
        }
    }

    public static final class Separator
    extends Line {
        static final Separator INSTANCE = new Separator();

        private Separator() {
        }

        public String toString() {
            return "LdifParser$Separator";
        }
    }

    public static final class NameValue
    extends Line {
        private final String name;
        private final String value;

        public NameValue(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "LdifParser$NameValue[name: " + this.name + "; value: " + this.value + "]";
        }
    }

    public static abstract class Line {
    }
}

