/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.ldap.util;

import com.bamboocloud.icf.common.TLSConstant;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SimpleVerifyingSSLSocketFactory
extends SocketFactory {
    private static SocketFactory simpleVerifyingSSLSocketFactory;

    public static void init(String protocolVersion) {
        TrustManager[] distrustManager = new TrustManager[]{new X509TrustManager(){
            TrustManagerFactory factory;
            X509TrustManager standardTrustManager;
            {
                try {
                    this.factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    this.factory.init((KeyStore)null);
                    TrustManager[] trustManagers = this.factory.getTrustManagers();
                    if (trustManagers.length == 0) {
                        throw new NoSuchAlgorithmException("no trust manager found");
                    }
                    this.standardTrustManager = (X509TrustManager)trustManagers[0];
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("no such algorithm", e);
                }
                catch (KeyStoreException e) {
                    throw new IllegalStateException("Key store exception", e);
                }
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                this.standardTrustManager.checkClientTrusted(x509Certificates, s);
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                this.standardTrustManager.checkServerTrusted(x509Certificates, s);
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return this.standardTrustManager.getAcceptedIssuers();
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance(protocolVersion);
            sc.init(null, distrustManager, SecureRandom.getInstanceStrong());
            simpleVerifyingSSLSocketFactory = sc.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static SocketFactory getDefault() {
        return new SimpleVerifyingSSLSocketFactory();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.enableCipherSuites(simpleVerifyingSSLSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.enableCipherSuites(simpleVerifyingSSLSocketFactory.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.enableCipherSuites(simpleVerifyingSSLSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.enableCipherSuites(simpleVerifyingSSLSocketFactory.createSocket(address, port, localAddress, localPort));
    }

    private Socket enableCipherSuites(Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            sslSocket.setEnabledCipherSuites(TLSConstant.CIPHER_SUITES);
        }
        return socket;
    }
}

