/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge;

import com.bamboocloud.bcidaas.cloudbridge.agent.encrypt.AESEncryptionManager;
import com.bamboocloud.bcidaas.cloudbridge.agent.encrypt.EncryptionKeyManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
public class IdSourceAgentApplication {
    public static void main(String[] args) {
        HashMap omap = new HashMap();
        IdSourceAgentApplication.parseArgsToMap((String[])args, omap);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));){
            String line = reader.readLine();
            if (StringUtils.isNotBlank((CharSequence)line)) {
                String[] streamArgs = StringUtils.split((String)line);
                IdSourceAgentApplication.parseArgsToMap((String[])streamArgs, omap);
            }
        }
        catch (IOException e) {
            System.out.println("Read arguments failed. exception:" + e.getMessage());
            System.exit(0);
        }
        if (omap.size() > 0 && Boolean.parseBoolean((String)omap.get("setKey"))) {
            String encryptionKey = (String)omap.get("encryptionKey");
            if (StringUtils.isBlank((CharSequence)encryptionKey)) {
                System.out.println("The encryptionKey can not be empty.");
            } else {
                EncryptionKeyManager.generateEncryptionKey((String)encryptionKey);
            }
            System.exit(0);
        } else if (omap.size() > 0 && Boolean.parseBoolean((String)omap.get("isSensitive"))) {
            String pwd = (String)omap.get("plaintext");
            String encryptionKey = EncryptionKeyManager.getEncryptionKey();
            if (StringUtils.isEmpty((CharSequence)encryptionKey)) {
                encryptionKey = System.getenv("encryptionKey");
            }
            if (StringUtils.isBlank((CharSequence)encryptionKey)) {
                System.out.println("the encryptionKey does not exist. Please check whether it has been set");
            } else {
                byte[] cipherMessage = AESEncryptionManager.encrypt((String)encryptionKey, (byte[])pwd.getBytes(StandardCharsets.UTF_8));
                System.out.println("----------------------------OUTPUT-------------------------------------");
                System.out.println("Notes: Sensitive content will not be stored, please keep it properly !");
                System.out.println("cipherText :");
                System.out.println(AESEncryptionManager.parseByte2HexStr((byte[])cipherMessage, (String)"{AES_GCM}"));
            }
            System.exit(0);
        } else {
            SpringApplication springApplication = new SpringApplication(new Class[]{IdSourceAgentApplication.class});
            springApplication.setAllowCircularReferences(true);
            springApplication.run(args);
        }
    }

    private static void parseArgsToMap(String[] args, HashMap<String, Object> argsMap) {
        Arrays.stream(args).forEach(arg -> {
            String[] oArray = arg.split("=");
            String key = oArray[0];
            String value = oArray[1];
            argsMap.put(key, value);
        });
    }
}

