/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.icf;

import com.bamboocloud.bcidaas.cloudbridge.icf.IcfSearchResultsHandlerImpl;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfSyncTokenResultsHandlerImpl;
import com.bamboocloud.bcidaas.cloudbridge.icf.util.IcfResourceAttributeUtil;
import com.bamboocloud.bcidaas.cloudbridge.icf.util.IcfResourceResultUtil;
import com.bamboocloud.bcidaas.cloudbridge.icf.util.IcfResourceSchemaUtil;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceAttribute;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceAttributeValue;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceObjectResult;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceObjectResultSearch;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceObjectResultSyncToken;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceOperationOptions;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceSchema;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceObjectResultsHandlerSearch;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceObjectResultsHandlerSyncToken;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceObjectType;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceValueType;
import com.bamboocloud.icf.framework.api.ConnectorFacade;
import com.bamboocloud.icf.framework.common.objects.Attribute;
import com.bamboocloud.icf.framework.common.objects.ConnectorObject;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import com.bamboocloud.icf.framework.common.objects.OperationOptions;
import com.bamboocloud.icf.framework.common.objects.ResultsHandler;
import com.bamboocloud.icf.framework.common.objects.Schema;
import com.bamboocloud.icf.framework.common.objects.SearchResult;
import com.bamboocloud.icf.framework.common.objects.SyncResultsHandler;
import com.bamboocloud.icf.framework.common.objects.SyncToken;
import com.bamboocloud.icf.framework.common.objects.attributes.Name;
import com.bamboocloud.icf.framework.common.objects.attributes.Password;
import com.bamboocloud.icf.framework.common.objects.attributes.Uid;
import com.bamboocloud.icf.framework.common.objects.filter.Filter;
import com.bamboocloud.icf.framework.common.serializer.SerializerUtil;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IcfResourceConnectorOperation {
    private final ConnectorFacade connectorFacade;
    private volatile ResourceSchema resourceSchema;

    public IcfResourceConnectorOperation(ConnectorFacade connectorFacade, ResourceSchema resourceSchema) {
        this.connectorFacade = connectorFacade;
        this.resourceSchema = resourceSchema;
    }

    public boolean validate() {
        this.connectorFacade.validate();
        return true;
    }

    public boolean test() {
        this.connectorFacade.test();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ResourceAttribute> attributes(String objectTypeName) {
        if (this.resourceSchema == null) {
            ConnectorFacade connectorFacade = this.connectorFacade;
            synchronized (connectorFacade) {
                this.resourceSchema = this.schema();
            }
        }
        if (!this.resourceSchema.getObjectAttributeMap().containsKey(objectTypeName)) {
            throw new IllegalArgumentException("Unsupported the object type name, objectTypeName=" + objectTypeName);
        }
        return (Map)this.resourceSchema.getObjectAttributeMap().get(objectTypeName);
    }

    public ResourceSchema schema() {
        Schema schema = null;
        schema = this.connectorFacade.schema();
        ResourceSchema resourceSchema = IcfResourceSchemaUtil.fromSchema((Schema)schema);
        return resourceSchema;
    }

    public String create(EnumResourceObjectType objectType, Map<String, ResourceAttributeValue> attributeValueMap, ResourceOperationOptions options) {
        return this.create(objectType.name(), attributeValueMap, options);
    }

    public String create(String objectTypeName, Map<String, ResourceAttributeValue> attributeValueMap, ResourceOperationOptions options) {
        ObjectClass objectClass = IcfResourceSchemaUtil.toObjectClass((String)objectTypeName);
        Set attributes = this.toAttributes(attributeValueMap);
        OperationOptions operationOptions = IcfResourceSchemaUtil.toOperationOptions((ResourceOperationOptions)options);
        Uid uid = this.connectorFacade.create(objectClass, attributes, operationOptions);
        return uid.getSingleValue();
    }

    public String update(EnumResourceObjectType objectType, String remoteId, Map<String, ResourceAttributeValue> attributeValueMap, ResourceOperationOptions options) {
        return this.update(objectType.name(), remoteId, attributeValueMap, options);
    }

    public String update(String objectTypeName, String remoteId, Map<String, ResourceAttributeValue> attributeValueMap, ResourceOperationOptions options) {
        ObjectClass objectClass = IcfResourceSchemaUtil.toObjectClass((String)objectTypeName);
        Set attributes = this.toAttributes(attributeValueMap);
        String[] attributeStrArray = this.toUpdateAttributeStrArray((Map)options.getOptions().get("ALL_ATTRIBUTES"));
        options.getOptions().put("ALL_ATTRIBUTES", attributeStrArray);
        Uid uid = new Uid(remoteId);
        OperationOptions operationOptions = IcfResourceSchemaUtil.toOperationOptions((ResourceOperationOptions)options);
        Uid newUid = this.connectorFacade.update(objectClass, uid, attributes, operationOptions);
        return newUid.getSingleValue();
    }

    public void delete(EnumResourceObjectType objectType, String remoteId, ResourceOperationOptions options) {
        this.delete(objectType.name(), remoteId, options);
    }

    public void delete(String objectTypeName, String remoteId, ResourceOperationOptions options) {
        ObjectClass objectClass = IcfResourceSchemaUtil.toObjectClass((String)objectTypeName);
        Uid uid = new Uid(remoteId);
        OperationOptions operationOptions = IcfResourceSchemaUtil.toOperationOptions((ResourceOperationOptions)options);
        this.connectorFacade.delete(objectClass, uid, new HashSet(), operationOptions);
    }

    public ResourceObjectResult get(EnumResourceObjectType objectType, String remoteId, ResourceOperationOptions options) {
        return this.get(objectType.name(), remoteId, options);
    }

    public ResourceObjectResult get(String objectTypeName, String remoteId, ResourceOperationOptions options) {
        ObjectClass objectClass = IcfResourceSchemaUtil.toObjectClass((String)objectTypeName);
        Uid uid = new Uid(remoteId);
        OperationOptions operationOptions = IcfResourceSchemaUtil.toOperationOptions((ResourceOperationOptions)options);
        ConnectorObject connectorObject = null;
        connectorObject = this.connectorFacade.getObject(objectClass, uid, operationOptions);
        ResourceObjectResult objectResult = this.fromConnectorObject(connectorObject);
        return objectResult;
    }

    public ResourceObjectResultSearch search(EnumResourceObjectType objectType, String filterExpression, EnumResourceObjectResultsHandlerSearch handler, ResourceOperationOptions options) {
        return this.search(objectType.name(), filterExpression, handler, options);
    }

    public ResourceObjectResultSearch search(String objectTypeName, String filterExpression, EnumResourceObjectResultsHandlerSearch handler, ResourceOperationOptions options) {
        ObjectClass objectClass = IcfResourceSchemaUtil.toObjectClass((String)objectTypeName);
        Filter filter = IcfResourceSchemaUtil.toFilter((String)filterExpression);
        IcfSearchResultsHandlerImpl resultsHandler = new IcfSearchResultsHandlerImpl(this, handler);
        OperationOptions operationOptions = IcfResourceSchemaUtil.toOperationOptions((ResourceOperationOptions)options);
        SearchResult searchResult = null;
        searchResult = this.connectorFacade.search(objectClass, filter, (ResultsHandler)resultsHandler, operationOptions);
        if (searchResult != null) {
            ResourceObjectResultSearch objectResult4Search = IcfResourceResultUtil.fromSearchResult((SearchResult)searchResult);
            return objectResult4Search;
        }
        return null;
    }

    public ResourceObjectResultSyncToken sync(EnumResourceObjectType objectType, Object token, EnumResourceObjectResultsHandlerSyncToken handler, ResourceOperationOptions options) {
        return this.sync(objectType.name(), token, handler, options);
    }

    public ResourceObjectResultSyncToken sync(String objectTypeName, Object token, EnumResourceObjectResultsHandlerSyncToken handler, ResourceOperationOptions options) {
        ObjectClass objectClass = IcfResourceSchemaUtil.toObjectClass((String)objectTypeName);
        IcfResourceResultUtil.checkSyncTokenValue((Object)token);
        SyncToken syncToken = new SyncToken(token);
        IcfSyncTokenResultsHandlerImpl syncTokenResultsHandler = new IcfSyncTokenResultsHandlerImpl(this, handler);
        OperationOptions operationOptions = IcfResourceSchemaUtil.toOperationOptions((ResourceOperationOptions)options);
        SyncToken newToken = null;
        newToken = this.connectorFacade.sync(objectClass, syncToken, (SyncResultsHandler)syncTokenResultsHandler, operationOptions);
        if (newToken != null && newToken.getValue() != null && !"".equals(newToken.getValue().toString())) {
            ResourceObjectResultSyncToken objectResult4SyncToken = IcfResourceResultUtil.fromSyncToken((SyncToken)newToken);
            return objectResult4SyncToken;
        }
        return null;
    }

    protected ResourceObjectResult fromConnectorObject(ConnectorObject connectorObject) {
        String objectTypeName = IcfResourceSchemaUtil.fromObjectClass((ObjectClass)connectorObject.getObjectClass(), (boolean)false);
        String uidValue = connectorObject.getUid().getSingleValue();
        String nameValue = connectorObject.getName().getSingleValue();
        if (uidValue == null || uidValue.isEmpty()) {
            throw new RuntimeException("'uidValue' must be not empty.");
        }
        if (nameValue == null || nameValue.isEmpty()) {
            throw new RuntimeException("'nameValue' must be not empty.");
        }
        ResourceObjectResult objectResult = new ResourceObjectResult(objectTypeName, uidValue, nameValue);
        Map resourceAttributeValueMap = this.fromAttributes(objectTypeName, connectorObject.getAttributes());
        objectResult.setAttributeValueMap(resourceAttributeValueMap);
        return objectResult;
    }

    protected Map<String, ResourceAttributeValue> fromAttributes(String objectTypeName, Set<Attribute> attributes) {
        Map resourceAttributeMap = this.attributes(objectTypeName);
        LinkedHashMap<String, ResourceAttributeValue> resourceAttributeValueMap = new LinkedHashMap<String, ResourceAttributeValue>();
        for (Attribute attribute : attributes) {
            String attributeName;
            if (!resourceAttributeMap.containsKey(attribute.getName()) || (attributeName = attribute.getName()).equals(Uid.NAME) || attributeName.equals(Name.NAME)) continue;
            ResourceAttribute resourceAttribute = (ResourceAttribute)resourceAttributeMap.get(attributeName);
            ResourceAttributeValue resourceAttributeValue = IcfResourceAttributeUtil.fromAttribute((Attribute)attribute, (EnumResourceValueType)resourceAttribute.getType(), (boolean)resourceAttribute.isMultiValued());
            resourceAttributeValueMap.put(attributeName, resourceAttributeValue);
        }
        return resourceAttributeValueMap;
    }

    protected Set<Attribute> toAttributes(Map<String, ResourceAttributeValue> attributeValueMap) {
        LinkedHashSet<Attribute> attributes = new LinkedHashSet<Attribute>();
        if (attributeValueMap != null) {
            for (Map.Entry<String, ResourceAttributeValue> entry : attributeValueMap.entrySet()) {
                List values;
                String attributeName = entry.getKey();
                if (Uid.NAME.equals(attributeName)) continue;
                ResourceAttributeValue resourceAttributeValue = entry.getValue();
                if (Password.NAME.equals(attributeName) && ((values = resourceAttributeValue.getValues()) == null || values.isEmpty() || values.get(0) == null)) continue;
                Attribute attribute = IcfResourceAttributeUtil.toAttribute((String)attributeName, (ResourceAttributeValue)resourceAttributeValue);
                attributes.add(attribute);
            }
        }
        return attributes;
    }

    protected String[] toUpdateAttributeStrArray(Map<String, ResourceAttributeValue> valueMap) {
        LinkedHashSet<Attribute> set = new LinkedHashSet<Attribute>();
        if (valueMap != null) {
            for (Map.Entry<String, ResourceAttributeValue> entry : valueMap.entrySet()) {
                List values;
                String attributeName = entry.getKey();
                if (Uid.NAME.equals(attributeName)) continue;
                ResourceAttributeValue resourceAttributeValue = entry.getValue();
                if (Password.NAME.equals(attributeName) && ((values = resourceAttributeValue.getValues()) == null || values.isEmpty() || values.get(0) == null)) continue;
                Attribute attribute = IcfResourceAttributeUtil.toAttribute((String)attributeName, (ResourceAttributeValue)resourceAttributeValue);
                set.add(attribute);
            }
        }
        Attribute[] attributes = set.toArray(new Attribute[0]);
        String[] array = new String[set.size()];
        for (int i = 0; i < attributes.length; ++i) {
            array[i] = SerializerUtil.serializeBase64Object((Object)attributes[i]);
        }
        return array;
    }
}

