/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.icf;

import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorOperation;
import com.bamboocloud.bcidaas.cloudbridge.icf.util.IcfResourceResultUtil;
import com.bamboocloud.bcidaas.cloudbridge.icf.util.IcfResourceSchemaUtil;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceObjectResultSync;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceObjectResultSyncToken;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceObjectResultSyncAction;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceObjectResultsHandlerSyncToken;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import com.bamboocloud.icf.framework.common.objects.SyncDelta;
import com.bamboocloud.icf.framework.common.objects.SyncToken;
import com.bamboocloud.icf.framework.common.objects.attributes.Uid;
import com.bamboocloud.icf.framework.spi.SyncTokenResultsHandler;
import java.util.Map;

public class IcfSyncTokenResultsHandlerImpl
implements SyncTokenResultsHandler {
    private final IcfResourceConnectorOperation operation;
    private final EnumResourceObjectResultsHandlerSyncToken handler;

    public IcfSyncTokenResultsHandlerImpl(IcfResourceConnectorOperation operation, EnumResourceObjectResultsHandlerSyncToken handler) {
        this.operation = operation;
        this.handler = handler;
    }

    public void handleResult(SyncToken syncToken) {
        ResourceObjectResultSyncToken result4SyncToken = IcfResourceResultUtil.fromSyncToken((SyncToken)syncToken);
        this.handler.handleResult(result4SyncToken);
    }

    public boolean handle(SyncDelta delta) {
        String objectTypeName = IcfResourceSchemaUtil.fromObjectClass((ObjectClass)delta.getObjectClass(), (boolean)false);
        String uidValue = IcfResourceSchemaUtil.fromUid((Uid)delta.getUid());
        String nameValue = delta.getObject().getName().getSingleValue();
        if (uidValue == null || uidValue.isEmpty()) {
            throw new RuntimeException("'uidValue' must be not empty.");
        }
        if (nameValue == null || nameValue.isEmpty()) {
            throw new RuntimeException("'nameValue' must be not empty.");
        }
        EnumResourceObjectResultSyncAction action = EnumResourceObjectResultSyncAction.valueOf((String)delta.getDeltaType().name());
        String previousRemoteId = delta.getPreviousUid() != null ? IcfResourceSchemaUtil.fromUid((Uid)delta.getPreviousUid()) : null;
        ResourceObjectResultSyncToken syncToken = delta.getToken() != null && delta.getToken().getValue() != null ? IcfResourceResultUtil.fromSyncToken((SyncToken)delta.getToken()) : null;
        ResourceObjectResultSync objectSyncResultDelta = new ResourceObjectResultSync(objectTypeName, uidValue, nameValue, action, previousRemoteId, syncToken);
        Map resourceAttributeValueMap = this.operation.fromAttributes(objectTypeName, delta.getObject().getAttributes());
        objectSyncResultDelta.setAttributeValueMap(resourceAttributeValueMap);
        return this.handler.handle(objectSyncResultDelta);
    }
}

