/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.icf.component;

import com.bamboocloud.bcidaas.cloudbridge.agent.config.IdSourceConfiguration;
import com.bamboocloud.bcidaas.cloudbridge.icf.EnumResourceAttributeMapper;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnector;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorOperation;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorServer;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorServerLocal;
import com.bamboocloud.bcidaas.cloudbridge.icf.config.IcfResourceConnectorsConfigurationProperties;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceAttribute;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceAttributeValue;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceConfiguration;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceConfigurationProperty;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceConnector;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceSchema;
import com.bamboocloud.bcidaas.cloudbridge.resource.util.ResourceConfigurationPropertyMapBuilder;
import com.bamboocloud.icf.framework.api.ConnectorInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@EnableConfigurationProperties(value={IcfResourceConnectorsConfigurationProperties.class})
public class IcfResourceConnectorComponent
implements InitializingBean,
DisposableBean {
    private static final String bundleDirectory = "/connector";
    private static volatile IcfResourceConnectorServer icfResourceConnectorServer;
    private static Map<String, String> usrAttributeNames;
    private static Map<String, String> orgAttributeNames;
    private static final String APP_USR = "APP_USR";
    private static final String APP_ORG = "APP_ORG";

    public void afterPropertiesSet() {
        String jarPath = new ApplicationHome(this.getClass()).getSource().getParentFile().toString();
        icfResourceConnectorServer = new IcfResourceConnectorServerLocal(jarPath + "/connector");
        EnumResourceAttributeMapper.APP_USR[] usrEnumResourceAttributeMappers = EnumResourceAttributeMapper.APP_USR.values();
        EnumResourceAttributeMapper.APP_ORG[] orgEnumResourceAttributeMappers = EnumResourceAttributeMapper.APP_ORG.values();
        for (EnumResourceAttributeMapper.APP_USR aPP_USR : usrEnumResourceAttributeMappers) {
            usrAttributeNames.put(aPP_USR.getAttrName(), aPP_USR.name());
        }
        for (EnumResourceAttributeMapper.APP_USR aPP_USR : orgEnumResourceAttributeMappers) {
            orgAttributeNames.put(aPP_USR.getAttrName(), aPP_USR.name());
        }
    }

    public void destroy() {
    }

    public IcfResourceConnectorServer getIcfResourceConnectorServer() {
        return icfResourceConnectorServer;
    }

    public IcfResourceConnector getIcfResourceConnector(@NonNull String connectorKey, boolean cleanCache) {
        if (connectorKey == null) {
            throw new NullPointerException("connectorKey is marked non-null but is null");
        }
        ResourceConnector resourceConnector = new ResourceConnector(connectorKey);
        ConnectorInfo connectorInfo = this.getIcfResourceConnectorServer().connectorInfo(resourceConnector, cleanCache);
        IcfResourceConnector icfResourceConnector = new IcfResourceConnector(connectorInfo);
        return icfResourceConnector;
    }

    public ResourceConnector getConnectorInfo(@NonNull String connectorKey, Locale locale, boolean cleanCache) {
        if (connectorKey == null) {
            throw new NullPointerException("connectorKey is marked non-null but is null");
        }
        ResourceConnector resourceConnector = new ResourceConnector(connectorKey);
        return this.getIcfResourceConnectorServer().resourceConnector(resourceConnector, locale, cleanCache);
    }

    public ResourceConfiguration getConnectorResourceConfiguration(@NonNull String connectorKey, Locale locale, boolean cleanCache) {
        if (connectorKey == null) {
            throw new NullPointerException("connectorKey is marked non-null but is null");
        }
        ResourceConnector resourceConnector = new ResourceConnector(connectorKey);
        return this.getIcfResourceConnectorServer().resourceConfiguration(resourceConnector, locale, cleanCache);
    }

    public Map<String, ResourceConfigurationProperty> getConnectorConfigurationProperties(@NonNull String connectorKey, Locale locale) {
        if (connectorKey == null) {
            throw new NullPointerException("connectorKey is marked non-null but is null");
        }
        ResourceConfiguration resourceConfiguration = this.getConnectorResourceConfiguration(connectorKey, locale, false);
        return resourceConfiguration.getPropertyMap();
    }

    public Map<String, ResourceAttributeValue> getIcfProperties(String connectorKey, IdSourceConfiguration idSourceConfiguration) {
        Map connectorConfigurationProperties = this.getConnectorConfigurationProperties(connectorKey, Locale.CHINA);
        Map propertyValueMap = IcfResourceConnectorComponent.beanToMap((Object)idSourceConfiguration);
        Map properties = this.propertyConcert(connectorConfigurationProperties, propertyValueMap);
        return properties;
    }

    public ResourceConfiguration getIcfResourceConfiguration(String connectorKey, IdSourceConfiguration idSourceConfiguration) {
        Map properties = this.getIcfProperties(connectorKey, idSourceConfiguration);
        ResourceConfiguration resourceConfiguration = new ResourceConfiguration();
        resourceConfiguration.setPropertyMap(ResourceConfigurationPropertyMapBuilder.from((Map)properties).build());
        return resourceConfiguration;
    }

    public ResourceSchema getIcfResourceSchema(String connectorKey, IdSourceConfiguration idSourceConfiguration) {
        Map properties = this.getIcfProperties(connectorKey, idSourceConfiguration);
        ResourceSchema resourceSchema = this.getConnectorResourceSchema(connectorKey, properties);
        return resourceSchema;
    }

    public IcfResourceConnectorOperation getIcfResourceConnectorOperation(String connectorKey, IdSourceConfiguration idSourceConfiguration) {
        IcfResourceConnector icfResourceConnector = this.getIcfResourceConnector(connectorKey, false);
        ResourceConfiguration resourceConfiguration = this.getIcfResourceConfiguration(connectorKey, idSourceConfiguration);
        ResourceSchema resourceSchema = this.getIcfResourceSchema(connectorKey, idSourceConfiguration);
        return icfResourceConnector.createConnectorOperation(resourceConfiguration, resourceSchema);
    }

    public Map<String, ResourceAttributeValue> propertyConcert(Map<String, ResourceConfigurationProperty> resourceConfigurationPropertyMap, Map<String, List<String>> valuesMap) {
        if (CollectionUtils.isEmpty(resourceConfigurationPropertyMap)) {
            return new LinkedHashMap<String, ResourceAttributeValue>();
        }
        LinkedHashMap<String, ResourceAttributeValue> properties = new LinkedHashMap<String, ResourceAttributeValue>();
        for (Map.Entry<String, ResourceConfigurationProperty> entry : resourceConfigurationPropertyMap.entrySet()) {
            ResourceConfigurationProperty property = entry.getValue();
            ResourceAttributeValue resourceAttributeValue = new ResourceAttributeValue(property.getType(), property.isMultiValued(), property.getValues().toArray(new String[0]));
            if (valuesMap != null) {
                resourceAttributeValue.setValues(valuesMap.get(entry.getKey()));
            }
            properties.put(entry.getKey(), resourceAttributeValue);
        }
        return properties;
    }

    public ResourceSchema getConnectorResourceSchema(@NonNull String connectorKey, @NonNull Map<String, ResourceAttributeValue> properties) {
        if (connectorKey == null) {
            throw new NullPointerException("connectorKey is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        IcfResourceConnector icfResourceConnector = this.getIcfResourceConnector(connectorKey, false);
        ResourceConfiguration resourceConfiguration = new ResourceConfiguration();
        resourceConfiguration.setPropertyMap(ResourceConfigurationPropertyMapBuilder.from(properties).build());
        IcfResourceConnectorOperation icfResourceConnectorOperation = icfResourceConnector.createConnectorOperation(resourceConfiguration, null);
        ResourceSchema schema = icfResourceConnectorOperation.schema();
        Map tempObjectAttributeMap = schema.getObjectAttributeMap();
        LinkedHashMap objectAttributeMap = new LinkedHashMap();
        for (Map.Entry entry : tempObjectAttributeMap.entrySet()) {
            String resourceAttributeKey = (String)entry.getKey();
            Map tempResourceAttributeMap = (Map)entry.getValue();
            LinkedHashMap<String, ResourceAttribute> attributeMap = new LinkedHashMap<String, ResourceAttribute>();
            for (Map.Entry resourceAttributeEntry : tempResourceAttributeMap.entrySet()) {
                String key = (String)resourceAttributeEntry.getKey();
                ResourceAttribute resourceAttribute = (ResourceAttribute)resourceAttributeEntry.getValue();
                String attributeName = this.convertAttributeName(resourceAttributeKey, key);
                attributeMap.put(attributeName, resourceAttribute);
            }
            objectAttributeMap.put(resourceAttributeKey, attributeMap);
        }
        schema.setObjectAttributeMap(objectAttributeMap);
        return schema;
    }

    public String convertAttributeName(String type, String attributeName) {
        if ("APP_USR".equals(type) && usrAttributeNames.containsKey(attributeName)) {
            return (String)usrAttributeNames.get(attributeName);
        }
        if ("APP_ORG".equals(type) && orgAttributeNames.containsKey(attributeName)) {
            return (String)orgAttributeNames.get(attributeName);
        }
        return attributeName;
    }

    public static <T> Map<String, List<String>> beanToMap(T bean) {
        BeanMap beanMap = BeanMap.create(bean);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        beanMap.forEach((key, value) -> {
            if (value instanceof String) {
                ArrayList<String> newValue = new ArrayList<String>(1);
                newValue.add(String.valueOf(value));
                map.put(String.valueOf(key), newValue);
            } else if (value instanceof List) {
                List newValue = (List)value;
                map.put(String.valueOf(key), newValue);
            }
        });
        return map;
    }

    static {
        usrAttributeNames = new LinkedHashMap();
        orgAttributeNames = new LinkedHashMap();
    }
}

