/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.resource;

import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceAttribute;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceOperationOption;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceApi;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class ResourceSchema
implements Serializable {
    private final Map<String, Map<String, ResourceAttribute>> objectAttributeMap = new LinkedHashMap();
    private final Map<String, ResourceOperationOption> operationOptionMap = new LinkedHashMap();
    private final Map<String, Map<EnumResourceApi, Set<String>>> apiObjectAttributeMap = new LinkedHashMap();
    private final Map<EnumResourceApi, Set<String>> apiOperationOptionMap = new LinkedHashMap();

    public Map<String, Map<String, ResourceAttribute>> getObjectAttributeMap() {
        return this.objectAttributeMap;
    }

    public void setObjectAttributeMap(Map<String, Map<String, ResourceAttribute>> objectAttributeMap) {
        this.objectAttributeMap.clear();
        if (objectAttributeMap != null) {
            for (Map.Entry<String, Map<String, ResourceAttribute>> entry : objectAttributeMap.entrySet()) {
                this.addObjectAttributeMap(entry.getKey(), entry.getValue());
            }
        }
    }

    public ResourceSchema addObjectAttributeMap(String objectClass, Map<String, ResourceAttribute> attributeMap) {
        if (objectClass == null || objectClass.isEmpty()) {
            throw new IllegalArgumentException("'objectClass' must be not blank.");
        }
        if (attributeMap == null || attributeMap.isEmpty()) {
            throw new IllegalArgumentException("'attributeMap' must be not empty.");
        }
        for (Map.Entry<String, ResourceAttribute> entry : attributeMap.entrySet()) {
            this.addObjectAttribute(objectClass, entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ResourceSchema addObjectAttribute(String objectClass, String attributeName, ResourceAttribute attribute) {
        if (objectClass == null || objectClass.isEmpty()) {
            throw new IllegalArgumentException("'objectClass' must be not blank.");
        }
        if (attributeName == null || attributeName.isEmpty()) {
            throw new IllegalArgumentException("'attributeName' must be not blank.");
        }
        if (attribute == null) {
            throw new IllegalArgumentException("'attribute' must be not null.");
        }
        if (!this.objectAttributeMap.containsKey(objectClass)) {
            this.objectAttributeMap.put(objectClass, new LinkedHashMap());
        }
        ((Map)this.objectAttributeMap.get(objectClass)).put(attributeName, attribute);
        return this;
    }

    public Map<String, ResourceOperationOption> getOperationOptionMap() {
        return this.operationOptionMap;
    }

    public void setOperationOptionMap(Map<String, ResourceOperationOption> operationOptionMap) {
        this.operationOptionMap.clear();
        if (operationOptionMap != null) {
            for (Map.Entry<String, ResourceOperationOption> entry : operationOptionMap.entrySet()) {
                this.addOperationOption(entry.getKey(), entry.getValue());
            }
        }
    }

    public ResourceSchema addOperationOption(String optionName, ResourceOperationOption operationOption) {
        if (optionName == null || optionName.isEmpty()) {
            throw new IllegalArgumentException("'optionName' must be not blank.");
        }
        if (operationOption == null) {
            throw new IllegalArgumentException("'operationOption' must be not null.");
        }
        if (operationOption.getType() == null) {
            throw new IllegalArgumentException("'objectClass.type' must be not null.");
        }
        this.operationOptionMap.put(optionName, operationOption);
        return this;
    }

    public Map<String, Map<EnumResourceApi, Set<String>>> getApiObjectAttributeMap() {
        return this.apiObjectAttributeMap;
    }

    public void setApiObjectAttributeMap(Map<String, Map<EnumResourceApi, Set<String>>> apiObjectAttributeMap) {
        this.apiObjectAttributeMap.clear();
        if (apiObjectAttributeMap != null) {
            for (Map.Entry<String, Map<EnumResourceApi, Set<String>>> entry : apiObjectAttributeMap.entrySet()) {
                this.addApiObjectAttributeMap(entry.getKey(), entry.getValue());
            }
        }
    }

    public ResourceSchema addApiObjectAttributeMap(String objectClass, Map<EnumResourceApi, Set<String>> objectAttributeNameMap) {
        if (objectClass == null || objectClass.isEmpty()) {
            throw new IllegalArgumentException("'objectClass' must be not blank.");
        }
        if (objectAttributeNameMap == null || objectAttributeNameMap.isEmpty()) {
            throw new IllegalArgumentException("'objectAttributeNameMap' must be not empty.");
        }
        for (Map.Entry<EnumResourceApi, Set<String>> entry : objectAttributeNameMap.entrySet()) {
            this.addApiObjectAttributeNames(objectClass, entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ResourceSchema addApiObjectAttributeNames(String objectClass, EnumResourceApi api, Set<String> attributeNames) {
        if (objectClass == null || objectClass.isEmpty()) {
            throw new IllegalArgumentException("'objectClass' must be not blank.");
        }
        if (api == null) {
            throw new IllegalArgumentException("'api' must be not null.");
        }
        if (attributeNames == null || attributeNames.isEmpty()) {
            throw new IllegalArgumentException("'attributes' must be not empty.");
        }
        for (String attributeName : attributeNames) {
            this.addApiObjectAttributeName(objectClass, api, attributeName);
        }
        return this;
    }

    public ResourceSchema addApiObjectAttributeName(String objectTypeName, EnumResourceApi api, String attributeName) {
        if (objectTypeName == null || objectTypeName.isEmpty()) {
            throw new IllegalArgumentException("'objectTypeName' must be not blank.");
        }
        if (api == null) {
            throw new IllegalArgumentException("'api' must be not null.");
        }
        if (attributeName == null || attributeName.isEmpty()) {
            throw new IllegalArgumentException("'attributeName' must be not blank.");
        }
        if (!this.apiObjectAttributeMap.containsKey(objectTypeName)) {
            this.apiObjectAttributeMap.put(objectTypeName, new LinkedHashMap());
        }
        if (!((Map)this.apiObjectAttributeMap.get(objectTypeName)).containsKey(api)) {
            ((Map)this.apiObjectAttributeMap.get(objectTypeName)).put(api, new LinkedHashSet());
        }
        ((Set)((Map)this.apiObjectAttributeMap.get(objectTypeName)).get(api)).add(attributeName);
        return this;
    }

    public Map<EnumResourceApi, Set<String>> getApiOperationOptionMap() {
        return this.apiOperationOptionMap;
    }

    public void setApiOperationOptionMap(Map<EnumResourceApi, Set<String>> apiOperationOptionMap) {
        this.apiOperationOptionMap.clear();
        if (apiOperationOptionMap != null) {
            for (Map.Entry<EnumResourceApi, Set<String>> entry : apiOperationOptionMap.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                for (String optionName : entry.getValue()) {
                    this.addApiOperationOption(entry.getKey(), optionName);
                }
            }
        }
    }

    public ResourceSchema addApiOperationOption(EnumResourceApi api, String optionName) {
        if (api == null) {
            throw new IllegalArgumentException("'api' must be not null.");
        }
        if (optionName == null || optionName.isEmpty()) {
            throw new IllegalArgumentException("'optionName' must be not blank.");
        }
        if (!this.apiOperationOptionMap.containsKey(api)) {
            this.apiOperationOptionMap.put(api, new LinkedHashSet());
        }
        ((Set)this.apiOperationOptionMap.get(api)).add(optionName);
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceSchema)) {
            return false;
        }
        ResourceSchema other = (ResourceSchema)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map this$objectAttributeMap = this.getObjectAttributeMap();
        Map other$objectAttributeMap = other.getObjectAttributeMap();
        if (this$objectAttributeMap == null ? other$objectAttributeMap != null : !((Object)this$objectAttributeMap).equals(other$objectAttributeMap)) {
            return false;
        }
        Map this$operationOptionMap = this.getOperationOptionMap();
        Map other$operationOptionMap = other.getOperationOptionMap();
        if (this$operationOptionMap == null ? other$operationOptionMap != null : !((Object)this$operationOptionMap).equals(other$operationOptionMap)) {
            return false;
        }
        Map this$apiObjectAttributeMap = this.getApiObjectAttributeMap();
        Map other$apiObjectAttributeMap = other.getApiObjectAttributeMap();
        if (this$apiObjectAttributeMap == null ? other$apiObjectAttributeMap != null : !((Object)this$apiObjectAttributeMap).equals(other$apiObjectAttributeMap)) {
            return false;
        }
        Map this$apiOperationOptionMap = this.getApiOperationOptionMap();
        Map other$apiOperationOptionMap = other.getApiOperationOptionMap();
        return !(this$apiOperationOptionMap == null ? other$apiOperationOptionMap != null : !((Object)this$apiOperationOptionMap).equals(other$apiOperationOptionMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResourceSchema;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $objectAttributeMap = this.getObjectAttributeMap();
        result = result * 59 + ($objectAttributeMap == null ? 43 : ((Object)$objectAttributeMap).hashCode());
        Map $operationOptionMap = this.getOperationOptionMap();
        result = result * 59 + ($operationOptionMap == null ? 43 : ((Object)$operationOptionMap).hashCode());
        Map $apiObjectAttributeMap = this.getApiObjectAttributeMap();
        result = result * 59 + ($apiObjectAttributeMap == null ? 43 : ((Object)$apiObjectAttributeMap).hashCode());
        Map $apiOperationOptionMap = this.getApiOperationOptionMap();
        result = result * 59 + ($apiOperationOptionMap == null ? 43 : ((Object)$apiOperationOptionMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResourceSchema(objectAttributeMap=" + this.getObjectAttributeMap() + ", operationOptionMap=" + this.getOperationOptionMap() + ", apiObjectAttributeMap=" + this.getApiObjectAttributeMap() + ", apiOperationOptionMap=" + this.getApiOperationOptionMap() + ")";
    }
}

