/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.resource.util;

import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceAttributeValue;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceValueType;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;

public class ResourceAttributeValueMapBuilder {
    private Map<String, ResourceAttributeValue> map = new LinkedHashMap();

    private ResourceAttributeValueMapBuilder() {
    }

    public static ResourceAttributeValueMapBuilder newInstance() {
        ResourceAttributeValueMapBuilder builder = new ResourceAttributeValueMapBuilder();
        return builder;
    }

    public ResourceAttributeValueMapBuilder add(@NonNull String name, @NonNull ResourceAttributeValue attributeValue) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (attributeValue == null) {
            throw new NullPointerException("attributeValue is marked non-null but is null");
        }
        this.map.put(name, attributeValue);
        return this;
    }

    public ResourceAttributeValueMapBuilder add(@NonNull String name, @NonNull EnumResourceValueType type, boolean multiValued, String ... values) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.map.put(name, new ResourceAttributeValue(type, multiValued, values));
        return this;
    }

    public ResourceAttributeValueMapBuilder addValues(String name, String ... values) {
        if (!this.map.containsKey(name)) {
            throw new IllegalArgumentException("Invalid name, name=" + name);
        }
        ((ResourceAttributeValue)this.map.get(name)).addValues(values);
        return this;
    }

    public ResourceAttributeValueMapBuilder addValue(String name, String value) {
        if (!this.map.containsKey(name)) {
            throw new IllegalArgumentException("Invalid name, name=" + name);
        }
        ((ResourceAttributeValue)this.map.get(name)).addValue(value);
        return this;
    }

    public Map<String, ResourceAttributeValue> build() {
        return new LinkedHashMap<String, ResourceAttributeValue>(this.map);
    }
}

