/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.service.recycle;

import com.bamboocloud.bcidaas.bridge.api.Packet;
import com.bamboocloud.bcidaas.bridge.api.exception.IdSourceReconciliationError;
import com.bamboocloud.bcidaas.cloudbridge.agent.config.AdConfiguration;
import com.bamboocloud.bcidaas.cloudbridge.agent.config.IdSourceConfiguration;
import com.bamboocloud.bcidaas.cloudbridge.agent.session.MessageSender;
import com.bamboocloud.bcidaas.cloudbridge.agent.websocket.handler.MessageHandler;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorOperation;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorServerLocal;
import com.bamboocloud.bcidaas.cloudbridge.icf.component.IcfResourceConnectorComponent;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceOperationOptions;
import com.bamboocloud.bcidaas.cloudbridge.resource.enums.EnumResourceObjectResultsHandlerSearch;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorConnectException;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorException;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorNameNotFoundException;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorSocketException;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorSocketTimeoutException;
import com.bamboocloud.icf.framework.common.exceptions.UnknownUidException;
import com.google.protobuf.ProtocolStringList;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketSession;

@Component
public class AdReconciliationHandler
implements MessageHandler<Packet.IdSourceReconciliationRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdReconciliationHandler.class);
    @Resource
    private IcfResourceConnectorComponent icfResourceConnectorComponent;
    @Resource
    private AdConfiguration adConfiguration;
    private static final String APP_USR = "APP_USR";
    private static final String APP_ORG = "APP_ORG";
    private static final Integer DEFAULT_PAGE_SIZE = 100;
    public static final Map<Class<? extends Exception>, IdSourceReconciliationError> ExceptionToErrorMap = new HashMap();
    public static final Map<Packet.ReconciliationType, String> ObjectTypeToADType;
    private WebSocketSession session;
    private int requestId;

    public Packet.MessageType getSupportedMessageType() {
        return Packet.MessageType.ID_SOURCE_RECONCILIATION_REQUEST;
    }

    public Packet.IdSourceReconciliationRequest getMessage(Packet.Message message) {
        return message.getIdSourceReconciliationRequest();
    }

    public void ProcessMessage(WebSocketSession session, Packet.IdSourceReconciliationRequest message) throws IOException {
        log.info("receive AD identity source reclaim request for request id ={}.", (Object)message.getRequestId());
        this.session = session;
        this.requestId = message.getRequestId();
        Packet.Message.Builder messageBuilder = Packet.Message.newBuilder();
        messageBuilder.setType(Packet.MessageType.ID_SOURCE_RECONCILIATION_RESPONSE);
        List reconciliationTypeList = message.getReconciliationTypeList();
        Packet.ReconciliationOrgAttributes reconciliationOrgAttributes = message.getReconciliationOrgAttributes();
        ProtocolStringList orgAttributesList = reconciliationOrgAttributes.getOrgAttributesList();
        Packet.ReconciliationUserAttributes reconciliationUserAttributes = message.getReconciliationUserAttributes();
        ProtocolStringList userAttributesList = reconciliationUserAttributes.getUserAttributesList();
        messageBuilder.getIdSourceReconciliationResponseBuilder().addAllReconciliationType((Iterable)reconciliationTypeList);
        Packet.ConnectorType connectorType = message.getConnectorType();
        AtomicReference connectorKey = new AtomicReference();
        try {
            Packet.ConnectorType finalConnectorType = connectorType;
            IcfResourceConnectorServerLocal.connectorKey.stream().forEach(k -> {
                if (k.contains(StringUtils.lowerCase((String)finalConnectorType.name()))) {
                    connectorKey.set(k);
                }
            });
            log.debug("select the connector based on the connector type: {} and the connector for request id ={}.", connectorKey, (Object)message.getRequestId());
            messageBuilder.getIdSourceReconciliationResponseBuilder().setSuccess(true).setRequestId(message.getRequestId()).setStatusType(Packet.StatusType.START);
            MessageSender.sendMessageSync((WebSocketSession)session, (Packet.Message)messageBuilder.build());
            IcfResourceConnectorOperation connectorOperation = this.icfResourceConnectorComponent.getIcfResourceConnectorOperation((String)connectorKey.get(), (IdSourceConfiguration)this.adConfiguration);
            String filterExpression = null;
            ResourceOperationOptions operationOptions = new ResourceOperationOptions();
            operationOptions.getOptions().put("PAGE_SIZE", DEFAULT_PAGE_SIZE);
            EnumResourceObjectResultsHandlerSearch resultsHandler = this.reconData();
            log.info("start reclaiming ad identity source data for request id ={}. ", (Object)message.getRequestId());
            reconciliationTypeList.stream().forEach(reconciliationType -> {
                if (APP_ORG.equals(ObjectTypeToADType.get(reconciliationType))) {
                    operationOptions.setAttributesGet((String[])orgAttributesList.toArray((Object[])new String[orgAttributesList.size()]));
                } else if (APP_USR.equals(ObjectTypeToADType.get(reconciliationType))) {
                    operationOptions.setAttributesGet((String[])userAttributesList.toArray((Object[])new String[userAttributesList.size()]));
                }
                connectorOperation.search((String)ObjectTypeToADType.get(reconciliationType), filterExpression, resultsHandler, operationOptions);
            });
            log.info("ad identity source reclaim for requestId {} end", (Object)this.requestId);
            messageBuilder.getIdSourceReconciliationResponseBuilder().setSuccess(true).setRequestId(message.getRequestId()).setStatusType(Packet.StatusType.END);
            MessageSender.sendMessageSync((WebSocketSession)session, (Packet.Message)messageBuilder.build());
        }
        catch (Exception e) {
            this.idSourceReconciliationError(message.getRequestId(), reconciliationTypeList, messageBuilder, e);
        }
    }

    private void idSourceReconciliationError(int requestId, List<Packet.ReconciliationType> reconciliationTypeList, Packet.Message.Builder messageBuilder, Exception e) {
        IdSourceReconciliationError error = (IdSourceReconciliationError)ExceptionToErrorMap.get(e.getClass());
        if (error == null) {
            error = IdSourceReconciliationError.UNKNOWN_ERROR;
        }
        messageBuilder.getIdSourceReconciliationResponseBuilder().setSuccess(false).setStatusType(Packet.StatusType.END).setError(error.getCode());
        MessageSender.sendMessageSync((WebSocketSession)this.session, (Packet.Message)messageBuilder.build());
        log.error("ad identity source reclaim for requestId {} failed with error {}", new Object[]{requestId, error, e});
    }

    public EnumResourceObjectResultsHandlerSearch reconData() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static {
        ExceptionToErrorMap.put(UnknownUidException.class, IdSourceReconciliationError.UNKNOWN_UID);
        ExceptionToErrorMap.put(ConnectorNameNotFoundException.class, IdSourceReconciliationError.NO_OBJECT);
        ExceptionToErrorMap.put(ConnectorSocketTimeoutException.class, IdSourceReconciliationError.CONNECTION_ADDRESS_ACCESS_ERROR);
        ExceptionToErrorMap.put(ConnectorConnectException.class, IdSourceReconciliationError.PORT_ERROR);
        ExceptionToErrorMap.put(ConnectorSocketException.class, IdSourceReconciliationError.SSL_CONNECTION_ERROR);
        ExceptionToErrorMap.put(ConnectorException.class, IdSourceReconciliationError.AD_CONNECTION_CFG_INCORRECT);
        ObjectTypeToADType = new HashMap();
        ObjectTypeToADType.put(Packet.ReconciliationType.ORG, APP_ORG);
        ObjectTypeToADType.put(Packet.ReconciliationType.ACC, APP_USR);
    }
}

