/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.service.recycle;

import com.alibaba.fastjson.JSON;
import com.bamboocloud.bcidaas.bridge.api.Packet;
import com.bamboocloud.bcidaas.bridge.api.exception.IdSourceReconciliationError;
import com.bamboocloud.bcidaas.cloudbridge.agent.config.AdConfiguration;
import com.bamboocloud.bcidaas.cloudbridge.agent.config.IdSourceConfiguration;
import com.bamboocloud.bcidaas.cloudbridge.agent.session.MessageSender;
import com.bamboocloud.bcidaas.cloudbridge.agent.websocket.handler.MessageHandler;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorServerLocal;
import com.bamboocloud.bcidaas.cloudbridge.icf.component.IcfResourceConnectorComponent;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceSchema;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorConnectException;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorSocketException;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorSocketTimeoutException;
import com.google.protobuf.ByteString;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketSession;

@Component
public class IdSourceSchemaHandler
implements MessageHandler<Packet.IdSourceSchemaRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdSourceSchemaHandler.class);
    @Resource
    private IcfResourceConnectorComponent icfResourceConnectorComponent;
    @Resource
    private AdConfiguration adConfiguration;
    public static final Map<Class<? extends Exception>, IdSourceReconciliationError> ExceptionToErrorMap = new HashMap();

    public Packet.MessageType getSupportedMessageType() {
        return Packet.MessageType.ID_SOURCE_SCHEMA_REQUEST;
    }

    public Packet.IdSourceSchemaRequest getMessage(Packet.Message message) {
        return message.getIdSourceSchemaRequest();
    }

    public void ProcessMessage(WebSocketSession session, Packet.IdSourceSchemaRequest message) throws IOException {
        Packet.Message.Builder messageBuilder = Packet.Message.newBuilder();
        messageBuilder.setType(Packet.MessageType.ID_SOURCE_SCHEMA_RESPONSE);
        try {
            Packet.ConnectorType connectorType = message.getConnectorType();
            if (Packet.ConnectorType.AD.equals((Object)connectorType)) {
                connectorType = Packet.ConnectorType.LDAP;
            }
            AtomicReference connectorKey = new AtomicReference();
            Packet.ConnectorType finalConnectorType = connectorType;
            IcfResourceConnectorServerLocal.connectorKey.stream().forEach(k -> {
                if (k.contains(StringUtils.lowerCase((String)finalConnectorType.name()))) {
                    connectorKey.set(k);
                }
            });
            ResourceSchema resourceSchema = this.icfResourceConnectorComponent.getIcfResourceSchema((String)connectorKey.get(), (IdSourceConfiguration)this.adConfiguration);
            messageBuilder.getIdSourceSchemaResponseBuilder().setSuccess(true).setRequestId(message.getRequestId()).setSchemaBody(ByteString.copyFrom((byte[])JSON.toJSONString((Object)resourceSchema).getBytes()));
        }
        catch (Exception e) {
            this.idSourceSchemaError(message.getRequestId(), message.getConnectorType(), messageBuilder, e);
        }
        MessageSender.sendMessageSync((WebSocketSession)session, (Packet.Message)messageBuilder.build());
    }

    private void idSourceSchemaError(int requestId, Packet.ConnectorType connectorType, Packet.Message.Builder messageBuilder, Exception e) {
        IdSourceReconciliationError error = (IdSourceReconciliationError)ExceptionToErrorMap.get(e.getClass());
        if (error == null) {
            error = IdSourceReconciliationError.UNKNOWN_ERROR;
        }
        messageBuilder.getIdSourceSchemaResponseBuilder().setSuccess(false).setRequestId(requestId).setError(error.getCode());
        log.error("get the identity source schema request {} for connectorType {} failed with error {}", new Object[]{requestId, connectorType, error, e});
    }

    static {
        ExceptionToErrorMap.put(ConnectorSocketTimeoutException.class, IdSourceReconciliationError.CONNECTION_ADDRESS_ACCESS_ERROR);
        ExceptionToErrorMap.put(ConnectorConnectException.class, IdSourceReconciliationError.PORT_ERROR);
        ExceptionToErrorMap.put(ConnectorSocketException.class, IdSourceReconciliationError.SSL_CONNECTION_ERROR);
    }
}

