/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.bcidaas.cloudbridge.service.recycle;

import com.bamboocloud.bcidaas.bridge.api.Packet;
import com.bamboocloud.bcidaas.cloudbridge.agent.config.AdConfiguration;
import com.bamboocloud.bcidaas.cloudbridge.agent.config.IdSourceConfiguration;
import com.bamboocloud.bcidaas.cloudbridge.agent.session.MessageSender;
import com.bamboocloud.bcidaas.cloudbridge.agent.websocket.handler.MessageHandler;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnector;
import com.bamboocloud.bcidaas.cloudbridge.icf.IcfResourceConnectorOperation;
import com.bamboocloud.bcidaas.cloudbridge.icf.component.IcfResourceConnectorComponent;
import com.bamboocloud.bcidaas.cloudbridge.icf.exception.ConnectorNotFoundException;
import com.bamboocloud.bcidaas.cloudbridge.icf.util.IdSourceErrorUtil;
import com.bamboocloud.bcidaas.cloudbridge.resource.ResourceConfiguration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketSession;

@Component
public class IdSourceTestRequestHandler
implements MessageHandler<Packet.IdSourceTestRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdSourceTestRequestHandler.class);
    @Autowired
    private IcfResourceConnectorComponent icfResourceConnectorComponent;
    @Autowired
    AdConfiguration adConfiguration;

    public Packet.MessageType getSupportedMessageType() {
        return Packet.MessageType.ID_SOURCE_TEST_REQUEST;
    }

    public Packet.IdSourceTestRequest getMessage(Packet.Message message) {
        return message.getIdSourceTestRequest();
    }

    public void ProcessMessage(WebSocketSession session, Packet.IdSourceTestRequest message) {
        Packet.Message.Builder messageBuilder = Packet.Message.newBuilder();
        messageBuilder.setType(Packet.MessageType.ID_SOURCE_TEST_RESPONSE);
        String connectorKey = message.getConnectorKey();
        String appId = message.getAppId();
        log.debug("accept app idSource test request message and appId: {}, connectorKey: {}", (Object)appId, (Object)connectorKey);
        try {
            IcfResourceConnector icfResourceConnector = this.icfResourceConnectorComponent.getIcfResourceConnector(connectorKey, false);
            if (icfResourceConnector == null && connectorKey.contains("upstream-ad")) {
                connectorKey = "bcidaas-icf-connector-ldap:1.5.1.0-SNAPSHOT:com.bamboocloud.icf.connector.ldap.LdapConnector";
                icfResourceConnector = this.icfResourceConnectorComponent.getIcfResourceConnector(connectorKey, false);
            }
            if (icfResourceConnector == null) {
                String[] connectorKeys = connectorKey.split(":");
                throw new ConnectorNotFoundException(connectorKeys[0].concat(":").concat(connectorKeys[1]));
            }
            ResourceConfiguration resourceConfiguration = this.icfResourceConnectorComponent.getIcfResourceConfiguration(connectorKey, (IdSourceConfiguration)this.adConfiguration);
            IcfResourceConnectorOperation connectorOperation = icfResourceConnector.createConnectorOperation(resourceConfiguration, null);
            boolean test = connectorOperation.test();
            messageBuilder.getIdSourceTestResponseBuilder().setRequestId(message.getRequestId()).setSuccess(test);
        }
        catch (Exception e) {
            log.error("app idSource test failed. appId: {}, connectorKey: {}, message: {}", new Object[]{appId, connectorKey, e});
            Packet.IdSourceError idSourceError = IdSourceErrorUtil.buildIdSourceError((Exception)e);
            messageBuilder.getIdSourceTestResponseBuilder().setRequestId(message.getRequestId()).setSuccess(false).setError(idSourceError);
        }
        boolean sendSuccess = MessageSender.sendMessageSync((WebSocketSession)session, (Packet.Message)messageBuilder.build());
        log.debug("send app idSource test response message. result: {}, appId: {}", (Object)sendSuccess, (Object)appId);
    }
}

