/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.upstream.ad;

import com.bamboocloud.icf.common.security.GuardedString;
import com.bamboocloud.icf.connector.upstream.ad.AdConnection;
import com.bamboocloud.icf.connector.upstream.ad.commons.LdapConstants;
import com.bamboocloud.icf.connector.upstream.ad.search.LdapSearches;
import com.bamboocloud.icf.framework.common.exceptions.ConfigurationException;
import com.bamboocloud.icf.framework.common.exceptions.PasswordExpiredException;
import com.bamboocloud.icf.framework.common.objects.Attribute;
import com.bamboocloud.icf.framework.common.objects.AttributeBuilder;
import com.bamboocloud.icf.framework.common.objects.ConnectorObject;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import com.bamboocloud.icf.framework.common.objects.OperationOptions;
import com.bamboocloud.icf.framework.common.objects.attributes.Uid;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class AdAuthenticate {
    private final AdConnection conn;
    private final ObjectClass oclass;
    private final String username;
    private final OperationOptions options;

    public AdAuthenticate(AdConnection conn, ObjectClass oclass, String username, OperationOptions options) {
        this.conn = conn;
        this.oclass = oclass;
        this.username = username;
        this.options = options;
    }

    public Uid authenticate(GuardedString password) {
        ConnectorObject authnObject = this.getObjectToAuthenticate();
        AdConnection.AuthenticationResult authnResult = null;
        if (authnObject != null) {
            String entryDN = authnObject.getAttributeByName(this.conn.getConfiguration().getDnAttribute()).getValue().get(0).toString();
            authnResult = this.conn.authenticate(entryDN, password);
        }
        if (authnResult == null || !AdAuthenticate.isSuccess(authnResult)) {
            throw new ConfigurationException("ad.authenticationFailed", new String[]{this.username});
        }
        try {
            authnResult.propagate();
        }
        catch (PasswordExpiredException e) {
            e.initUid(authnObject.getUid());
            throw e;
        }
        return authnObject.getUid();
    }

    public Uid resolveUsername() {
        ConnectorObject authnObject = this.getObjectToAuthenticate();
        if (authnObject == null) {
            throw new ConfigurationException("ad.cannotResolveUsername", new String[]{this.username});
        }
        return authnObject.getUid();
    }

    private ConnectorObject getObjectToAuthenticate() {
        List<String> userNameAttrs = this.getUserNameAttributes();
        HashMap<String, ConnectorObject> entryDN2Object = new HashMap<String, ConnectorObject>();
        String dnAttributeName = this.conn.getConfiguration().getDnAttribute();
        for (String baseContext : this.conn.getConfiguration().getBaseContexts()) {
            for (String userNameAttr : userNameAttrs) {
                Attribute attr = AttributeBuilder.build((String)userNameAttr, (Object[])new Object[]{this.username});
                for (ConnectorObject object : LdapSearches.findObjects(this.conn, this.oclass, baseContext, attr, dnAttributeName)) {
                    String entryDN = object.getAttributeByName(dnAttributeName).getValue().get(0).toString();
                    entryDN2Object.put(entryDN, object);
                }
                if (entryDN2Object.size() <= 1) continue;
                throw new ConfigurationException("ad.moreThanOneEntryMatched", new String[]{this.username});
            }
        }
        if (!entryDN2Object.isEmpty()) {
            return (ConnectorObject)entryDN2Object.values().iterator().next();
        }
        return null;
    }

    private List<String> getUserNameAttributes() {
        String[] result = LdapConstants.getLdapUidAttributes(this.options);
        if (result != null && result.length > 0) {
            return Arrays.asList(result);
        }
        return this.conn.getSchemaMapping().getUserNameLdapAttributes(this.oclass);
    }

    private static boolean isSuccess(AdConnection.AuthenticationResult authResult) {
        AdConnection.AuthenticationResultType type = authResult.getType();
        return type.equals((Object)AdConnection.AuthenticationResultType.SUCCESS) || type.equals((Object)AdConnection.AuthenticationResultType.PASSWORD_EXPIRED);
    }
}

