/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.upstream.ad;

import com.bamboocloud.icf.common.CollectionUtil;
import com.bamboocloud.icf.common.IPV4Util;
import com.bamboocloud.icf.common.Pair;
import com.bamboocloud.icf.common.SSLSocketFactoryWrapper;
import com.bamboocloud.icf.common.StringUtil;
import com.bamboocloud.icf.common.TLSConstant;
import com.bamboocloud.icf.common.logging.Log;
import com.bamboocloud.icf.common.security.GuardedString;
import com.bamboocloud.icf.connector.upstream.ad.AdConfiguration;
import com.bamboocloud.icf.connector.upstream.ad.commons.LdapErrorUtil;
import com.bamboocloud.icf.connector.upstream.ad.commons.LdapNativeSchema;
import com.bamboocloud.icf.connector.upstream.ad.commons.LdapUtil;
import com.bamboocloud.icf.connector.upstream.ad.commons.ServerNativeSchema;
import com.bamboocloud.icf.connector.upstream.ad.commons.StaticNativeSchema;
import com.bamboocloud.icf.connector.upstream.ad.schema.LdapSchemaMapping;
import com.bamboocloud.icf.connector.upstream.ad.util.NonStartTLSVerifyingSSLSocketFactory;
import com.bamboocloud.icf.connector.upstream.ad.util.NonVerifyingSSLSocketFactory;
import com.bamboocloud.icf.connector.upstream.ad.util.SimpleVerifyingSSLSocketFactory;
import com.bamboocloud.icf.framework.common.exceptions.APIFailedException;
import com.bamboocloud.icf.framework.common.exceptions.ConfigurationException;
import com.bamboocloud.icf.framework.common.exceptions.ConnectionFailedException;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorException;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorSecurityException;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorUnKnownException;
import com.bamboocloud.icf.framework.common.exceptions.PasswordExpiredException;
import com.sun.jndi.ldap.ctl.PasswordExpiredResponseControl;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class AdConnection {
    private static final Log logger = Log.getLog(AdConnection.class);
    private static final Set<String> LDAP_BINARY_SYNTAX_ATTRS = CollectionUtil.newCaseInsensitiveSet();
    private static final Set<String> LDAP_BINARY_OPTION_ATTRS;
    private static final String LDAP_CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String LDAP_CTX_SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    private static final Log LOG;
    private final AdConfiguration config;
    private final LdapSchemaMapping schemaMapping;
    private LdapContext initCtx;
    private StartTlsResponse startTlsResponse;
    private Set<String> supportedControls;
    private ServerType serverType;

    public AdConnection(AdConfiguration config) {
        this.config = config;
        this.schemaMapping = new LdapSchemaMapping(this);
    }

    public String format(String key, String dflt, Object ... args) {
        return this.config.getConnectorMessages().format(key, dflt, args);
    }

    public AdConfiguration getConfiguration() {
        return this.config;
    }

    public LdapContext getInitialContext() {
        if (this.initCtx != null) {
            return this.initCtx;
        }
        this.initCtx = this.connect(this.config.getPrincipal(), this.config.getCredentials());
        return this.initCtx;
    }

    private LdapContext connect(String principal, GuardedString credentials) {
        Pair<AuthenticationResult, LdapContext> pair = this.config.isStartTLS() ? this.createContextWithStartTLS(principal, credentials) : this.createContext(principal, credentials);
        if (((AuthenticationResult)pair.first).getType().equals((Object)AuthenticationResultType.SUCCESS)) {
            return (LdapContext)pair.second;
        }
        ((AuthenticationResult)pair.first).propagate();
        throw new ConnectorUnKnownException("Should never get here");
    }

    private Pair<AuthenticationResult, LdapContext> createContext(String principal, GuardedString credentials) {
        ArrayList<Pair<AuthenticationResult, LdapContext>> result = new ArrayList<Pair<AuthenticationResult, LdapContext>>(1);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", LDAP_CTX_FACTORY);
        env.put("java.naming.provider.url", this.getLdapUrls());
        env.put("java.naming.referral", "follow");
        env.put("com.sun.jndi.ldap.connect.timeout", Long.toString(this.config.getConnectTimeout()));
        env.put("com.sun.jndi.ldap.read.timeout", Long.toString(this.config.getReadTimeout()));
        if ("objectGUID".equals(this.config.getUidAttribute())) {
            env.put("java.naming.ldap.attributes.binary", "objectGUID");
        }
        if (this.config.isSsl()) {
            env.put("java.naming.security.protocol", "ssl");
            if (this.config.isVerifyingCertificate()) {
                SimpleVerifyingSSLSocketFactory.init(this.config.getProtocolVersion());
                env.put(LDAP_CTX_SOCKET_FACTORY, SimpleVerifyingSSLSocketFactory.class.getName());
            } else {
                NonVerifyingSSLSocketFactory.init(this.config.getProtocolVersion());
                env.put(LDAP_CTX_SOCKET_FACTORY, NonVerifyingSSLSocketFactory.class.getName());
            }
            env.remove("com.sun.jndi.ldap.connect.timeout");
        }
        String authentication = StringUtil.isNotBlank((String)principal) ? "simple" : "none";
        env.put("java.naming.security.authentication", authentication);
        if (StringUtil.isNotBlank((String)principal)) {
            env.put("java.naming.security.principal", principal);
            if (credentials != null) {
                credentials.access(clearChars -> {
                    env.put("java.naming.security.credentials", (String)clearChars);
                    result.add(this.createContext(env));
                });
                assert (!result.isEmpty());
            } else {
                result.add(this.createContext(env));
            }
        } else {
            result.add(this.createContext(env));
        }
        return (Pair)result.get(0);
    }

    private Pair<AuthenticationResult, LdapContext> createContextWithStartTLS(String principal, GuardedString credentials) {
        ArrayList<Pair<AuthenticationResult, LdapContext>> result = new ArrayList<Pair<AuthenticationResult, LdapContext>>(1);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", LDAP_CTX_FACTORY);
        env.put("java.naming.provider.url", this.getLdapUrls());
        env.put("java.naming.referral", "follow");
        env.put("com.sun.jndi.ldap.connect.timeout", Long.toString(this.config.getConnectTimeout()));
        env.put("com.sun.jndi.ldap.read.timeout", Long.toString(this.config.getReadTimeout()));
        if ("objectGUID".equals(this.config.getUidAttribute())) {
            env.put("java.naming.ldap.attributes.binary", "objectGUID");
        }
        InitialLdapContext ctx = null;
        try {
            ctx = new InitialLdapContext(env, null);
            this.startTlsResponse = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
            if (this.config.isVerifyingCertificate()) {
                this.startTlsResponse.setHostnameVerifier(new MyHostnameVerifier());
                SSLContext sslContext = SSLContext.getInstance(this.config.getProtocolVersion());
                X509TrustManager trustManager = this.getX509TrustManager();
                sslContext.init(null, new TrustManager[]{trustManager}, SecureRandom.getInstanceStrong());
                this.startTlsResponse.negotiate((SSLSocketFactory)new SSLSocketFactoryWrapper(sslContext.getSocketFactory(), TLSConstant.CIPHER_SUITES));
            } else {
                this.startTlsResponse.setHostnameVerifier(new SampleVerifier());
                NonStartTLSVerifyingSSLSocketFactory.init(this.config.getProtocolVersion());
                this.startTlsResponse.negotiate(NonStartTLSVerifyingSSLSocketFactory.getNonStartTLSVerifyingSSLSocketFactory());
            }
            String authentication = StringUtil.isNotBlank((String)principal) ? "simple" : "none";
            ctx.addToEnvironment("java.naming.security.authentication", authentication);
            if (StringUtil.isNotBlank((String)principal)) {
                ctx.addToEnvironment("java.naming.security.principal", principal);
                if (credentials != null) {
                    StringBuilder clearPwd = new StringBuilder();
                    credentials.access(clearChars -> clearPwd.append(clearChars));
                    ctx.addToEnvironment("java.naming.security.credentials", clearPwd.toString());
                    result.add(this.createContextByTLS(ctx));
                    assert (!result.isEmpty());
                } else {
                    result.add(this.createContextByTLS(ctx));
                }
            } else {
                result.add(this.createContextByTLS(ctx));
            }
        }
        catch (NamingException e) {
            logger.error(e.getMessage(), new Object[0]);
            throw new ConnectorException((Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), new Object[0]);
            throw new ConnectorException((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            logger.error(e.getMessage(), new Object[0]);
            throw new ConnectorException((Throwable)e);
        }
        return (Pair)result.get(0);
    }

    private Pair<AuthenticationResult, LdapContext> createContext(Hashtable<?, ?> env) {
        AuthenticationResult authnResult = null;
        InitialLdapContext context = null;
        try {
            context = new InitialLdapContext(env, null);
            if (this.config.isRespectResourcePasswordPolicyChangeAfterReset() && AdConnection.hasPasswordExpiredControl(context.getResponseControls())) {
                authnResult = new AuthenticationResult(AuthenticationResultType.PASSWORD_EXPIRED);
            }
        }
        catch (AuthenticationException e) {
            String message = e.getMessage().toLowerCase();
            authnResult = message.contains("password expired") ? new AuthenticationResult(AuthenticationResultType.PASSWORD_EXPIRED, e) : (message.contains("password has expired") ? new AuthenticationResult(AuthenticationResultType.PASSWORD_EXPIRED, e) : new AuthenticationResult(AuthenticationResultType.FAILED, e));
        }
        catch (NamingException e) {
            authnResult = new AuthenticationResult(AuthenticationResultType.FAILED, e);
        }
        if (authnResult == null) {
            assert (context != null);
            authnResult = new AuthenticationResult(AuthenticationResultType.SUCCESS);
        }
        return new Pair((Object)authnResult, (Object)context);
    }

    private Pair<AuthenticationResult, LdapContext> createContextByTLS(InitialLdapContext context) {
        AuthenticationResult authnResult = null;
        try {
            context.reconnect(null);
            if (this.config.isRespectResourcePasswordPolicyChangeAfterReset() && AdConnection.hasPasswordExpiredControl(context.getResponseControls())) {
                authnResult = new AuthenticationResult(AuthenticationResultType.PASSWORD_EXPIRED);
            }
        }
        catch (AuthenticationException e) {
            String message = e.getMessage().toLowerCase();
            authnResult = message.contains("password expired") ? new AuthenticationResult(AuthenticationResultType.PASSWORD_EXPIRED, e) : (message.contains("password has expired") ? new AuthenticationResult(AuthenticationResultType.PASSWORD_EXPIRED, e) : new AuthenticationResult(AuthenticationResultType.FAILED, e));
        }
        catch (NamingException e) {
            authnResult = new AuthenticationResult(AuthenticationResultType.FAILED, e);
        }
        if (authnResult == null) {
            assert (context != null);
            authnResult = new AuthenticationResult(AuthenticationResultType.SUCCESS);
        }
        return new Pair((Object)authnResult, (Object)context);
    }

    private static boolean hasPasswordExpiredControl(Control[] controls) {
        if (controls != null) {
            for (Control control : controls) {
                if (!(control instanceof PasswordExpiredResponseControl)) continue;
                return true;
            }
        }
        return false;
    }

    private String getLdapUrls() {
        if (IPV4Util.includePrivateIp((String)this.config.getHost())) {
            throw new ConfigurationException("ad.baseUrl.public.error");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("ldap://");
        builder.append(this.config.getHost());
        builder.append(':');
        builder.append(this.config.getPort());
        for (String failover : LdapUtil.nullAsEmpty(this.config.getFailover())) {
            builder.append(' ');
            builder.append(failover);
        }
        return builder.toString();
    }

    public void close() {
        this.quietCloseTLS();
        AdConnection.quietClose(this.initCtx);
    }

    private void quietCloseTLS() {
        new Thread(() -> {
            try {
                if (this.startTlsResponse != null) {
                    this.startTlsResponse.close();
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)e, null, new Object[0]);
            }
            finally {
                this.startTlsResponse = null;
            }
        }).start();
    }

    private static void quietClose(LdapContext ctx) {
        try {
            if (ctx != null) {
                ctx.close();
            }
        }
        catch (NamingException e) {
            LOG.warn((Throwable)e, null, new Object[0]);
        }
        finally {
            ctx = null;
        }
    }

    public LdapSchemaMapping getSchemaMapping() {
        return this.schemaMapping;
    }

    public LdapNativeSchema createNativeSchema() {
        try {
            if (this.config.isReadSchema()) {
                return new ServerNativeSchema(this);
            }
            return new StaticNativeSchema();
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public AuthenticationResult authenticate(String entryDN, GuardedString password) {
        Pair<AuthenticationResult, LdapContext> pair = null;
        AuthenticationResult as = null;
        if (entryDN != null) {
            LOG.ok("Attempting to authenticate {0}", new Object[]{entryDN});
            pair = this.createContext(entryDN, password);
            if (pair != null) {
                if (pair.second != null) {
                    AdConnection.quietClose((LdapContext)pair.second);
                }
                if (pair.first != null) {
                    as = (AuthenticationResult)pair.first;
                }
            }
            LOG.ok("Authentication result: {0}", new Object[]{as});
        }
        return as;
    }

    public void test() {
        this.config.validate();
        this.checkAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkAlive() {
        Socket connect = null;
        if (IPV4Util.includePrivateIp((String)this.config.getHost())) {
            throw new ConfigurationException("ad.baseUrl.public.error");
        }
        try {
            connect = new Socket();
            connect.connect(new InetSocketAddress(this.config.getHost(), this.config.getPort()), Integer.parseInt(Long.toString(this.getConfiguration().getConnectTimeout())));
        }
        catch (Exception e) {
            throw new ConnectionFailedException("ad.connection.address.access.error");
        }
        finally {
            if (connect != null) {
                try {
                    try {
                        connect.close();
                        connect = null;
                    }
                    catch (IOException e) {
                        try {
                            connect.close();
                        }
                        catch (IOException iOException) {}
                        connect = null;
                    }
                }
                catch (Throwable throwable) {
                    connect = null;
                    throw throwable;
                }
            }
        }
        try {
            String[] baseContexts;
            for (String baseDN : baseContexts = this.config.getBaseContexts()) {
                this.getInitialContext().search(baseDN, null, new String[]{this.config.getUidAttribute()});
            }
            return;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), new Object[0]);
            Throwable cause = e.getCause();
            if (null != cause) {
                cause = cause.getCause();
            }
            if (e instanceof NamingException) {
                ConnectorException connectorException = LdapErrorUtil.throwEx(e, this.config);
                if (connectorException == null) throw new APIFailedException((Throwable)e);
                throw connectorException;
            }
            if (cause instanceof SocketTimeoutException || cause instanceof UnknownHostException) {
                throw new ConnectionFailedException("ad.connection.address.access.error", (Throwable)e);
            }
            if (cause instanceof ConnectException) {
                throw new ConnectionFailedException("ad.address.error", (Throwable)e);
            }
            if (cause instanceof SSLHandshakeException || cause instanceof SocketException) throw new ConnectionFailedException("ad.ssl.connection.error", (Throwable)e);
            throw new ConnectionFailedException("ad.failed.obtain.data.according.configuration", (Throwable)e);
        }
    }

    public boolean supportsControl(String oid) {
        return this.getSupportedControls().contains(oid);
    }

    private Set<String> getSupportedControls() {
        if (this.supportedControls == null) {
            try {
                Attributes attrs = this.getInitialContext().getAttributes("", new String[]{"supportedControl"});
                this.supportedControls = Collections.unmodifiableSet(LdapUtil.getStringAttrValues(attrs, "supportedControl"));
            }
            catch (NamingException e) {
                LOG.warn((Throwable)e, "Exception while retrieving the supported controls", new Object[0]);
                this.supportedControls = Collections.emptySet();
            }
        }
        return this.supportedControls;
    }

    public ServerType getServerType() {
        if (this.serverType == null) {
            this.serverType = this.detectServerType();
        }
        return this.serverType;
    }

    private ServerType detectServerType() {
        try {
            Attributes attrs = this.getInitialContext().getAttributes("", new String[]{"vendorVersion"});
            String vendorVersion = LdapUtil.getStringAttrValue(attrs, "vendorVersion");
            if (vendorVersion != null) {
                if ((vendorVersion = vendorVersion.toLowerCase()).contains("opendj")) {
                    return ServerType.OPENDJ;
                }
                if (vendorVersion.contains("sun") && vendorVersion.contains("directory")) {
                    return ServerType.SUN_DSEE;
                }
            }
        }
        catch (NamingException e) {
            LOG.warn((Throwable)e, "Exception while detecting the server type", new Object[0]);
        }
        return ServerType.UNKNOWN;
    }

    public boolean needsBinaryOption(String attrName) {
        return LDAP_BINARY_OPTION_ATTRS.contains(attrName);
    }

    public boolean isBinarySyntax(String attrName) {
        return LDAP_BINARY_SYNTAX_ATTRS.contains(attrName);
    }

    private X509TrustManager getX509TrustManager() {
        X509TrustManager trustManager = null;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            trustManager = (X509TrustManager)trustManagers[0];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return trustManager;
    }

    static {
        LDAP_BINARY_SYNTAX_ATTRS.add("audio");
        LDAP_BINARY_SYNTAX_ATTRS.add("jpegPhoto");
        LDAP_BINARY_SYNTAX_ATTRS.add("photo");
        LDAP_BINARY_SYNTAX_ATTRS.add("personalSignature");
        LDAP_BINARY_SYNTAX_ATTRS.add("userPassword");
        LDAP_BINARY_SYNTAX_ATTRS.add("userCertificate");
        LDAP_BINARY_SYNTAX_ATTRS.add("caCertificate");
        LDAP_BINARY_SYNTAX_ATTRS.add("authorityRevocationList");
        LDAP_BINARY_SYNTAX_ATTRS.add("deltaRevocationList");
        LDAP_BINARY_SYNTAX_ATTRS.add("certificateRevocationList");
        LDAP_BINARY_SYNTAX_ATTRS.add("crossCertificatePair");
        LDAP_BINARY_SYNTAX_ATTRS.add("x500UniqueIdentifier");
        LDAP_BINARY_SYNTAX_ATTRS.add("supportedAlgorithms");
        LDAP_BINARY_SYNTAX_ATTRS.add("javaSerializedData");
        LDAP_BINARY_SYNTAX_ATTRS.add("thumbnailPhoto");
        LDAP_BINARY_SYNTAX_ATTRS.add("thumbnailLogo");
        LDAP_BINARY_OPTION_ATTRS = CollectionUtil.newCaseInsensitiveSet();
        LDAP_BINARY_OPTION_ATTRS.add("userCertificate");
        LDAP_BINARY_OPTION_ATTRS.add("caCertificate");
        LDAP_BINARY_OPTION_ATTRS.add("authorityRevocationList");
        LDAP_BINARY_OPTION_ATTRS.add("deltaRevocationList");
        LDAP_BINARY_OPTION_ATTRS.add("certificateRevocationList");
        LDAP_BINARY_OPTION_ATTRS.add("crossCertificatePair");
        LDAP_BINARY_OPTION_ATTRS.add("supportedAlgorithms");
        LOG = Log.getLog(AdConnection.class);
    }

    public static class AuthenticationResult {
        private final AuthenticationResultType type;
        private final Exception cause;

        public AuthenticationResult(AuthenticationResultType type) {
            this(type, null);
        }

        public AuthenticationResult(AuthenticationResultType type, Exception cause) {
            this.type = type;
            this.cause = cause;
        }

        public void propagate() {
            this.type.propagate(this.cause);
        }

        public AuthenticationResultType getType() {
            return this.type;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("AuthenticationResult[type: ").append((Object)this.type);
            if (this.cause != null) {
                result.append("; cause: ").append(this.cause.getMessage());
            }
            result.append(']');
            return result.toString();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum AuthenticationResultType {
        SUCCESS{

            @Override
            public void propagate(Exception cause) {
            }
        }
        ,
        PASSWORD_EXPIRED{

            @Override
            public void propagate(Exception cause) {
                throw new PasswordExpiredException((Throwable)cause);
            }
        }
        ,
        FAILED{

            @Override
            public void propagate(Exception cause) {
                throw new ConnectorSecurityException((Throwable)cause);
            }
        };


        public abstract void propagate(Exception var1);
    }

    class MyHostnameVerifier
    implements HostnameVerifier {
        MyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return HttpsURLConnection.getDefaultHostnameVerifier().verify(hostname, session);
        }
    }

    class SampleVerifier
    implements HostnameVerifier {
        SampleVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    public static enum ServerType {
        SUN_DSEE,
        OPENDJ,
        UNKNOWN;

    }
}

