/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.upstream.ad;

import com.bamboocloud.icf.common.logging.Log;
import com.bamboocloud.icf.common.security.GuardedString;
import com.bamboocloud.icf.connector.upstream.ad.AdAuthenticate;
import com.bamboocloud.icf.connector.upstream.ad.AdConfiguration;
import com.bamboocloud.icf.connector.upstream.ad.AdConnection;
import com.bamboocloud.icf.connector.upstream.ad.search.LdapFilter;
import com.bamboocloud.icf.connector.upstream.ad.search.LdapFilterTranslator;
import com.bamboocloud.icf.connector.upstream.ad.search.LdapSearch;
import com.bamboocloud.icf.connector.upstream.ad.sync.sunds.SunDSChangeLogSyncStrategy;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import com.bamboocloud.icf.framework.common.objects.OperationOptions;
import com.bamboocloud.icf.framework.common.objects.ResultsHandler;
import com.bamboocloud.icf.framework.common.objects.Schema;
import com.bamboocloud.icf.framework.common.objects.SyncResultsHandler;
import com.bamboocloud.icf.framework.common.objects.SyncToken;
import com.bamboocloud.icf.framework.common.objects.attributes.Uid;
import com.bamboocloud.icf.framework.common.objects.filter.FilterTranslator;
import com.bamboocloud.icf.framework.spi.Configuration;
import com.bamboocloud.icf.framework.spi.ConnectorClass;
import com.bamboocloud.icf.framework.spi.PoolableConnector;
import com.bamboocloud.icf.framework.spi.operations.AuthenticateOp;
import com.bamboocloud.icf.framework.spi.operations.ResolveUsernameOp;
import com.bamboocloud.icf.framework.spi.operations.SchemaOp;
import com.bamboocloud.icf.framework.spi.operations.SearchOp;
import com.bamboocloud.icf.framework.spi.operations.SyncOp;
import com.bamboocloud.icf.framework.spi.operations.TestOp;

@ConnectorClass(displayNameKey="AdConnector", configurationClass=AdConfiguration.class, ErrorMessageHandler=ConnectorClass.ErrorMessageHandlerEnum.NEW_ERROR_HANDLER, reconcilingModeSupport={ConnectorClass.ReconcilingModeSupportEnum.FULL_RECONCILING_MODE})
public class AdConnector
implements TestOp,
PoolableConnector,
SchemaOp,
SearchOp<LdapFilter>,
AuthenticateOp,
ResolveUsernameOp,
SyncOp {
    private AdConfiguration config;
    private AdConnection conn;
    private static final Log LOG = Log.getLog(AdConnector.class);

    public Configuration getConfiguration() {
        return this.config;
    }

    public void init(Configuration cfg) {
        this.config = (AdConfiguration)cfg;
        this.conn = new AdConnection(this.config);
    }

    public void dispose() {
        this.conn.close();
    }

    public void test() {
        this.conn.test();
    }

    public void checkAlive() {
        this.conn.checkAlive();
    }

    public Schema schema() {
        return this.conn.getSchemaMapping().schema();
    }

    public Uid authenticate(ObjectClass objectClass, String username, GuardedString password, OperationOptions options) {
        return new AdAuthenticate(this.conn, objectClass, username, options).authenticate(password);
    }

    public Uid resolveUsername(ObjectClass objectClass, String username, OperationOptions options) {
        return new AdAuthenticate(this.conn, objectClass, username, options).resolveUsername();
    }

    public FilterTranslator<LdapFilter> createFilterTranslator(ObjectClass oclass, OperationOptions options) {
        return new LdapFilterTranslator(this.conn.getSchemaMapping(), oclass);
    }

    public void executeQuery(ObjectClass oclass, LdapFilter query, ResultsHandler handler, OperationOptions options) {
        new LdapSearch(this.conn, oclass, query, handler, options).execute();
    }

    public SyncToken getLatestSyncToken(ObjectClass oclass) {
        return new SunDSChangeLogSyncStrategy(this.conn, oclass).getLatestSyncToken();
    }

    public void sync(ObjectClass oclass, SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        new SunDSChangeLogSyncStrategy(this.conn, oclass).sync(token, handler, options);
    }
}

