/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.upstream.ad.commons;

import com.bamboocloud.icf.common.logging.Log;
import com.bamboocloud.icf.connector.upstream.ad.commons.StatusManagement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;

public class DefaultStatusManagement
extends StatusManagement {
    private static final Log log = Log.getLog(DefaultStatusManagement.class);

    @Override
    public void setStatus(boolean status, Attributes ldapAttrs, List<String> posixGroups, List<String> ldapGroups) {
        Attribute attr = ldapAttrs.get("userAccountControl");
        if (attr == null || attr.size() == 0) {
            return;
        }
        try {
            int uac = Integer.parseInt(attr.get().toString());
            if (!status) {
                attr = new BasicAttribute("userAccountControl", this.setAccountDisabled(true, uac));
                ldapAttrs.put(attr);
            }
        }
        catch (NamingException e) {
            log.error("DefaultStatusManagement handles ad account disable/enable value error, message:" + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public Boolean getStatus(Attributes attributes, List<String> posixGroups, List<String> ldapGroups) {
        Attribute attr = attributes.get("userAccountControl");
        if (attr == null || attr.size() == 0) {
            return null;
        }
        boolean status = false;
        try {
            String userAccountControl = (String)attr.get();
            status = this.isAccountDisabled(userAccountControl);
        }
        catch (NamingException e) {
            log.error(e.getMessage(), new Object[0]);
        }
        return status;
    }

    @Override
    public Set<String> getOperationalAttributes() {
        return new HashSet<String>();
    }

    public boolean isAccountDisabled(String status) {
        return (Integer.parseInt(status) & 2) != 2;
    }

    public String setAccountDisabled(boolean enable, int uac) {
        uac = enable ? (uac |= 2) : (uac &= 0xFFFFFFFD);
        return Integer.toString(uac);
    }
}

