/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.upstream.ad.commons;

import com.bamboocloud.icf.common.security.GuardedString;
import com.bamboocloud.icf.framework.common.objects.AttributeInfo;
import com.bamboocloud.icf.framework.common.objects.AttributeInfoBuilder;
import com.bamboocloud.icf.framework.common.objects.OperationOptions;
import com.bamboocloud.icf.framework.common.objects.OperationalAttributes;
import java.util.EnumSet;

public class LdapConstants {
    public static final String LDAP_GROUPS_NAME = "ldapGroups";
    public static final String POSIX_GROUPS_NAME = "posixGroups";
    public static final String LDAP_UID_ATTRS_NAME = "ldap_uid_attributes";
    public static final String SEARCH_FILTER_NAME = "searchFilter";
    public static final String OP_SEARCH_FILTER = "searchFilter";
    public static final String MS_GUID_ATTR = "objectGUID";
    public static final String MS_ENTRYUUID_ATTR = "entryUUID";
    public static final String CONNECT_TIMEOUT_ENV_PROP = "com.sun.jndi.ldap.connect.timeout";
    public static final String READ_TIMEOUT_ENV_PROP = "com.sun.jndi.ldap.read.timeout";
    public static final String ATTRIBUTES_ENV_BINARY = "java.naming.ldap.attributes.binary";
    public static final String ORGANIZATION_ID = "organizationId";
    public static final String PARENT_ID = "parentId";
    public static final String UF_ACCOUNT_DISABLE_CLASS = "DefaultStatusManagement";
    public static final String UACCONTROL_ATTR = "userAccountControl";
    public static final String USER_PRINCIPALNAME = "userPrincipalName";
    public static final String LDAP_ACC_GROUPS_NAME = "isMemberOf";
    public static final String AD_ACC_GROUPS_NAME = "memberOf";
    public static final String MANAGER = "manager";
    public static final int ADS_UF_SCRIPT = 1;
    public static final int ADS_UF_ACCOUNTDISABLE = 2;
    public static final int ADS_UF_HOMEDIR_REQUIRED = 8;
    public static final int ADS_UF_LOCKOUT = 16;
    public static final int ADS_UF_PASSWD_NOTREQD = 32;
    public static final int ADS_UF_PASSWD_CANT_CHANGE = 64;
    public static final int ADS_UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED = 128;
    public static final int ADS_UF_TEMP_DUPLICATE_ACCOUNT = 256;
    public static final int ADS_UF_NORMAL_ACCOUNT = 512;
    public static final int ADS_UF_INTERDOMAIN_TRUST_ACCOUNT = 2048;
    public static final int ADS_UF_WORKSTATION_TRUST_ACCOUNT = 4096;
    public static final int ADS_UF_SERVER_TRUST_ACCOUNT = 8192;
    public static final int ADS_UF_DONT_EXPIRE_PASSWD = 65536;
    public static final int ADS_UF_MNS_LOGON_ACCOUNT = 131072;
    public static final int ADS_UF_SMARTCARD_REQUIRED = 262144;
    public static final int ADS_UF_TRUSTED_FOR_DELEGATION = 524288;
    public static final int ADS_UF_NOT_DELEGATED = 0x100000;
    public static final int ADS_UF_USE_DES_KEY_ONLY = 0x200000;
    public static final int ADS_UF_DONT_REQUIRE_PREAUTH = 0x400000;
    public static final int ADS_UF_PASSWORD_EXPIRED = 0x800000;
    public static final int ADS_UF_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION = 0x1000000;
    public static final AttributeInfo PASSWORD = AttributeInfoBuilder.build((String)OperationalAttributes.PASSWORD_NAME, GuardedString.class, EnumSet.of(AttributeInfo.Flags.NOT_RETURNED_BY_DEFAULT));

    public static boolean isLdapGroups(String attrName) {
        return LDAP_GROUPS_NAME.equalsIgnoreCase(attrName);
    }

    public static boolean isPosixGroups(String attrName) {
        return POSIX_GROUPS_NAME.equalsIgnoreCase(attrName);
    }

    public static String[] getLdapUidAttributes(OperationOptions options) {
        return (String[])options.getOptions().get(LDAP_UID_ATTRS_NAME);
    }

    public static String getSearchFilter(OperationOptions options) {
        return (String)options.getOptions().get("searchFilter");
    }

    private LdapConstants() {
    }
}

