/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.upstream.ad.commons;

import com.bamboocloud.icf.common.CollectionUtil;
import com.bamboocloud.icf.connector.upstream.ad.commons.AppendingAttributes;
import com.bamboocloud.icf.connector.upstream.ad.commons.LdapUtil;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.naming.InvalidNameException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;

public abstract class LdapEntry {
    public static final Set<String> ENTRY_DN_ATTRS;

    public static LdapEntry create(String baseDN, SearchResult result) {
        return new SearchResultBased(baseDN, result);
    }

    public static LdapEntry create(String entryDN, Attributes attributes) {
        return new Simple(entryDN, attributes);
    }

    public static boolean isDNAttribute(String attrID) {
        return ENTRY_DN_ATTRS.contains(attrID);
    }

    public abstract Attributes getAttributes();

    public abstract LdapName getDN();

    private static LdapName join(String name, String baseDN) {
        LdapName result = LdapUtil.quietCreateLdapName(LdapEntry.cleanNameToParse(name));
        if (baseDN != null) {
            LdapName contextName = LdapUtil.quietCreateLdapName(baseDN);
            try {
                result.addAll(0, contextName);
            }
            catch (InvalidNameException e) {
                throw new ConnectorException((Throwable)e);
            }
        }
        return result;
    }

    private static String cleanNameToParse(String name) {
        String nameToParse = name;
        if (nameToParse.startsWith("\"")) {
            nameToParse = nameToParse.substring(1, nameToParse.length());
        }
        if (nameToParse.endsWith("\"")) {
            nameToParse = nameToParse.substring(0, nameToParse.length() - 1);
        }
        return nameToParse;
    }

    static {
        SortedSet set = CollectionUtil.newCaseInsensitiveSet();
        set.add("entryDN");
        set.add("dn");
        set.add("distinguishedName");
        ENTRY_DN_ATTRS = Collections.unmodifiableSet(set);
    }

    private static final class SearchResultBased
    extends LdapEntry {
        private final String baseDN;
        private final SearchResult result;
        private Attributes attributes;
        private LdapName dn;

        public SearchResultBased(String baseDN, SearchResult result) {
            assert (result != null);
            this.baseDN = baseDN;
            this.result = result;
        }

        @Override
        public Attributes getAttributes() {
            if (this.attributes == null) {
                this.attributes = new DNAttributes(this, this.result.getAttributes());
            }
            return this.attributes;
        }

        @Override
        public LdapName getDN() {
            if (this.dn == null) {
                this.dn = this.result.isRelative() ? LdapEntry.join(this.result.getName(), this.baseDN) : LdapEntry.join(this.getDNFromLdapUrl(this.result.getName()), null);
            }
            return this.dn;
        }

        private String getDNFromLdapUrl(String url) {
            int schemeEndPos = url.indexOf("://");
            if (schemeEndPos < 0) {
                return null;
            }
            int slashAfterHostPos = url.indexOf(47, schemeEndPos + 3);
            if (slashAfterHostPos < 0) {
                return null;
            }
            return url.substring(slashAfterHostPos + 1);
        }
    }

    private static final class Simple
    extends LdapEntry {
        private final String entryDN;
        private final Attributes attributes;
        private LdapName dn;

        public Simple(String entryDN, Attributes attributes) {
            assert (entryDN != null);
            assert (attributes != null);
            this.entryDN = entryDN;
            this.attributes = new DNAttributes(this, attributes);
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public LdapName getDN() {
            if (this.dn == null) {
                this.dn = LdapEntry.join(this.entryDN, null);
            }
            return this.dn;
        }
    }

    private static final class DNAttributes
    extends AppendingAttributes {
        private static final long serialVersionUID = 1L;
        private final LdapEntry ldapEntry;
        private final Map<String, Attribute> dnAttributes = CollectionUtil.newCaseInsensitiveMap();

        public DNAttributes(LdapEntry ldapEntry, Attributes delegate) {
            super(delegate);
            this.ldapEntry = ldapEntry;
        }

        @Override
        public Object clone() {
            return new DNAttributes(this.ldapEntry, (Attributes)this.delegate.clone());
        }

        @Override
        protected Attribute getAttributeToAppend(String attrID) {
            if (ENTRY_DN_ATTRS.contains(attrID)) {
                Attribute result = this.dnAttributes.get(attrID);
                if (result == null) {
                    result = new BasicAttribute(attrID, this.ldapEntry.getDN().toString());
                    this.dnAttributes.put(attrID, result);
                }
                return result;
            }
            return null;
        }

        @Override
        protected Set<String> getAttributeIDsToAppend() {
            return ENTRY_DN_ATTRS;
        }
    }
}

