/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.upstream.ad.commons;

import com.bamboocloud.icf.common.StringUtil;
import com.bamboocloud.icf.connector.upstream.ad.AdConfiguration;
import com.bamboocloud.icf.connector.upstream.ad.commons.LdapErrorCode;
import com.bamboocloud.icf.framework.common.exceptions.APIFailedException;
import com.bamboocloud.icf.framework.common.exceptions.ConfigurationException;
import com.bamboocloud.icf.framework.common.exceptions.ConnectionFailedException;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorException;
import com.bamboocloud.icf.framework.common.exceptions.PermissionDeniedException;

public class LdapErrorUtil {
    private static ConnectorException throwException(String ldapErrorCode, String massage) {
        return switch (ldapErrorCode) {
            case "1", "4", "5", "6", "9", "10", "14", "16", "17", "18", "19", "20", "21", "32", "33", "35", "36", "48", "51", "52", "53", "54", "64", "65", "66", "67", "68", "69", "71", "80" -> new APIFailedException(massage);
            case "2", "12", "13" -> new ConfigurationException(massage);
            case "3", "34", "49" -> new ConnectionFailedException(massage);
            case "7", "8", "11", "50" -> new PermissionDeniedException(massage);
            default -> new APIFailedException(massage);
        };
    }

    public static ConnectorException throwEx(Exception exception, AdConfiguration config) {
        Object message = exception.getMessage();
        if (StringUtil.isNotEmpty((String)message) && ((String)message).contains("LDAP: error code")) {
            String ldapMessage = ((String)message).substring(((String)message).indexOf("LDAP: error code") + 16);
            String code = ldapMessage.substring(0, ldapMessage.indexOf("-")).trim();
            if (config != null) {
                if (code.equals("32") && ((String)message).length() > 14) {
                    message = ((String)message).substring(((String)message).lastIndexOf("best match of:") + 14);
                }
                message = config.getConnectorMessages().format(LdapErrorCode.ldapMessageMap.get(code), null, new Object[0]) + "\uff1a" + (String)message;
            }
            return LdapErrorUtil.throwException(code, (String)message);
        }
        return null;
    }
}

